/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.lifecycle;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.eclipse.EclipsePlugin;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.writers.EclipseClasspathWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseProjectWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseSettingsWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWriterConfig;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.ops4j.pax.construct.lifecycle.ProvisionMojo;
import org.ops4j.pax.construct.util.DirUtils;
import org.ops4j.pax.construct.util.PomUtils;
import org.ops4j.pax.construct.util.ReflectMojo;
import org.ops4j.pax.construct.util.StreamFactory;

public class EclipseOSGiMojo
extends EclipsePlugin {
    private MavenProjectBuilder m_mavenProjectBuilder;
    private Maven2OsgiConverter m_maven2OsgiConverter;
    private String fixDependencies;
    private ReflectMojo m_eclipseMojo;
    private MavenProject m_provisionProject;
    private List m_embeddableDependencies;

    public boolean setup() throws MojoExecutionException {
        this.setExecutedProject(this.project);
        if (null != this.m_provisionProject) {
            this.enablePDE();
        } else if (PomUtils.isBundleProject(this.executedProject)) {
            this.enablePDE();
            this.setUseProjectReferences(false);
        } else if (ProvisionMojo.isProvisioningPom(this.executedProject)) {
            try {
                this.setupImportedBundles();
            }
            catch (InvalidDependencyVersionException e) {
                this.getLog().warn((CharSequence)("Unable to generate Eclipse files for project " + this.executedProject.getId()));
            }
            return false;
        }
        return super.setup();
    }

    private void enablePDE() {
        if (null == this.m_eclipseMojo) {
            this.m_eclipseMojo = new ReflectMojo((AbstractMojo)this, EclipsePlugin.class);
        }
        this.m_eclipseMojo.setField("pde", Boolean.TRUE);
        this.setWtpversion("none");
        List containers = this.getClasspathContainers();
        if (null != containers && !containers.contains("org.eclipse.pde.core.requiredPlugins")) {
            containers.add("org.eclipse.pde.core.requiredPlugins");
        }
    }

    public void writeConfiguration(IdeDependency[] deps) throws MojoExecutionException {
        if (!this.isPdeProject()) {
            super.writeConfiguration(deps);
        } else {
            this.m_embeddableDependencies = new ArrayList();
            if (null == this.m_provisionProject) {
                this.writeBundleConfiguration(deps);
            } else {
                this.writeImportedConfiguration();
            }
        }
    }

    private void writeBundleConfiguration(IdeDependency[] deps) throws MojoExecutionException {
        for (int i = 0; i < deps.length; ++i) {
            if (!deps[i].isAddedToClasspath()) continue;
            if (!deps[i].isTestDependency() && !deps[i].isProvided()) {
                this.m_embeddableDependencies.add(deps[i]);
            }
            deps[i] = this.fixOSGiTestDependency(deps[i]);
        }
        EclipseWriterConfig config = this.createEclipseWriterConfig(deps);
        config.setEclipseProjectName(EclipseOSGiMojo.getEclipseProjectName(this.executedProject, true));
        new EclipseSettingsWriter().init(this.getLog(), config).write();
        new EclipseClasspathWriter().init(this.getLog(), config).write();
        new EclipseProjectWriter().init(this.getLog(), config).write();
        this.refactorForEclipse(this.getBundleFile(this.executedProject));
        this.writeAdditionalConfig();
    }

    private File getBundleFile(MavenProject bundleProject) {
        Artifact artifact = bundleProject.getArtifact();
        File bundleFile = artifact.getFile();
        if (null == bundleFile || !bundleFile.exists()) {
            String name = bundleProject.getBuild().getFinalName() + ".jar";
            bundleFile = new File(bundleProject.getBuild().getDirectory(), name);
        }
        if (!bundleFile.exists()) {
            PomUtils.getFile(artifact, this.artifactResolver, this.localRepository);
            bundleFile = artifact.getFile();
        }
        return bundleFile;
    }

    private IdeDependency fixOSGiTestDependency(IdeDependency dependency) {
        if ("FALSE".equalsIgnoreCase(this.fixDependencies)) {
            return dependency;
        }
        if ("EXTERNAL".equalsIgnoreCase(this.fixDependencies) && this.isReactorDependency(dependency)) {
            return dependency;
        }
        if ("CUSTOM".equalsIgnoreCase(this.fixDependencies)) {
            String id = dependency.getGroupId() + ':' + dependency.getArtifactId();
            File baseDir = this.executedProject.getBasedir();
            if (DirUtils.findPom(baseDir, id) != null) {
                return dependency;
            }
        }
        IdeDependency testDependency = new IdeDependency(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.isReferencedProject(), true, false, false, dependency.isAddedToClasspath(), dependency.getFile(), dependency.getType(), false, null, 0, dependency.getEclipseProjectName());
        testDependency.setSourceAttachment(dependency.getSourceAttachment());
        testDependency.setJavadocAttachment(dependency.getJavadocAttachment());
        return testDependency;
    }

    private boolean isReactorDependency(IdeDependency dependency) {
        if (this.reactorProjects != null) {
            Iterator i = this.reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject reactorProject = (MavenProject)i.next();
                if (!reactorProject.getGroupId().equals(dependency.getGroupId()) || !reactorProject.getArtifactId().equals(dependency.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }

    private static String getEclipseProjectName(MavenProject project, boolean addVersion) {
        String projectName = project.getProperties().getProperty("bundle.symbolicName");
        if (null == projectName) {
            projectName = PomUtils.getCompoundId(project.getGroupId(), project.getArtifactId());
        }
        if (addVersion) {
            String projectVersion = project.getProperties().getProperty("wrapped.version");
            if (null == projectVersion) {
                projectVersion = project.getVersion();
            }
            return projectName + " [" + projectVersion + ']';
        }
        return projectName;
    }

    private void refactorForEclipse(File bundleFile) {
        String tempPath = "target/pax-eclipse";
        boolean refactorManifest = false;
        File baseDir = this.executedProject.getBasedir();
        File unpackDir = new File(baseDir, tempPath);
        if (bundleFile == null || !bundleFile.exists()) {
            this.getLog().warn((CharSequence)"Bundle has not been built, reverting to basic behaviour");
        } else {
            DirUtils.unpackBundle(bundleFile, unpackDir, new IncludedContentFilter(this.getBuildOutputDirectory()));
            this.moveMetadata(unpackDir, "META-INF", baseDir);
            this.moveMetadata(unpackDir, "OSGI-INF", baseDir);
            unpackDir.delete();
            refactorManifest = unpackDir.exists();
        }
        File manifestFile = new File(baseDir, "META-INF/MANIFEST.MF");
        Manifest manifest = this.getBundleManifest(manifestFile);
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainAttributes.getValue("Bundle-SymbolicName") == null) {
            String name = EclipseOSGiMojo.getEclipseProjectName(this.executedProject, false);
            mainAttributes.putValue("Bundle-SymbolicName", name.replace('-', '_'));
        }
        String bundleClassPath = mainAttributes.getValue("Bundle-ClassPath");
        if (refactorManifest) {
            bundleClassPath = ".," + DirUtils.rebasePaths(bundleClassPath, tempPath, ',');
            mainAttributes.putValue("Bundle-ClassPath", bundleClassPath);
            this.addEmbeddedEntriesToEclipseClassPath(tempPath, bundleClassPath);
        }
        try {
            manifestFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(manifestFile);
            manifest.write(out);
            IOUtil.close((OutputStream)out);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to update Eclipse manifest: " + manifestFile));
        }
        this.createBuildProperties(baseDir, tempPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBuildProperties(File baseDir, String unpackPath) {
        File buildPropertiesFile = new File(baseDir, "build.properties");
        if (!buildPropertiesFile.exists()) {
            BufferedWriter writer;
            block9: {
                writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(buildPropertiesFile));
                    if (null != unpackPath) {
                        File sourceDir = new File(baseDir, "src/main/java");
                        if (sourceDir.exists()) {
                            writer.write("source.. = src/main/java/,src/main/resources/");
                            writer.newLine();
                        }
                        writer.write("output.. = target/classes/");
                        writer.newLine();
                        writer.write("bin.includes = META-INF/,.");
                        if (new File(baseDir, unpackPath).exists()) {
                            writer.write(',' + unpackPath + '/');
                        }
                        writer.newLine();
                        break block9;
                    }
                    File bundleFile = this.executedProject.getArtifact().getFile();
                    if (null != bundleFile && bundleFile.isFile()) {
                        writer.write("install.location = " + bundleFile.toURI());
                        writer.newLine();
                    }
                    writer.write("source.. = .");
                    writer.newLine();
                    writer.write("output.. = .");
                    writer.newLine();
                    writer.write("bin.includes = META-INF/,.");
                    writer.newLine();
                }
                catch (IOException e) {
                    try {
                        this.getLog().warn((CharSequence)"Unable to create build.properties file");
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(writer);
                        throw throwable;
                    }
                    IOUtil.close((Writer)writer);
                }
            }
            IOUtil.close((Writer)writer);
        }
    }

    private Manifest getBundleManifest(File manifestFile) {
        Manifest manifest = new Manifest();
        try {
            FileInputStream in = new FileInputStream(manifestFile);
            manifest.read(in);
            IOUtil.close((InputStream)in);
        }
        catch (IOException e) {
            Attributes mainAttributes = manifest.getMainAttributes();
            String osgiVersion = this.m_maven2OsgiConverter.getVersion(this.project.getVersion());
            mainAttributes.putValue("Manifest-Version", "1");
            mainAttributes.putValue("Bundle-ManifestVersion", "2");
            mainAttributes.putValue("Bundle-Name", this.project.getName());
            mainAttributes.putValue("Bundle-Version", osgiVersion);
            mainAttributes.putValue("Import-Package", "org.osgi.framework,org.osgi.util.tracker");
        }
        return manifest;
    }

    private void moveMetadata(File fromDir, String metadata, File toDir) {
        File metadataDir = new File(fromDir, metadata);
        if (metadataDir.exists()) {
            try {
                FileUtils.copyDirectoryStructure((File)metadataDir, (File)new File(toDir, metadata));
                FileUtils.deleteDirectory((File)metadataDir);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to copy " + metadata + " contents to base directory"));
            }
        }
    }

    private void addEmbeddedEntriesToEclipseClassPath(String bundleLocation, String bundleClassPath) {
        String[] classPath = bundleClassPath.split(",");
        File basedir = this.executedProject.getBasedir();
        try {
            File classPathFile = new File(basedir, ".classpath");
            Reader reader = StreamFactory.newXmlReader(classPathFile);
            Xpp3Dom classPathXML = Xpp3DomBuilder.build((Reader)reader);
            IOUtil.close((Reader)reader);
            for (int i = 0; i < classPath.length; ++i) {
                String binaryPath = classPath[i].trim();
                if (".".equals(binaryPath) || !new File(basedir, binaryPath).exists()) continue;
                Xpp3Dom classPathEntry = new Xpp3Dom("classpathentry");
                classPathEntry.setAttribute("exported", "true");
                classPathEntry.setAttribute("kind", "lib");
                classPathEntry.setAttribute("path", binaryPath);
                File sourcePath = this.findAttachedSource(bundleLocation, binaryPath);
                if (sourcePath != null) {
                    classPathEntry.setAttribute("sourcepath", sourcePath.getPath());
                }
                classPathXML.addChild(classPathEntry);
            }
            Writer writer = StreamFactory.newXmlWriter(classPathFile);
            Xpp3DomWriter.write((XMLWriter)new PrettyPrintXMLWriter(writer), (Xpp3Dom)classPathXML);
            IOUtil.close((Writer)writer);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Unable to find Eclipse .classpath file");
        }
        catch (XmlPullParserException e) {
            this.getLog().warn((CharSequence)"Unable to parse Eclipse .classpath file");
        }
    }

    private File findAttachedSource(String bundleLocation, String classPathEntry) {
        Iterator i = this.m_embeddableDependencies.iterator();
        while (i.hasNext()) {
            IdeDependency dependency = (IdeDependency)i.next();
            if (bundleLocation.equals(classPathEntry)) {
                return dependency.getSourceAttachment();
            }
            if (!Pattern.matches("^.*[/\\\\]" + dependency.getArtifactId() + "[-.][^/\\\\]*$", classPathEntry)) continue;
            return dependency.getSourceAttachment();
        }
        return null;
    }

    private void setupImportedBundles() throws InvalidDependencyVersionException, MojoExecutionException {
        this.m_provisionProject = this.getExecutedProject();
        this.setResolveDependencies(false);
        Set artifacts = this.m_provisionProject.createArtifacts(this.artifactFactory, null, null);
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            File groupDir = new File(this.m_provisionProject.getBasedir(), "target/" + artifact.getGroupId());
            File baseDir = new File(groupDir, artifact.getArtifactId() + '-' + artifact.getVersion());
            if (!PomUtils.downloadFile(artifact, this.artifactResolver, this.remoteArtifactRepositories, this.localRepository)) {
                this.getLog().warn((CharSequence)("Skipping missing bundle " + artifact));
                continue;
            }
            DirUtils.unpackBundle(artifact.getFile(), baseDir, null);
            MavenProject dependencyProject = this.writeProjectPom(baseDir, artifact);
            if (null == dependencyProject) {
                this.getLog().warn((CharSequence)("Skipping missing bundle " + artifact));
                continue;
            }
            dependencyProject.setArtifact(artifact);
            this.setExecutedProject(dependencyProject);
            this.setProject(dependencyProject);
            this.setBuildOutputDirectory(new File(baseDir, ".ignore"));
            this.setEclipseProjectDir(baseDir);
            try {
                this.getLog().info((CharSequence)("Generating Eclipse project for bundle " + artifact));
                this.execute();
            }
            catch (MojoFailureException e) {
                this.getLog().warn((CharSequence)("Problem generating Eclipse files for artifact " + artifact));
            }
        }
    }

    private MavenProject writeProjectPom(File baseDir, Artifact artifact) {
        MavenProject pom = null;
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        Artifact pomArtifact = this.artifactFactory.createProjectArtifact(groupId, artifactId, version);
        try {
            pom = this.m_mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteArtifactRepositories, this.localRepository);
            File pomFile = new File(baseDir, "pom.xml");
            Writer writer = StreamFactory.newXmlWriter(pomFile);
            pom.writeModel(writer);
            pom.setFile(pomFile);
            IOUtil.close((Writer)writer);
        }
        catch (ProjectBuildingException e) {
            this.getLog().warn((CharSequence)("Unable to build POM for artifact " + pomArtifact));
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to write POM for artifact " + pomArtifact));
        }
        return pom;
    }

    private void writeImportedConfiguration() throws MojoExecutionException {
        EclipseWriterConfig config = this.createEclipseWriterConfig(new IdeDependency[0]);
        config.setEclipseProjectName(EclipseOSGiMojo.getEclipseProjectName(this.executedProject, true));
        config.setClasspathContainers(Collections.EMPTY_LIST);
        config.setSourceDirs(new EclipseSourceDir[0]);
        new EclipseClasspathWriter().init(this.getLog(), config).write();
        new EclipseProjectWriter().init(this.getLog(), config).write();
        Artifact sourceArtifact = this.artifactFactory.createArtifactWithClassifier(this.executedProject.getGroupId(), this.executedProject.getArtifactId(), this.executedProject.getVersion(), "java-source", "sources");
        if (this.downloadSources) {
            PomUtils.downloadFile(sourceArtifact, this.artifactResolver, this.remoteArtifactRepositories, this.localRepository);
        } else {
            PomUtils.getFile(sourceArtifact, this.artifactResolver, this.localRepository);
        }
        this.attachImportedContent(sourceArtifact.getFile());
        String baseDir = this.executedProject.getBasedir().getPath();
        File manifestFile = new File(baseDir, "META-INF/MANIFEST.MF");
        Manifest manifest = this.getBundleManifest(manifestFile);
        Attributes mainAttributes = manifest.getMainAttributes();
        String bundleClassPath = mainAttributes.getValue("Bundle-ClassPath");
        if (null != bundleClassPath) {
            this.addEmbeddedEntriesToEclipseClassPath(baseDir, bundleClassPath);
        }
        this.createBuildProperties(new File(baseDir), null);
    }

    private void attachImportedContent(File sources) {
        try {
            File classPathFile = new File(this.executedProject.getBasedir(), ".classpath");
            Reader reader = StreamFactory.newXmlReader(classPathFile);
            Xpp3Dom classPathXML = Xpp3DomBuilder.build((Reader)reader);
            IOUtil.close((Reader)reader);
            Xpp3Dom classPathEntry = new Xpp3Dom("classpathentry");
            classPathEntry.setAttribute("exported", "true");
            classPathEntry.setAttribute("kind", "lib");
            classPathEntry.setAttribute("path", ".");
            if (sources != null && sources.exists()) {
                classPathEntry.setAttribute("sourcepath", sources.getPath());
            }
            classPathXML.addChild(classPathEntry);
            Writer writer = StreamFactory.newXmlWriter(classPathFile);
            Xpp3DomWriter.write((XMLWriter)new PrettyPrintXMLWriter(writer), (Xpp3Dom)classPathXML);
            IOUtil.close((Writer)writer);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Unable to find Eclipse .classpath file");
        }
        catch (XmlPullParserException e) {
            this.getLog().warn((CharSequence)"Unable to parse Eclipse .classpath file");
        }
    }

    private static class IncludedContentFilter
    implements DirUtils.EntryFilter {
        private final File m_outputDir;

        public IncludedContentFilter(File outputDir) {
            this.m_outputDir = outputDir;
        }

        public boolean accept(String name) {
            if (name.startsWith("META-INF") || name.startsWith("OSGI-INF")) {
                return true;
            }
            if (name.endsWith(".jar")) {
                return true;
            }
            return !new File(this.m_outputDir, name).exists();
        }
    }
}

