/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.lifecycle;

import java.io.File;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractCompilerMojo;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.CompilationFailureException;
import org.apache.maven.plugin.CompilerMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.ops4j.pax.construct.lifecycle.SqueakyCleanMojo;
import org.ops4j.pax.construct.util.DirUtils;
import org.ops4j.pax.construct.util.ReflectMojo;

public class BundleCompilerMojo
extends CompilerMojo {
    private MavenProject m_project;

    protected List getClasspathElements() {
        File outputDir = this.getOutputDirectory();
        List classpath = super.getClasspathElements();
        File tempDir = new File(outputDir.getParent(), "pax-compiler");
        return DirUtils.expandOSGiClassPath(outputDir, classpath, tempDir);
    }

    public void execute() throws MojoExecutionException, CompilationFailureException {
        BundleCompilerMojo.mergeCompilerConfiguration((AbstractCompilerMojo)this, this.m_project);
        try {
            super.execute();
        }
        catch (CompilationFailureException e) {
            SqueakyCleanMojo.recoverMetaData((AbstractMojo)this);
            throw e;
        }
    }

    protected static void mergeCompilerConfiguration(AbstractCompilerMojo mojo, MavenProject project) {
        Plugin core = new Plugin();
        core.setGroupId("org.apache.maven.plugins");
        core.setArtifactId("maven-compiler-plugin");
        Plugin pax = new Plugin();
        pax.setGroupId("org.ops4j");
        pax.setArtifactId("maven-pax-plugin");
        project.addPlugin(core);
        project.addPlugin(pax);
        Xpp3Dom coreConfig = project.getGoalConfiguration(core.getGroupId(), core.getArtifactId(), null, null);
        Xpp3Dom paxConfig = project.getGoalConfiguration(pax.getGroupId(), pax.getArtifactId(), null, null);
        if (null != coreConfig) {
            ReflectMojo baseMojo = new ReflectMojo((AbstractMojo)mojo, AbstractCompilerMojo.class);
            Xpp3Dom[] configuration = coreConfig.getChildren();
            for (int i = 0; i < configuration.length; ++i) {
                String value;
                String name = configuration[i].getName();
                if (null != paxConfig && null != paxConfig.getChild(name) || !baseMojo.hasField(name) || null == (value = configuration[i].getValue())) continue;
                mojo.getLog().debug((CharSequence)("Using compiler setting: " + name + "=" + value));
                baseMojo.setField(name, value);
            }
        }
    }
}

