/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.ReactionRole;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;

public class ReactionManipulator {
    public static int getAtomCount(IReaction reaction) {
        int count = 0;
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            count += reactants.getAtomContainer(i).getAtomCount();
        }
        IAtomContainerSet agents = reaction.getAgents();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            count += agents.getAtomContainer(i).getAtomCount();
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            count += products.getAtomContainer(i).getAtomCount();
        }
        return count;
    }

    public static int getBondCount(IReaction reaction) {
        int count = 0;
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            count += reactants.getAtomContainer(i).getBondCount();
        }
        IAtomContainerSet agents = reaction.getAgents();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            count += agents.getAtomContainer(i).getBondCount();
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            count += products.getAtomContainer(i).getBondCount();
        }
        return count;
    }

    public static void removeAtomAndConnectedElectronContainers(IReaction reaction, IAtom atom) {
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IAtomContainer mol = reactants.getAtomContainer(i);
            if (!mol.contains(atom)) continue;
            mol.removeAtom(atom);
        }
        IAtomContainerSet agents = reaction.getReactants();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            IAtomContainer mol = agents.getAtomContainer(i);
            if (!mol.contains(atom)) continue;
            mol.removeAtom(atom);
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IAtomContainer mol = products.getAtomContainer(i);
            if (!mol.contains(atom)) continue;
            mol.removeAtom(atom);
        }
    }

    public static void removeElectronContainer(IReaction reaction, IElectronContainer electrons) {
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IAtomContainer mol = reactants.getAtomContainer(i);
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
        IAtomContainerSet agents = reaction.getReactants();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            IAtomContainer mol = agents.getAtomContainer(i);
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IAtomContainer mol = products.getAtomContainer(i);
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
    }

    public static IAtomContainerSet getAllMolecules(IReaction reaction) {
        IAtomContainerSet moleculeSet = (IAtomContainerSet)reaction.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        moleculeSet.add(ReactionManipulator.getAllReactants(reaction));
        moleculeSet.add(ReactionManipulator.getAllAgents(reaction));
        moleculeSet.add(ReactionManipulator.getAllProducts(reaction));
        return moleculeSet;
    }

    public static IAtomContainerSet getAllProducts(IReaction reaction) {
        IAtomContainerSet moleculeSet = (IAtomContainerSet)reaction.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            moleculeSet.addAtomContainer(products.getAtomContainer(i));
        }
        return moleculeSet;
    }

    public static IAtomContainerSet getAllReactants(IReaction reaction) {
        IAtomContainerSet moleculeSet = (IAtomContainerSet)reaction.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            moleculeSet.addAtomContainer(reactants.getAtomContainer(i));
        }
        return moleculeSet;
    }

    public static IAtomContainerSet getAllAgents(IReaction reaction) {
        IAtomContainerSet moleculeSet = (IAtomContainerSet)reaction.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainerSet agents = reaction.getAgents();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            moleculeSet.addAtomContainer(agents.getAtomContainer(i));
        }
        return moleculeSet;
    }

    public static IReaction reverse(IReaction reaction) {
        IReaction reversedReaction = (IReaction)reaction.getBuilder().newInstance(IReaction.class, new Object[0]);
        if (reaction.getDirection() == IReaction.Direction.BIDIRECTIONAL) {
            reversedReaction.setDirection(IReaction.Direction.BIDIRECTIONAL);
        } else if (reaction.getDirection() == IReaction.Direction.FORWARD) {
            reversedReaction.setDirection(IReaction.Direction.BACKWARD);
        } else if (reaction.getDirection() == IReaction.Direction.BACKWARD) {
            reversedReaction.setDirection(IReaction.Direction.FORWARD);
        }
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            double coefficient = reaction.getReactantCoefficient(reactants.getAtomContainer(i));
            reversedReaction.addProduct(reactants.getAtomContainer(i), Double.valueOf(coefficient));
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            double coefficient = reaction.getProductCoefficient(products.getAtomContainer(i));
            reversedReaction.addReactant(products.getAtomContainer(i), Double.valueOf(coefficient));
        }
        return reversedReaction;
    }

    public static List<IAtomContainer> getAllAtomContainers(IReaction reaction) {
        return MoleculeSetManipulator.getAllAtomContainers(ReactionManipulator.getAllMolecules(reaction));
    }

    public static List<String> getAllIDs(IReaction reaction) {
        ArrayList<String> idList = new ArrayList<String>();
        if (reaction.getID() != null) {
            idList.add(reaction.getID());
        }
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IAtomContainer mol = reactants.getAtomContainer(i);
            idList.addAll(AtomContainerManipulator.getAllIDs(mol));
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IAtomContainer mol = products.getAtomContainer(i);
            idList.addAll(AtomContainerManipulator.getAllIDs(mol));
        }
        return idList;
    }

    public static IAtomContainer getRelevantAtomContainer(IReaction reaction, IAtom atom) {
        IAtomContainer result = MoleculeSetManipulator.getRelevantAtomContainer(reaction.getReactants(), atom);
        if (result != null) {
            return result;
        }
        return MoleculeSetManipulator.getRelevantAtomContainer(reaction.getProducts(), atom);
    }

    public static IAtomContainer getRelevantAtomContainer(IReaction reaction, IBond bond) {
        IAtomContainer result = MoleculeSetManipulator.getRelevantAtomContainer(reaction.getReactants(), bond);
        if (result != null) {
            return result;
        }
        return MoleculeSetManipulator.getRelevantAtomContainer(reaction.getProducts(), bond);
    }

    public static void setAtomProperties(IReaction reaction, Object propKey, Object propVal) {
        IAtomContainerSet reactants = reaction.getReactants();
        for (int j = 0; j < reactants.getAtomContainerCount(); ++j) {
            AtomContainerManipulator.setAtomProperties(reactants.getAtomContainer(j), propKey, propVal);
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int j = 0; j < products.getAtomContainerCount(); ++j) {
            AtomContainerManipulator.setAtomProperties(products.getAtomContainer(j), propKey, propVal);
        }
    }

    public static List<IChemObject> getAllChemObjects(IReaction reaction) {
        ArrayList<IChemObject> list = new ArrayList<IChemObject>();
        list.add((IChemObject)reaction);
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            list.add((IChemObject)reactants.getAtomContainer(i));
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            list.add((IChemObject)products.getAtomContainer(i));
        }
        return list;
    }

    public static IChemObject getMappedChemObject(IReaction reaction, IChemObject chemObject) {
        for (IMapping mapping : reaction.mappings()) {
            if (mapping.getChemObject(0).equals(chemObject)) {
                return mapping.getChemObject(1);
            }
            if (!mapping.getChemObject(1).equals(chemObject)) continue;
            return mapping.getChemObject(0);
        }
        return null;
    }

    private static void assignRoleAndGrp(IAtomContainer mol, ReactionRole role, int grpId) {
        for (IAtom atom : mol.atoms()) {
            atom.setProperty((Object)"cdk:ReactionRole", (Object)role);
            atom.setProperty((Object)"cdk:ReactionGroup", (Object)grpId);
        }
    }

    public static IAtomContainer toMolecule(IReaction rxn) {
        if (rxn == null) {
            throw new IllegalArgumentException("Null reaction provided");
        }
        IChemObjectBuilder bldr = rxn.getBuilder();
        IAtomContainer mol = (IAtomContainer)bldr.newInstance(IAtomContainer.class, new Object[0]);
        mol.setProperties(rxn.getProperties());
        mol.setID(rxn.getID());
        int grpId = 0;
        for (IAtomContainer comp : rxn.getReactants().atomContainers()) {
            ReactionManipulator.assignRoleAndGrp(comp, ReactionRole.Reactant, ++grpId);
            mol.add(comp);
        }
        for (IAtomContainer comp : rxn.getAgents().atomContainers()) {
            ReactionManipulator.assignRoleAndGrp(comp, ReactionRole.Agent, ++grpId);
            mol.add(comp);
        }
        for (IAtomContainer comp : rxn.getProducts().atomContainers()) {
            ReactionManipulator.assignRoleAndGrp(comp, ReactionRole.Product, ++grpId);
            mol.add(comp);
        }
        return mol;
    }

    public static IReaction toReaction(IAtomContainer mol) {
        Integer grpIdx;
        Integer grpIdx2;
        if (mol == null) {
            throw new IllegalArgumentException("Null molecule provided");
        }
        IChemObjectBuilder bldr = mol.getBuilder();
        IReaction rxn = (IReaction)bldr.newInstance(IReaction.class, new Object[0]);
        rxn.setProperties(mol.getProperties());
        rxn.setID(mol.getID());
        HashMap<Integer, IAtomContainer> components = new HashMap<Integer, IAtomContainer>();
        for (IAtom atom : mol.atoms()) {
            ReactionRole role = (ReactionRole)atom.getProperty((Object)"cdk:ReactionRole");
            grpIdx2 = (Integer)atom.getProperty((Object)"cdk:ReactionGroup");
            if (role == null || role == ReactionRole.None) {
                throw new IllegalArgumentException("Atom " + mol.indexOf(atom) + " had undefined role");
            }
            if (grpIdx2 == null) {
                throw new IllegalArgumentException("Atom " + mol.indexOf(atom) + " had no reaction group id");
            }
            IAtomContainer comp = (IAtomContainer)components.get(grpIdx2);
            if (comp == null) {
                comp = (IAtomContainer)bldr.newInstance(IAtomContainer.class, new Object[]{20, 20, 0, 0});
                components.put(grpIdx2, comp);
                switch (role) {
                    case Reactant: {
                        rxn.addReactant(comp);
                        break;
                    }
                    case Product: {
                        rxn.addProduct(comp);
                        break;
                    }
                    case Agent: {
                        rxn.addAgent(comp);
                    }
                }
            }
            comp.addAtom(atom);
        }
        for (IBond bond : mol.bonds()) {
            IAtom beg = bond.getBegin();
            IAtom end = bond.getEnd();
            Integer begIdx = (Integer)beg.getProperty((Object)"cdk:ReactionGroup");
            Integer endIdx = (Integer)end.getProperty((Object)"cdk:ReactionGroup");
            if (begIdx == null || endIdx == null) {
                throw new IllegalArgumentException("Bond " + mol.indexOf(bond) + " had atoms with no reaction group id");
            }
            if (!begIdx.equals(endIdx)) {
                throw new IllegalArgumentException("Bond " + mol.indexOf(bond) + " had atoms with different reaction group id");
            }
            ((IAtomContainer)components.get(begIdx)).addBond(bond);
        }
        for (IStereoElement se : mol.stereoElements()) {
            IAtom focus = null;
            if (se instanceof ITetrahedralChirality) {
                focus = ((ITetrahedralChirality)se).getChiralAtom();
            } else if (se instanceof IDoubleBondStereochemistry) {
                focus = ((IDoubleBondStereochemistry)se).getStereoBond().getBegin();
            } else if (se instanceof ExtendedTetrahedral) {
                focus = ((ExtendedTetrahedral)se).focus();
            }
            if (focus == null) {
                throw new IllegalArgumentException("Stereochemistry had no focus");
            }
            grpIdx2 = (Integer)focus.getProperty((Object)"cdk:ReactionGroup");
            ((IAtomContainer)components.get(grpIdx2)).addStereoElement(se);
        }
        for (IStereoElement se : mol.singleElectrons()) {
            grpIdx = (Integer)se.getAtom().getProperty((Object)"cdk:ReactionGroup");
            ((IAtomContainer)components.get(grpIdx)).addSingleElectron((ISingleElectron)se);
        }
        for (ILonePair lp : mol.lonePairs()) {
            grpIdx = (Integer)lp.getAtom().getProperty((Object)"cdk:ReactionGroup");
            ((IAtomContainer)components.get(grpIdx)).addLonePair(lp);
        }
        return rxn;
    }

    public static Set<IBond> findMappedBonds(IReaction reaction) {
        Integer endidx;
        Integer begidx;
        HashSet<IBond> mapped = new HashSet<IBond>();
        HashSet<IntTuple> mappedReactantBonds = new HashSet<IntTuple>();
        HashSet<IntTuple> mappedProductBonds = new HashSet<IntTuple>();
        for (IAtomContainer reactant : reaction.getReactants().atomContainers()) {
            for (IBond bond : reactant.bonds()) {
                begidx = (Integer)bond.getBegin().getProperty((Object)"cdk:AtomAtomMapping");
                endidx = (Integer)bond.getEnd().getProperty((Object)"cdk:AtomAtomMapping");
                if (begidx == null || endidx == null) continue;
                mappedReactantBonds.add(new IntTuple(begidx, endidx));
            }
        }
        if (mappedReactantBonds.isEmpty()) {
            return Collections.emptySet();
        }
        for (IAtomContainer product : reaction.getProducts().atomContainers()) {
            for (IBond bond : product.bonds()) {
                begidx = (Integer)bond.getBegin().getProperty((Object)"cdk:AtomAtomMapping");
                endidx = (Integer)bond.getEnd().getProperty((Object)"cdk:AtomAtomMapping");
                if (begidx == null || endidx == null) continue;
                mappedProductBonds.add(new IntTuple(begidx, endidx));
            }
        }
        if (mappedProductBonds.isEmpty()) {
            return Collections.emptySet();
        }
        for (IAtomContainer reactant : reaction.getReactants().atomContainers()) {
            for (IBond bond : reactant.bonds()) {
                begidx = (Integer)bond.getBegin().getProperty((Object)"cdk:AtomAtomMapping");
                endidx = (Integer)bond.getEnd().getProperty((Object)"cdk:AtomAtomMapping");
                if (begidx == null || endidx == null || !mappedProductBonds.contains(new IntTuple(begidx, endidx))) continue;
                mapped.add(bond);
            }
        }
        for (IAtomContainer product : reaction.getProducts().atomContainers()) {
            for (IBond bond : product.bonds()) {
                begidx = (Integer)bond.getBegin().getProperty((Object)"cdk:AtomAtomMapping");
                endidx = (Integer)bond.getEnd().getProperty((Object)"cdk:AtomAtomMapping");
                if (begidx == null || endidx == null || !mappedReactantBonds.contains(new IntTuple(begidx, endidx))) continue;
                mapped.add(bond);
            }
        }
        return mapped;
    }

    public static void perceiveAtomTypesAndConfigureAtoms(IReaction reaction) throws CDKException {
        if (reaction == null) {
            return;
        }
        for (IAtomContainer atomContainer : ReactionManipulator.getAllMolecules(reaction).atomContainers()) {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
        }
    }

    public static void perceiveAtomTypesAndConfigureUnsetProperties(IReaction reaction) throws CDKException {
        if (reaction == null) {
            return;
        }
        for (IAtomContainer atomContainer : ReactionManipulator.getAllMolecules(reaction).atomContainers()) {
            AtomContainerManipulator.percieveAtomTypesAndConfigureUnsetProperties(atomContainer);
        }
    }

    public static void clearAtomConfigurations(IReaction reaction) {
        if (reaction == null) {
            return;
        }
        for (IAtomContainer atomContainer : ReactionManipulator.getAllMolecules(reaction).atomContainers()) {
            AtomContainerManipulator.clearAtomConfigurations(atomContainer);
        }
    }

    private static final class IntTuple {
        private final int beg;
        private final int end;

        public IntTuple(int beg, int end) {
            this.beg = beg;
            this.end = end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntTuple that = (IntTuple)o;
            return this.beg == that.beg && this.end == that.end || this.beg == that.end && this.end == that.beg;
        }

        public int hashCode() {
            return this.beg ^ this.end;
        }
    }
}

