/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.List;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class HBondAcceptorCountDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private static final String[] NAMES = new String[]{"nHBAcc"};

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#hBondacceptors", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("HBondAcceptorCountDescriptor expects a single parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(0), this.getDescriptorNames(), e);
    }

    public DescriptorValue calculate(IAtomContainer atomContainer) {
        IAtomContainer ac;
        int hBondAcceptors = 0;
        try {
            ac = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)ac);
                Aromaticity.cdkLegacy().apply(ac);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue((Exception)((Object)e));
            }
        }
        block4: for (IAtom atom : ac.atoms()) {
            if (atom.getAtomicNumber() == 7 && atom.getFormalCharge() <= 0) {
                List bonds = ac.getConnectedBondsList(atom);
                int nPiBonds = 0;
                for (IBond bond : bonds) {
                    if (bond.getOther(atom).getAtomicNumber() == 8) continue block4;
                    if (!IBond.Order.DOUBLE.equals((Object)bond.getOrder())) continue;
                    ++nPiBonds;
                }
                if (atom.getFlag(32) && nPiBonds == 0) continue;
                ++hBondAcceptors;
                continue;
            }
            if (atom.getAtomicNumber() != 8 || atom.getFormalCharge() > 0) continue;
            List neighbours = ac.getConnectedBondsList(atom);
            for (IBond bond : neighbours) {
                IAtom neighbor = bond.getOther(atom);
                if (neighbor.getAtomicNumber() != 7 && (neighbor.getAtomicNumber() != 6 || !neighbor.isAromatic() || bond.getOrder() == IBond.Order.DOUBLE)) continue;
                continue block4;
            }
            ++hBondAcceptors;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(hBondAcceptors), this.getDescriptorNames());
    }

    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    public Object getParameterType(String name) {
        return false;
    }
}

