/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.charges.Polarizability;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.AdjacencyMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

public class AutocorrelationDescriptorPolarizability
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"ATSp1", "ATSp2", "ATSp3", "ATSp4", "ATSp5"};

    private static double[] listpolarizability(IAtomContainer container, int[][] dmat) throws CDKException {
        int natom = container.getAtomCount();
        double[] polars = new double[natom];
        Polarizability polar = new Polarizability();
        for (int i = 0; i < natom; ++i) {
            IAtom atom = container.getAtom(i);
            try {
                polars[i] = polar.calculateGHEffectiveAtomPolarizability(container, atom, false, dmat);
                continue;
            }
            catch (Exception ex1) {
                throw new CDKException("Problems with assign Polarizability due to " + ex1.toString(), (Throwable)ex1);
            }
        }
        return polars;
    }

    public DescriptorValue calculate(IAtomContainer container) {
        IAtomContainer molecule;
        try {
            molecule = container.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Error occurred during clone " + e)));
        }
        try {
            CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)molecule.getBuilder());
            for (IAtom atom : molecule.atoms()) {
                IAtomType type = matcher.findMatchingAtomType(molecule, atom);
                AtomTypeManipulator.configure((IAtom)atom, (IAtomType)type);
            }
            CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)molecule.getBuilder());
            hAdder.addImplicitHydrogens(molecule);
            AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)molecule);
        }
        catch (Exception e) {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Could not add hydrogens: " + e.getMessage(), (Throwable)e)));
        }
        try {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)molecule);
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Could not percieve atom types: " + e.getMessage(), (Throwable)e)));
        }
        try {
            Aromaticity.cdkLegacy().apply(molecule);
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Could not percieve aromaticity: " + e.getMessage(), (Throwable)e)));
        }
        int[][] distancematrix = PathTools.computeFloydAPSP((int[][])AdjacencyMatrix.getMatrix((IAtomContainer)molecule));
        try {
            double[] w = AutocorrelationDescriptorPolarizability.listpolarizability(molecule, distancematrix);
            int natom = molecule.getAtomCount();
            double[] polarizabilitySum = new double[5];
            for (int k = 0; k < 5; ++k) {
                for (int i = 0; i < natom; ++i) {
                    if (molecule.getAtom(i).getAtomicNumber() == 1) continue;
                    for (int j = 0; j < natom; ++j) {
                        if (molecule.getAtom(j).getAtomicNumber() == 1) continue;
                        if (distancematrix[i][j] == k) {
                            int n = k;
                            polarizabilitySum[n] = polarizabilitySum[n] + w[i] * w[j];
                            continue;
                        }
                        int n = k;
                        polarizabilitySum[n] = polarizabilitySum[n] + 0.0;
                    }
                }
                if (k <= 0) continue;
                polarizabilitySum[k] = polarizabilitySum[k] / 2.0;
            }
            DoubleArrayResult result = new DoubleArrayResult(5);
            for (double aPolarizabilitySum : polarizabilitySum) {
                result.add(aPolarizabilitySum);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)result, this.getDescriptorNames());
        }
        catch (Exception ex) {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Error while calculating the ATSpolarizabilty descriptor: " + ex.getMessage(), (Throwable)ex)));
        }
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        DoubleArrayResult results = new DoubleArrayResult(5);
        for (int i = 0; i < 5; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)results, this.getDescriptorNames(), e);
    }

    public String[] getParameterNames() {
        return null;
    }

    public Object getParameterType(String name) {
        return null;
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#autoCorrelationPolarizability", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(5);
    }

    public void setParameters(Object[] params) throws CDKException {
    }
}

