/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.libio.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.libio.jena.CDK;

public class Convertor {
    private static final Map<IAtomType.Hybridization, Resource> HYBRID_TO_RESOURCE = new HashMap<IAtomType.Hybridization, Resource>(10){
        private static final long serialVersionUID = 1027415392461000485L;
        {
            this.put(IAtomType.Hybridization.S, CDK.HYBRID_S);
            this.put(IAtomType.Hybridization.SP1, CDK.HYBRID_SP1);
            this.put(IAtomType.Hybridization.SP2, CDK.HYBRID_SP2);
            this.put(IAtomType.Hybridization.SP3, CDK.HYBRID_SP3);
            this.put(IAtomType.Hybridization.PLANAR3, CDK.HYBRID_PLANAR3);
            this.put(IAtomType.Hybridization.SP3D1, CDK.HYBRID_SP3D1);
            this.put(IAtomType.Hybridization.SP3D2, CDK.HYBRID_SP3D2);
            this.put(IAtomType.Hybridization.SP3D3, CDK.HYBRID_SP3D3);
            this.put(IAtomType.Hybridization.SP3D4, CDK.HYBRID_SP3D4);
            this.put(IAtomType.Hybridization.SP3D5, CDK.HYBRID_SP3D5);
        }
    };
    private static final Map<Resource, IAtomType.Hybridization> RESOURCE_TO_HYBRID = new HashMap<Resource, IAtomType.Hybridization>(10){
        private static final long serialVersionUID = -351285511820100853L;
        {
            this.put(CDK.HYBRID_S, IAtomType.Hybridization.S);
            this.put(CDK.HYBRID_SP1, IAtomType.Hybridization.SP1);
            this.put(CDK.HYBRID_SP2, IAtomType.Hybridization.SP2);
            this.put(CDK.HYBRID_SP3, IAtomType.Hybridization.SP3);
            this.put(CDK.HYBRID_PLANAR3, IAtomType.Hybridization.PLANAR3);
            this.put(CDK.HYBRID_SP3D1, IAtomType.Hybridization.SP3D1);
            this.put(CDK.HYBRID_SP3D2, IAtomType.Hybridization.SP3D2);
            this.put(CDK.HYBRID_SP3D3, IAtomType.Hybridization.SP3D3);
            this.put(CDK.HYBRID_SP3D4, IAtomType.Hybridization.SP3D4);
            this.put(CDK.HYBRID_SP3D5, IAtomType.Hybridization.SP3D5);
        }
    };

    public static Model molecule2Model(IAtomContainer molecule) {
        Model model = Convertor.createCDKModel();
        Resource subject = model.createResource(Convertor.createIdentifier(model, (IChemObject)molecule));
        model.add(subject, RDF.type, (RDFNode)CDK.MOLECULE);
        HashMap<IAtom, Resource> cdkToRDFAtomMap = new HashMap<IAtom, Resource>();
        for (IAtom atom : molecule.atoms()) {
            Resource rdfAtom = model.createResource(Convertor.createIdentifier(model, (IChemObject)atom));
            cdkToRDFAtomMap.put(atom, rdfAtom);
            model.add(subject, CDK.HASATOM, (RDFNode)rdfAtom);
            if (atom instanceof IPseudoAtom) {
                model.add(rdfAtom, RDF.type, (RDFNode)CDK.PSEUDOATOM);
                Convertor.serializePseudoAtomFields(model, rdfAtom, (IPseudoAtom)atom);
                continue;
            }
            model.add(rdfAtom, RDF.type, (RDFNode)CDK.ATOM);
            Convertor.serializeAtomFields(model, rdfAtom, atom);
        }
        for (IBond bond : molecule.bonds()) {
            Resource rdfBond = model.createResource(Convertor.createIdentifier(model, (IChemObject)bond));
            model.add(rdfBond, RDF.type, (RDFNode)CDK.BOND);
            for (IAtom atom : bond.atoms()) {
                model.add(rdfBond, CDK.BINDSATOM, (RDFNode)cdkToRDFAtomMap.get(atom));
            }
            if (bond.getOrder() != null) {
                model.add(rdfBond, CDK.HASORDER, (RDFNode)Convertor.order2Resource(bond.getOrder()));
            }
            model.add(subject, CDK.HASBOND, (RDFNode)rdfBond);
            Convertor.serializeElectronContainerFields(model, rdfBond, (IElectronContainer)bond);
        }
        return model;
    }

    private static void serializePseudoAtomFields(Model model, Resource rdfAtom, IPseudoAtom atom) {
        Convertor.serializeAtomFields(model, rdfAtom, (IAtom)atom);
        if (atom.getLabel() != CDKConstants.UNSET) {
            model.add(rdfAtom, CDK.HASLABEL, atom.getLabel());
        }
    }

    private static void serializeAtomFields(Model model, Resource rdfAtom, IAtom atom) {
        Convertor.serializeAtomTypeFields(model, rdfAtom, (IAtomType)atom);
        model.add(rdfAtom, RDF.type, (RDFNode)CDK.ATOM);
        if (atom.getSymbol() != CDKConstants.UNSET) {
            model.add(rdfAtom, CDK.SYMBOL, atom.getSymbol());
        }
    }

    private static void serializeElectronContainerFields(Model model, Resource rdfBond, IElectronContainer bond) {
        Convertor.serializeChemObjectFields(model, rdfBond, (IChemObject)bond);
        if (bond.getElectronCount() != null) {
            model.add(rdfBond, CDK.HASELECTRONCOUNT, bond.getElectronCount().toString());
        }
    }

    private static void serializeChemObjectFields(Model model, Resource rdfObject, IChemObject object) {
        if (object.getID() != null) {
            model.add(rdfObject, CDK.IDENTIFIER, object.getID());
        }
    }

    private static void deserializeChemObjectFields(Resource rdfObject, IChemObject object) {
        Statement identifier = rdfObject.getProperty(CDK.IDENTIFIER);
        if (identifier != null) {
            object.setID(identifier.getString());
        }
    }

    private static void serializeElementFields(Model model, Resource rdfObject, IElement element) {
        Convertor.serializeChemObjectFields(model, rdfObject, (IChemObject)element);
        if (element.getSymbol() != null) {
            model.add(rdfObject, CDK.SYMBOL, element.getSymbol());
        }
        if (element.getAtomicNumber() != null) {
            model.add(rdfObject, CDK.HASATOMICNUMBER, element.getAtomicNumber().toString());
        }
    }

    private static void deserializeElementFields(Resource rdfObject, IElement element) {
        Statement atomicNumber;
        Convertor.deserializeChemObjectFields(rdfObject, (IChemObject)element);
        Statement symbol = rdfObject.getProperty(CDK.SYMBOL);
        if (symbol != null) {
            element.setSymbol(symbol.getString());
        }
        if ((atomicNumber = rdfObject.getProperty(CDK.HASATOMICNUMBER)) != null) {
            element.setAtomicNumber(Integer.valueOf(atomicNumber.getInt()));
        }
    }

    private static void serializeAtomTypeFields(Model model, Resource rdfObject, IAtomType type) {
        IAtomType.Hybridization hybrid;
        Convertor.serializeIsotopeFields(model, rdfObject, (IIsotope)type);
        if (type.getHybridization() != null && HYBRID_TO_RESOURCE.containsKey(hybrid = type.getHybridization())) {
            model.add(rdfObject, CDK.HASHYBRIDIZATION, (RDFNode)HYBRID_TO_RESOURCE.get(hybrid));
        }
        if (type.getAtomTypeName() != null) {
            model.add(rdfObject, CDK.HASATOMTYPENAME, type.getAtomTypeName());
        }
        if (type.getFormalCharge() != null) {
            model.add(rdfObject, CDK.HASFORMALCHARGE, type.getFormalCharge().toString());
        }
        if (type.getMaxBondOrder() != null) {
            model.add(rdfObject, CDK.HASMAXBONDORDER, (RDFNode)Convertor.order2Resource(type.getMaxBondOrder()));
        }
    }

    private static void serializeIsotopeFields(Model model, Resource rdfObject, IIsotope isotope) {
        Convertor.serializeElementFields(model, rdfObject, (IElement)isotope);
        if (isotope.getMassNumber() != CDKConstants.UNSET) {
            model.add(rdfObject, CDK.HASMASSNUMBER, isotope.getMassNumber().toString());
        }
        if (isotope.getExactMass() != CDKConstants.UNSET) {
            model.add(rdfObject, CDK.HASEXACTMASS, isotope.getExactMass().toString());
        }
        if (isotope.getNaturalAbundance() != CDKConstants.UNSET) {
            model.add(rdfObject, CDK.HASNATURALABUNDANCE, isotope.getNaturalAbundance().toString());
        }
    }

    private static void deserializeAtomTypeFields(Resource rdfObject, IAtomType element) {
        Statement formalCharge;
        Statement order;
        Statement name;
        Resource rdfHybrid;
        Convertor.deserializeIsotopeFields(rdfObject, (IIsotope)element);
        Statement hybrid = rdfObject.getProperty(CDK.HASHYBRIDIZATION);
        if (hybrid != null && RESOURCE_TO_HYBRID.containsKey(rdfHybrid = (Resource)hybrid.getObject())) {
            element.setHybridization(RESOURCE_TO_HYBRID.get(rdfHybrid));
        }
        if ((name = rdfObject.getProperty(CDK.HASATOMTYPENAME)) != null) {
            element.setAtomTypeName(name.getString());
        }
        if ((order = rdfObject.getProperty(CDK.HASMAXBONDORDER)) != null) {
            Resource maxOrder = order.getResource();
            element.setMaxBondOrder(Convertor.resource2Order(maxOrder));
        }
        if ((formalCharge = rdfObject.getProperty(CDK.HASFORMALCHARGE)) != null) {
            element.setFormalCharge(Integer.valueOf(formalCharge.getInt()));
        }
    }

    private static void deserializeIsotopeFields(Resource rdfObject, IIsotope isotope) {
        Statement naturalAbundance;
        Statement exactMass;
        Convertor.deserializeElementFields(rdfObject, (IElement)isotope);
        Statement massNumber = rdfObject.getProperty(CDK.HASMASSNUMBER);
        if (massNumber != null) {
            isotope.setMassNumber(Integer.valueOf(massNumber.getInt()));
        }
        if ((exactMass = rdfObject.getProperty(CDK.HASEXACTMASS)) != null) {
            isotope.setExactMass(Double.valueOf(exactMass.getDouble()));
        }
        if ((naturalAbundance = rdfObject.getProperty(CDK.HASNATURALABUNDANCE)) != null) {
            isotope.setNaturalAbundance(Double.valueOf(naturalAbundance.getDouble()));
        }
    }

    public static IBond.Order resource2Order(Resource rdfOrder) {
        if (rdfOrder.equals((Object)CDK.SINGLEBOND)) {
            return IBond.Order.SINGLE;
        }
        if (rdfOrder.equals((Object)CDK.DOUBLEBOND)) {
            return IBond.Order.DOUBLE;
        }
        if (rdfOrder.equals((Object)CDK.TRIPLEBOND)) {
            return IBond.Order.TRIPLE;
        }
        if (rdfOrder.equals((Object)CDK.QUADRUPLEBOND)) {
            return IBond.Order.QUADRUPLE;
        }
        return null;
    }

    public static Resource order2Resource(IBond.Order order) {
        if (order == IBond.Order.SINGLE) {
            return CDK.SINGLEBOND;
        }
        if (order == IBond.Order.DOUBLE) {
            return CDK.DOUBLEBOND;
        }
        if (order == IBond.Order.TRIPLE) {
            return CDK.TRIPLEBOND;
        }
        if (order == IBond.Order.QUADRUPLE) {
            return CDK.QUADRUPLEBOND;
        }
        return null;
    }

    private static String createIdentifier(Model model, IChemObject object) {
        StringBuilder result = new StringBuilder();
        result.append("http://example.com/");
        result.append(model.hashCode()).append('/');
        result.append(object.getClass().getSimpleName()).append('/');
        result.append(object.hashCode());
        return result.toString();
    }

    private static void deserializeElectronContainerFields(Resource rdfObject, IElectronContainer bond) {
        Convertor.deserializeChemObjectFields(rdfObject, (IChemObject)bond);
        Statement count = rdfObject.getProperty(CDK.HASELECTRONCOUNT);
        if (count != null) {
            bond.setElectronCount(Integer.valueOf(count.getInt()));
        }
    }

    public static IAtomContainer model2Molecule(Model model, IChemObjectBuilder builder) {
        ResIterator mols = model.listSubjectsWithProperty(RDF.type, (RDFNode)CDK.MOLECULE);
        IAtomContainer mol = null;
        if (mols.hasNext()) {
            Resource rdfMol = (Resource)mols.next();
            mol = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
            HashMap<Resource, IAtom> rdfToCDKAtomMap = new HashMap<Resource, IAtom>();
            StmtIterator atoms = rdfMol.listProperties(CDK.HASATOM);
            while (atoms.hasNext()) {
                IAtom atom;
                Resource rdfAtom = atoms.nextStatement().getResource();
                if (rdfAtom.hasProperty(RDF.type, (RDFNode)CDK.PSEUDOATOM)) {
                    atom = (IAtom)builder.newInstance(IPseudoAtom.class, new Object[0]);
                    atom.setStereoParity(Integer.valueOf(0));
                    Statement label = rdfAtom.getProperty(CDK.HASLABEL);
                    if (label != null) {
                        ((IPseudoAtom)atom).setLabel(label.getString());
                    }
                } else {
                    atom = (IAtom)builder.newInstance(IAtom.class, new Object[0]);
                }
                Statement symbol = rdfAtom.getProperty(CDK.SYMBOL);
                if (symbol != null) {
                    atom.setSymbol(symbol.getString());
                }
                rdfToCDKAtomMap.put(rdfAtom, atom);
                Convertor.deserializeAtomTypeFields(rdfAtom, (IAtomType)atom);
                mol.addAtom(atom);
            }
            StmtIterator bonds = rdfMol.listProperties(CDK.HASBOND);
            while (bonds.hasNext()) {
                Resource rdfBond = bonds.nextStatement().getResource();
                IBond bond = (IBond)builder.newInstance(IBond.class, new Object[0]);
                StmtIterator bondAtoms = rdfBond.listProperties(CDK.BINDSATOM);
                int atomCounter = 0;
                while (bondAtoms.hasNext()) {
                    Statement rdfAtom = bondAtoms.nextStatement();
                    IAtom atom = (IAtom)rdfToCDKAtomMap.get(rdfAtom.getResource());
                    bond.setAtom(atom, atomCounter);
                    ++atomCounter;
                }
                Resource order = rdfBond.getProperty(CDK.HASORDER).getResource();
                bond.setOrder(Convertor.resource2Order(order));
                mol.addBond(bond);
                Convertor.deserializeElectronContainerFields(rdfBond, (IElectronContainer)bond);
            }
        }
        return mol;
    }

    private static Model createCDKModel() {
        OntModel model = ModelFactory.createOntologyModel();
        model.setNsPrefix("cdk", "http://cdk.sourceforge.net/model.owl#");
        return model;
    }
}

