/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.pubchemxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.xml.stream.XMLStreamReader;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IPseudoAtom;

public class PubChemXMLHelper {
    private IChemObjectBuilder builder;
    private IsotopeFactory factory;
    public static final String EL_PCCOMPOUND = "PC-Compound";
    public static final String EL_PCCOMPOUNDS = "PC-Compounds";
    public static final String EL_PCSUBSTANCE = "PC-Substance";
    public static final String EL_PCSUBSTANCE_SID = "PC-Substance_sid";
    public static final String EL_PCCOMPOUND_ID = "PC-Compound_id";
    public static final String EL_PCCOMPOUND_CID = "PC-CompoundType_id_cid";
    public static final String EL_PCID_ID = "PC-ID_id";
    public static final String EL_ATOMBLOCK = "PC-Atoms";
    public static final String EL_ATOMSELEMENT = "PC-Atoms_element";
    public static final String EL_ATOMSCHARGE = "PC-Atoms_charge";
    public static final String EL_ATOMINT = "PC-AtomInt";
    public static final String EL_ATOMINT_AID = "PC-AtomInt_aid";
    public static final String EL_ATOMINT_VALUE = "PC-AtomInt_value";
    public static final String EL_ELEMENT = "PC-Element";
    public static final String EL_COORDINATESBLOCK = "PC-Compound_coords";
    public static final String EL_COORDINATES_AID = "PC-Coordinates_aid";
    public static final String EL_COORDINATES_AIDE = "PC-Coordinates_aid_E";
    public static final String EL_ATOM_CONFORMER = "PC-Conformer";
    public static final String EL_ATOM_CONFORMER_X = "PC-Conformer_x";
    public static final String EL_ATOM_CONFORMER_XE = "PC-Conformer_x_E";
    public static final String EL_ATOM_CONFORMER_Y = "PC-Conformer_y";
    public static final String EL_ATOM_CONFORMER_YE = "PC-Conformer_y_E";
    public static final String EL_ATOM_CONFORMER_Z = "PC-Conformer_z";
    public static final String EL_ATOM_CONFORMER_ZE = "PC-Conformer_z_E";
    public static final String EL_BONDBLOCK = "PC-Bonds";
    public static final String EL_BONDID1 = "PC-Bonds_aid1";
    public static final String EL_BONDID2 = "PC-Bonds_aid2";
    public static final String EL_BONDORDER = "PC-Bonds_order";
    public static final String EL_PROPSBLOCK = "PC-Compound_props";
    public static final String EL_PROPS_INFODATA = "PC-InfoData";
    public static final String EL_PROPS_URNLABEL = "PC-Urn_label";
    public static final String EL_PROPS_URNNAME = "PC-Urn_name";
    public static final String EL_PROPS_SVAL = "PC-InfoData_value_sval";
    public static final String EL_PROPS_FVAL = "PC-InfoData_value_fval";
    public static final String EL_PROPS_BVAL = "PC-InfoData_value_binary";

    public PubChemXMLHelper(IChemObjectBuilder builder) throws IOException {
        this.builder = builder;
        this.factory = Isotopes.getInstance();
    }

    public IAtomContainerSet parseCompoundsBlock(XMLStreamReader parser) throws Exception {
        IAtomContainerSet set = (IAtomContainerSet)this.builder.newInstance(IAtomContainerSet.class, new Object[0]);
        if (!parser.getLocalName().equals(EL_PCCOMPOUNDS)) {
            return null;
        }
        while (parser.next() != 8) {
            IAtomContainer molecule;
            if (parser.getEventType() == 2) {
                if (!EL_PCCOMPOUNDS.equals(parser.getLocalName())) continue;
                break;
            }
            if (parser.getEventType() != 1 || !EL_PCCOMPOUND.equals(parser.getLocalName()) || (molecule = this.parseMolecule(parser, this.builder)).getAtomCount() <= 0) continue;
            set.addAtomContainer(molecule);
        }
        return set;
    }

    public IChemModel parseSubstance(XMLStreamReader parser) throws Exception {
        IChemModel model = (IChemModel)this.builder.newInstance(IChemModel.class, new Object[0]);
        if (!parser.getLocalName().equals(EL_PCSUBSTANCE)) {
            return null;
        }
        while (parser.next() != 8) {
            if (parser.getEventType() == 2) {
                if (!EL_PCSUBSTANCE.equals(parser.getLocalName())) continue;
                break;
            }
            if (parser.getEventType() != 1) continue;
            if (EL_PCCOMPOUNDS.equals(parser.getLocalName())) {
                IAtomContainerSet set = this.parseCompoundsBlock(parser);
                model.setMoleculeSet(set);
                continue;
            }
            if (!EL_PCSUBSTANCE_SID.equals(parser.getLocalName())) continue;
            String sid = this.getSID(parser);
            model.setProperty((Object)"cdk:Title", (Object)sid);
        }
        return model;
    }

    public String getSID(XMLStreamReader parser) throws Exception {
        String sid = "unknown";
        while (parser.next() != 8) {
            if (parser.getEventType() == 2) {
                if (!EL_PCSUBSTANCE_SID.equals(parser.getLocalName())) continue;
                break;
            }
            if (parser.getEventType() != 1 || !EL_PCID_ID.equals(parser.getLocalName())) continue;
            sid = parser.getElementText();
        }
        return sid;
    }

    public String getCID(XMLStreamReader parser) throws Exception {
        String cid = "unknown";
        while (parser.next() != 8) {
            if (parser.getEventType() == 2) {
                if (!EL_PCCOMPOUND_ID.equals(parser.getLocalName())) continue;
                break;
            }
            if (parser.getEventType() != 1 || !EL_PCCOMPOUND_CID.equals(parser.getLocalName())) continue;
            cid = parser.getElementText();
        }
        return cid;
    }

    public void parseAtomElements(XMLStreamReader parser, IAtomContainer molecule) throws Exception {
        while (parser.next() != 8) {
            IAtom atom;
            if (parser.getEventType() == 2) {
                if (!EL_ATOMSELEMENT.equals(parser.getLocalName())) continue;
                break;
            }
            if (parser.getEventType() != 1 || !EL_ELEMENT.equals(parser.getLocalName())) continue;
            int atomicNumber = Integer.parseInt(parser.getElementText());
            IElement element = this.factory.getElement(atomicNumber);
            if (element == null) {
                atom = (IAtom)molecule.getBuilder().newInstance(IPseudoAtom.class, new Object[0]);
                molecule.addAtom(atom);
                continue;
            }
            atom = (IAtom)molecule.getBuilder().newInstance(IAtom.class, new Object[]{element.getSymbol()});
            atom.setAtomicNumber(element.getAtomicNumber());
            molecule.addAtom(atom);
        }
    }

    public void parserAtomBlock(XMLStreamReader parser, IAtomContainer molecule) throws Exception {
        while (parser.next() != 8) {
            if (parser.getEventType() == 2) {
                if (!EL_ATOMBLOCK.equals(parser.getLocalName())) continue;
                break;
            }
            if (parser.getEventType() != 1) continue;
            if (EL_ATOMSELEMENT.equals(parser.getLocalName())) {
                this.parseAtomElements(parser, molecule);
                continue;
            }
            if (!EL_ATOMSCHARGE.equals(parser.getLocalName())) continue;
            this.parseAtomCharges(parser, molecule);
        }
    }

    public void parserCompoundInfoData(XMLStreamReader parser, IAtomContainer molecule) throws Exception {
        String urnLabel = null;
        String urnName = null;
        String sval = null;
        while (parser.next() != 8) {
            if (parser.getEventType() == 2) {
                if (!EL_PROPS_INFODATA.equals(parser.getLocalName())) continue;
                break;
            }
            if (parser.getEventType() != 1) continue;
            if (EL_PROPS_URNNAME.equals(parser.getLocalName())) {
                urnName = parser.getElementText();
                continue;
            }
            if (EL_PROPS_URNLABEL.equals(parser.getLocalName())) {
                urnLabel = parser.getElementText();
                continue;
            }
            if (EL_PROPS_SVAL.equals(parser.getLocalName())) {
                sval = parser.getElementText();
                continue;
            }
            if (EL_PROPS_FVAL.equals(parser.getLocalName())) {
                sval = parser.getElementText();
                continue;
            }
            if (!EL_PROPS_BVAL.equals(parser.getLocalName())) continue;
            sval = parser.getElementText();
        }
        if (urnLabel != null & sval != null) {
            String property = urnLabel + (urnName == null ? "" : " (" + urnName + ")");
            molecule.setProperty((Object)property, sval);
        }
    }

    public void parseAtomCharges(XMLStreamReader parser, IAtomContainer molecule) throws Exception {
        block0: while (parser.next() != 8) {
            if (parser.getEventType() == 2) {
                if (!EL_ATOMSCHARGE.equals(parser.getLocalName())) continue;
                break;
            }
            if (parser.getEventType() != 1 || !EL_ATOMINT.equals(parser.getLocalName())) continue;
            int aid = 0;
            int charge = 0;
            while (parser.next() != 8) {
                if (parser.getEventType() == 2) {
                    if (!EL_ATOMINT.equals(parser.getLocalName())) continue;
                    molecule.getAtom(aid - 1).setFormalCharge(Integer.valueOf(charge));
                    continue block0;
                }
                if (parser.getEventType() != 1) continue;
                if (EL_ATOMINT_AID.equals(parser.getLocalName())) {
                    aid = Integer.parseInt(parser.getElementText());
                    continue;
                }
                if (!EL_ATOMINT_VALUE.equals(parser.getLocalName())) continue;
                charge = Integer.parseInt(parser.getElementText());
            }
        }
    }

    public IAtomContainer parseMolecule(XMLStreamReader parser, IChemObjectBuilder builder) throws Exception {
        IAtomContainer molecule = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        if (!parser.getLocalName().equals(EL_PCCOMPOUND)) {
            return null;
        }
        while (parser.next() != 8) {
            if (parser.getEventType() == 2) {
                if (!EL_PCCOMPOUND.equals(parser.getLocalName())) continue;
                break;
            }
            if (parser.getEventType() != 1) continue;
            if (EL_ATOMBLOCK.equals(parser.getLocalName())) {
                this.parserAtomBlock(parser, molecule);
                continue;
            }
            if (EL_BONDBLOCK.equals(parser.getLocalName())) {
                this.parserBondBlock(parser, molecule);
                continue;
            }
            if (EL_COORDINATESBLOCK.equals(parser.getLocalName())) {
                this.parserCoordBlock(parser, molecule);
                continue;
            }
            if (EL_PROPS_INFODATA.equals(parser.getLocalName())) {
                this.parserCompoundInfoData(parser, molecule);
                continue;
            }
            if (!EL_PCCOMPOUND_ID.equals(parser.getLocalName())) continue;
            String cid = this.getCID(parser);
            molecule.setProperty((Object)"PubChem CID", (Object)cid);
        }
        return molecule;
    }

    public void parserBondBlock(XMLStreamReader parser, IAtomContainer molecule) throws Exception {
        List<Object> id1s = new ArrayList();
        List<Object> id2s = new ArrayList();
        List<Object> orders = new ArrayList();
        while (parser.next() != 8) {
            if (parser.getEventType() == 2) {
                if (!EL_BONDBLOCK.equals(parser.getLocalName())) continue;
                break;
            }
            if (parser.getEventType() != 1) continue;
            if (EL_BONDID1.equals(parser.getLocalName())) {
                id1s = this.parseValues(parser, EL_BONDID1, "PC-Bonds_aid1_E");
                continue;
            }
            if (EL_BONDID2.equals(parser.getLocalName())) {
                id2s = this.parseValues(parser, EL_BONDID2, "PC-Bonds_aid2_E");
                continue;
            }
            if (!EL_BONDORDER.equals(parser.getLocalName())) continue;
            orders = this.parseValues(parser, EL_BONDORDER, "PC-BondType");
        }
        if (id1s.size() != id2s.size()) {
            throw new CDKException("Inequal number of atom identifier in bond block.");
        }
        if (id1s.size() != orders.size()) {
            throw new CDKException("Number of bond orders does not match number of bonds in bond block.");
        }
        for (int i = 0; i < id1s.size(); ++i) {
            IAtom atom1 = molecule.getAtom(Integer.parseInt((String)id1s.get(i)) - 1);
            IAtom atom2 = molecule.getAtom(Integer.parseInt((String)id2s.get(i)) - 1);
            IBond bond = (IBond)molecule.getBuilder().newInstance(IBond.class, new Object[]{atom1, atom2});
            int order = Integer.parseInt((String)orders.get(i));
            if (order == 1) {
                bond.setOrder(IBond.Order.SINGLE);
                molecule.addBond(bond);
            } else if (order == 2) {
                bond.setOrder(IBond.Order.DOUBLE);
                molecule.addBond(bond);
            }
            if (order != 3) continue;
            bond.setOrder(IBond.Order.TRIPLE);
            molecule.addBond(bond);
        }
    }

    public void parserCoordBlock(XMLStreamReader parser, IAtomContainer molecule) throws Exception {
        List<Object> ids = new ArrayList();
        List<Object> xs = new ArrayList();
        List<Object> ys = new ArrayList();
        List<Object> zs = new ArrayList();
        boolean parsedFirstConformer = false;
        while (parser.next() != 8) {
            if (parser.getEventType() == 2) {
                if (EL_COORDINATESBLOCK.equals(parser.getLocalName())) break;
                if (!EL_ATOM_CONFORMER.equals(parser.getLocalName())) continue;
                parsedFirstConformer = true;
                continue;
            }
            if (parser.getEventType() != 1 || parsedFirstConformer) continue;
            if (EL_COORDINATES_AID.equals(parser.getLocalName())) {
                ids = this.parseValues(parser, EL_COORDINATES_AID, EL_COORDINATES_AIDE);
                continue;
            }
            if (EL_ATOM_CONFORMER_X.equals(parser.getLocalName())) {
                xs = this.parseValues(parser, EL_ATOM_CONFORMER_X, EL_ATOM_CONFORMER_XE);
                continue;
            }
            if (EL_ATOM_CONFORMER_Y.equals(parser.getLocalName())) {
                ys = this.parseValues(parser, EL_ATOM_CONFORMER_Y, EL_ATOM_CONFORMER_YE);
                continue;
            }
            if (!EL_ATOM_CONFORMER_Z.equals(parser.getLocalName())) continue;
            zs = this.parseValues(parser, EL_ATOM_CONFORMER_Z, EL_ATOM_CONFORMER_ZE);
        }
        boolean has2dCoords = ids.size() == xs.size() && ids.size() == ys.size();
        boolean has3dCoords = has2dCoords && ids.size() == zs.size();
        for (int i = 0; i < ids.size(); ++i) {
            Point2d coord;
            IAtom atom = molecule.getAtom(Integer.parseInt((String)ids.get(i)) - 1);
            if (has3dCoords) {
                coord = new Point3d(Double.parseDouble((String)xs.get(i)), Double.parseDouble((String)ys.get(i)), Double.parseDouble((String)zs.get(i)));
                atom.setPoint3d((Point3d)coord);
                continue;
            }
            if (!has2dCoords) continue;
            coord = new Point2d(Double.parseDouble((String)xs.get(i)), Double.parseDouble((String)ys.get(i)));
            atom.setPoint2d(coord);
        }
    }

    private List<String> parseValues(XMLStreamReader parser, String endTag, String fieldTag) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        while (parser.next() != 8) {
            if (parser.getEventType() == 2) {
                if (!endTag.equals(parser.getLocalName())) continue;
                break;
            }
            if (parser.getEventType() != 1 || !fieldTag.equals(parser.getLocalName())) continue;
            String value = parser.getElementText();
            values.add(value);
        }
        return values;
    }
}

