/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.transport;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UncheckedIOException;
import org.openrewrite.jgit.errors.TransportException;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.transport.BasePackPushConnection;
import org.openrewrite.jgit.transport.PackTransport;
import org.openrewrite.jgit.transport.ReceivePack;
import org.openrewrite.jgit.transport.resolver.ReceivePackFactory;
import org.openrewrite.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.openrewrite.jgit.transport.resolver.ServiceNotEnabledException;

class InternalPushConnection<C>
extends BasePackPushConnection {
    private Thread worker;

    public InternalPushConnection(PackTransport transport, final ReceivePackFactory<C> receivePackFactory, final C req, final Repository remote) throws TransportException {
        super(transport);
        PipedOutputStream out_w;
        PipedInputStream out_r;
        PipedOutputStream in_w;
        PipedInputStream in_r;
        try {
            in_r = new PipedInputStream();
            in_w = new PipedOutputStream(in_r);
            out_r = new PipedInputStream();
            out_w = new PipedOutputStream(out_r);
        }
        catch (IOException err) {
            remote.close();
            throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
        }
        this.worker = new Thread("JGit-Receive-Pack"){

            @Override
            public void run() {
                try {
                    ReceivePack rp = receivePackFactory.create(req, remote);
                    rp.receive(out_r, in_w, System.err);
                }
                catch (ServiceNotAuthorizedException | ServiceNotEnabledException rp) {
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    try {
                        out_r.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        in_w.close();
                    }
                    catch (IOException iOException) {}
                    remote.close();
                }
            }
        };
        this.worker.start();
        this.init(in_r, out_w);
        this.readAdvertisedRefs();
    }

    @Override
    public void close() {
        super.close();
        if (this.worker != null) {
            try {
                this.worker.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.worker = null;
            }
        }
    }
}

