/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.transport;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Objects;
import org.openrewrite.jgit.annotations.Nullable;
import org.openrewrite.jgit.errors.PackProtocolException;
import org.openrewrite.jgit.internal.JGitText;

public final class FilterSpec {
    private final ObjectTypes types;
    private final long blobLimit;
    private final long treeDepthLimit;
    public static final FilterSpec NO_FILTER = new FilterSpec(ObjectTypes.ALL, -1L, -1L);

    private FilterSpec(ObjectTypes types, long blobLimit, long treeDepthLimit) {
        this.types = Objects.requireNonNull(types);
        this.blobLimit = blobLimit;
        this.treeDepthLimit = treeDepthLimit;
    }

    public static FilterSpec fromFilterLine(String filterLine) throws PackProtocolException {
        if (filterLine.equals("blob:none")) {
            return FilterSpec.withObjectTypes(ObjectTypes.allow(2, 1, 4));
        }
        if (filterLine.startsWith("blob:limit=")) {
            long blobLimit = -1L;
            try {
                blobLimit = Long.parseLong(filterLine.substring("blob:limit=".length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (blobLimit >= 0L) {
                return FilterSpec.withBlobLimit(blobLimit);
            }
        } else if (filterLine.startsWith("tree:")) {
            long treeDepthLimit = -1L;
            try {
                treeDepthLimit = Long.parseLong(filterLine.substring("tree:".length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (treeDepthLimit >= 0L) {
                return FilterSpec.withTreeDepthLimit(treeDepthLimit);
            }
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidFilter, filterLine));
    }

    static FilterSpec withObjectTypes(ObjectTypes types) {
        return new FilterSpec(types, -1L, -1L);
    }

    static FilterSpec withBlobLimit(long blobLimit) {
        if (blobLimit < 0L) {
            throw new IllegalArgumentException("blobLimit cannot be negative: " + blobLimit);
        }
        return new FilterSpec(ObjectTypes.ALL, blobLimit, -1L);
    }

    static FilterSpec withTreeDepthLimit(long treeDepthLimit) {
        if (treeDepthLimit < 0L) {
            throw new IllegalArgumentException("treeDepthLimit cannot be negative: " + treeDepthLimit);
        }
        return new FilterSpec(ObjectTypes.ALL, -1L, treeDepthLimit);
    }

    public boolean allowsType(int type) {
        return this.types.contains(type);
    }

    public long getBlobLimit() {
        return this.blobLimit;
    }

    public long getTreeDepthLimit() {
        return this.treeDepthLimit;
    }

    public boolean isNoOp() {
        return this.types.equals(ObjectTypes.ALL) && this.blobLimit == -1L && this.treeDepthLimit == -1L;
    }

    @Nullable
    public String filterLine() {
        if (this.isNoOp()) {
            return null;
        }
        if (this.types.equals(ObjectTypes.allow(2, 1, 4)) && this.blobLimit == -1L && this.treeDepthLimit == -1L) {
            return "filter blob:none";
        }
        if (this.types.equals(ObjectTypes.ALL) && this.blobLimit >= 0L && this.treeDepthLimit == -1L) {
            return "filter blob:limit=" + this.blobLimit;
        }
        if (this.types.equals(ObjectTypes.ALL) && this.blobLimit == -1L && this.treeDepthLimit >= 0L) {
            return "filter tree:" + this.treeDepthLimit;
        }
        throw new IllegalStateException();
    }

    static class ObjectTypes {
        static ObjectTypes ALL = ObjectTypes.allow(3, 2, 1, 4);
        private final BigInteger val;

        private ObjectTypes(BigInteger val) {
            this.val = Objects.requireNonNull(val);
        }

        static ObjectTypes allow(int ... types) {
            BigInteger bits = BigInteger.ZERO;
            for (int type : types) {
                bits = bits.setBit(type);
            }
            return new ObjectTypes(bits);
        }

        boolean contains(int type) {
            return this.val.testBit(type);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectTypes)) {
                return false;
            }
            ObjectTypes other = (ObjectTypes)obj;
            return other.val.equals(this.val);
        }

        public int hashCode() {
            return this.val.hashCode();
        }
    }
}

