/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openrewrite.jgit.annotations.NonNull;
import org.openrewrite.jgit.annotations.Nullable;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.util.IO;

public class ObjectIdSerializer {
    private static final byte NULL_MARKER = 0;
    private static final byte NON_NULL_MARKER = 1;

    public static void write(OutputStream out, @Nullable AnyObjectId id) throws IOException {
        if (id != null) {
            out.write(1);
            ObjectIdSerializer.writeWithoutMarker(out, id);
        } else {
            out.write(0);
        }
    }

    public static void writeWithoutMarker(OutputStream out, @NonNull AnyObjectId id) throws IOException {
        id.copyRawTo(out);
    }

    @Nullable
    public static ObjectId read(InputStream in) throws IOException {
        byte marker = (byte)in.read();
        switch (marker) {
            case 0: {
                return null;
            }
            case 1: {
                return ObjectIdSerializer.readWithoutMarker(in);
            }
        }
        throw new IOException("Invalid flag before ObjectId: " + marker);
    }

    @NonNull
    public static ObjectId readWithoutMarker(InputStream in) throws IOException {
        byte[] b = new byte[20];
        IO.readFully(in, b, 0, 20);
        return ObjectId.fromRaw(b);
    }

    private ObjectIdSerializer() {
    }
}

