/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.net.URISyntaxException;
import java.util.List;
import org.openrewrite.jgit.api.GitCommand;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.transport.RemoteConfig;

public class RemoteListCommand
extends GitCommand<List<RemoteConfig>> {
    protected RemoteListCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<RemoteConfig> call() throws GitAPIException {
        this.checkCallable();
        try {
            return RemoteConfig.getAllRemoteConfigs(this.repo.getConfig());
        }
        catch (URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

