/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.jgit.api.GitCommand;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.lib.Ref;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.revwalk.RevWalk;

public class ListTagCommand
extends GitCommand<List<Ref>> {
    protected ListTagCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Ref> call() throws GitAPIException {
        this.checkCallable();
        ArrayList<Ref> tags = new ArrayList<Ref>();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            List<Ref> refList = this.repo.getRefDatabase().getRefsByPrefix("refs/tags/");
            for (Ref ref : refList) {
                tags.add(ref);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        Collections.sort(tags, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.setCallable(false);
        return tags;
    }
}

