/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.format;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.format.LineBreaks;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.tree.Json;
import org.openrewrite.style.GeneralFormatStyle;

public class NormalizeLineBreaksVisitor<P>
extends JsonIsoVisitor<P> {
    private final GeneralFormatStyle generalFormatStyle;
    private final @Nullable Tree stopAfter;

    public NormalizeLineBreaksVisitor(GeneralFormatStyle generalFormatStyle, @Nullable Tree stopAfter) {
        this.generalFormatStyle = generalFormatStyle;
        this.stopAfter = stopAfter;
    }

    public @Nullable Json postVisit(Json tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Json.Document.class, "stop", (Object)true);
        }
        return (Json)super.postVisit((Tree)tree, p);
    }

    public @Nullable Json visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Json)tree;
        }
        Json y = (Json)super.visit(tree, p);
        if (y != null) {
            String modifiedWs = LineBreaks.normalizeNewLines((String)y.getPrefix().getWhitespace(), (boolean)this.generalFormatStyle.isUseCRLFNewLines());
            if (!y.getPrefix().getWhitespace().equals(modifiedWs)) {
                y = y.withPrefix(y.getPrefix().withWhitespace(modifiedWs));
            }
        }
        return y;
    }
}

