/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.FullyQualifyMemberReference;
import org.openrewrite.java.FullyQualifyTypeReference;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.format.AutodetectGeneralFormatStyle;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.Style;

public class AddImport<P>
extends JavaIsoVisitor<P> {
    private final @Nullable String packageName;
    private final String typeName;
    private final String fullyQualifiedName;
    private final @Nullable String member;
    private final boolean onlyIfReferenced;
    private final @Nullable String alias;

    public AddImport(String type, @Nullable String member, boolean onlyIfReferenced) {
        int lastDotIdx = type.lastIndexOf(46);
        this.packageName = lastDotIdx != -1 ? type.substring(0, lastDotIdx) : null;
        this.typeName = lastDotIdx != -1 ? type.substring(lastDotIdx + 1) : type;
        this.fullyQualifiedName = type;
        this.member = member;
        this.onlyIfReferenced = onlyIfReferenced;
        this.alias = null;
    }

    public AddImport(@Nullable String packageName, String typeName, @Nullable String member, @Nullable String alias, boolean onlyIfReferenced) {
        this.packageName = packageName;
        this.typeName = typeName.replace('.', '$');
        this.fullyQualifiedName = packageName == null ? typeName : packageName + "." + typeName;
        this.member = member;
        this.onlyIfReferenced = onlyIfReferenced;
        this.alias = alias;
    }

    public @Nullable J preVisit(J tree, P p) {
        this.stopAfterPreVisit();
        J j = tree;
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)tree;
            if (this.packageName == null || JavaType.Primitive.fromKeyword(this.fullyQualifiedName) != null) {
                return cu;
            }
            if ("java.lang".equals(this.packageName) && StringUtils.isBlank((String)this.member)) {
                return cu;
            }
            if (!"Record".equals(this.typeName) && cu.getPackageDeclaration() != null && this.packageName.equals(cu.getPackageDeclaration().getExpression().printTrimmed(this.getCursor()))) {
                if (this.member == null) {
                    return cu;
                }
                for (J.ClassDeclaration clazz2 : cu.getClasses()) {
                    if (!TypeUtils.isOfClassType(clazz2.getType(), this.fullyQualifiedName)) continue;
                    return cu;
                }
            }
            Optional<JavaType> typeReference = this.findTypeReference(cu);
            if (this.onlyIfReferenced && !typeReference.isPresent()) {
                return cu;
            }
            ImportStatus importStatus = this.checkImportsForType(cu.getImports());
            if (importStatus == ImportStatus.EXPLICITLY_IMPORTED) {
                return cu;
            }
            if (!"Record".equals(this.typeName) && importStatus == ImportStatus.IMPLICITLY_IMPORTED) {
                return cu;
            }
            if (importStatus == ImportStatus.IMPORT_AMBIGUITY && typeReference.isPresent()) {
                if (typeReference.get() instanceof JavaType.FullyQualified) {
                    return (J)new FullyQualifyTypeReference((JavaType.FullyQualified)typeReference.get()).visit(cu, p);
                }
                if (typeReference.get() instanceof JavaType.Method || typeReference.get() instanceof JavaType.Variable) {
                    return (J)new FullyQualifyMemberReference(typeReference.get()).visit(cu, p);
                }
            }
            J.Import importToAdd = new J.Import(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JLeftPadded<Boolean>(this.member == null ? Space.EMPTY : Space.SINGLE_SPACE, this.member != null, Markers.EMPTY), (J.FieldAccess)TypeTree.build(this.fullyQualifiedName + (this.member == null ? "" : "." + this.member)).withPrefix(Space.SINGLE_SPACE), null);
            ArrayList<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>(cu.getPadding().getImports());
            if (imports.isEmpty() && !cu.getClasses().isEmpty() && cu.getPackageDeclaration() == null) {
                Space firstClassPrefix = cu.getClasses().get(0).getPrefix();
                importToAdd = importToAdd.withPrefix(firstClassPrefix.withComments(ListUtils.map(firstClassPrefix.getComments(), comment -> comment instanceof Javadoc ? null : comment)).withWhitespace(""));
                cu = cu.withClasses(ListUtils.mapFirst(cu.getClasses(), clazz -> (J.ClassDeclaration)clazz.withComments(ListUtils.map(clazz.getComments(), comment -> comment instanceof Javadoc ? comment : null))));
            }
            ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)Style.from(ImportLayoutStyle.class, (SourceFile)cu)).orElse(IntelliJ.importLayout());
            List<JavaType.FullyQualified> classpath = cu.getMarkers().findFirst(JavaSourceSet.class).map(JavaSourceSet::getClasspath).orElse(Collections.emptyList());
            List<JRightPadded<J.Import>> newImports = layoutStyle.addImport(cu.getPadding().getImports(), importToAdd, cu.getPackageDeclaration(), classpath);
            if (this.member != null && typeReference.isPresent()) {
                cu = (JavaSourceFile)new ShortenFullyQualifiedMemberReferences(typeReference.get()).visit(cu, p);
            } else if (this.member == null && typeReference.isPresent()) {
                cu = (JavaSourceFile)new ShortenFullyQualifiedTypeReferences((JavaType.FullyQualified)typeReference.get()).visit(cu, p);
            }
            newImports = this.checkCRLF(cu, newImports);
            JavaSourceFile c = cu = cu.getPadding().withImports(newImports);
            cu = cu.withClasses(ListUtils.mapFirst(cu.getClasses(), clazz -> {
                J.ClassDeclaration cl = this.autoFormat(clazz, clazz.getName(), p, new Cursor(null, (Object)c));
                return clazz.withPrefix(clazz.getPrefix().withWhitespace(cl.getPrefix().getWhitespace()));
            }));
            j = cu;
        }
        return j;
    }

    private ImportStatus checkImportsForType(List<J.Import> imports) {
        for (J.Import imp : imports) {
            String prefix;
            String ending = imp.getQualid().getSimpleName();
            if (imp.isStatic() ^ this.member != null) continue;
            if (imp.isStatic()) {
                if (imp.getTypeName().equals(this.fullyQualifiedName)) {
                    if (ending.equals(this.member)) {
                        return ImportStatus.EXPLICITLY_IMPORTED;
                    }
                    if ("*".equals(ending)) {
                        return ImportStatus.IMPLICITLY_IMPORTED;
                    }
                }
                if ("*".equals(ending) || !ending.equals(this.member)) continue;
                return ImportStatus.IMPORT_AMBIGUITY;
            }
            String impTypeName = imp.getTypeName().replace('$', '.');
            if (this.fullyQualifiedName.equals(impTypeName)) {
                return ImportStatus.EXPLICITLY_IMPORTED;
            }
            if ("*".equals(ending) && this.fullyQualifiedName.startsWith(prefix = impTypeName.substring(0, impTypeName.length() - 1)) && !this.fullyQualifiedName.substring(prefix.length()).contains(".")) {
                return ImportStatus.IMPLICITLY_IMPORTED;
            }
            if ("*".equals(ending) || !ending.equals(this.typeName)) continue;
            return ImportStatus.IMPORT_AMBIGUITY;
        }
        return ImportStatus.NOT_IMPORTED;
    }

    private List<JRightPadded<J.Import>> checkCRLF(JavaSourceFile cu, List<JRightPadded<J.Import>> newImports) {
        GeneralFormatStyle generalFormatStyle = Optional.ofNullable((GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)cu)).orElse(AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(cu));
        if (generalFormatStyle.isUseCRLFNewLines()) {
            return ListUtils.map(newImports, rp -> rp.map(i -> i.withPrefix(i.getPrefix().withWhitespace(i.getPrefix().getWhitespace().replaceAll("(?<!\r)\n", "\r\n")))));
        }
        return newImports;
    }

    private Optional<JavaType> getTypeReference(NameTree t) {
        if (!(t instanceof J.FieldAccess)) {
            return Optional.ofNullable(t.getType());
        }
        if (TypeUtils.isOfClassType(((J.FieldAccess)t).getTarget().getType(), this.fullyQualifiedName)) {
            return Optional.ofNullable(((J.FieldAccess)t).getTarget().getType());
        }
        return Optional.empty();
    }

    private Optional<JavaType> findTypeReference(JavaSourceFile compilationUnit) {
        if (this.member == null) {
            for (NameTree t : FindTypes.find(compilationUnit, this.fullyQualifiedName)) {
                Optional<JavaType> mayBeTypeReference;
                if (t instanceof J.FieldAccess && ((J.FieldAccess)t).isFullyQualifiedClassReference(this.fullyQualifiedName) || !(mayBeTypeReference = this.getTypeReference(t)).isPresent()) continue;
                return mayBeTypeReference;
            }
            return Optional.empty();
        }
        for (J invocation : FindMethods.find(compilationUnit, this.fullyQualifiedName + " *(..)")) {
            J.MethodInvocation mi;
            if (!(invocation instanceof J.MethodInvocation) || (mi = (J.MethodInvocation)invocation).getSelect() != null || !"*".equals(this.member) && !mi.getName().getSimpleName().equals(this.member)) continue;
            return Optional.ofNullable(mi.getMethodType());
        }
        return Optional.ofNullable((JavaType)((AtomicReference)new FindStaticFieldAccess().reduce(compilationUnit, new AtomicReference())).get());
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddImport)) {
            return false;
        }
        AddImport other = (AddImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.onlyIfReferenced != other.onlyIfReferenced) {
            return false;
        }
        String this$fullyQualifiedName = this.fullyQualifiedName;
        String other$fullyQualifiedName = other.fullyQualifiedName;
        if (this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName)) {
            return false;
        }
        String this$member = this.member;
        String other$member = other.member;
        if (this$member == null ? other$member != null : !this$member.equals(other$member)) {
            return false;
        }
        String this$alias = this.alias;
        String other$alias = other.alias;
        return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddImport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.onlyIfReferenced ? 79 : 97);
        String $fullyQualifiedName = this.fullyQualifiedName;
        result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
        String $member = this.member;
        result = result * 59 + ($member == null ? 43 : $member.hashCode());
        String $alias = this.alias;
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        return result;
    }

    private static enum ImportStatus {
        NOT_IMPORTED,
        IMPLICITLY_IMPORTED,
        EXPLICITLY_IMPORTED,
        IMPORT_AMBIGUITY;

    }

    private class ShortenFullyQualifiedMemberReferences
    extends ShortenFullyQualifiedReference {
        private final JavaType memberToShorten;

        @Override
        public J visitMethodInvocation(J.MethodInvocation methodInvocation, P p) {
            J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(methodInvocation, p);
            if (!(this.memberToShorten instanceof JavaType.Method)) {
                return mi;
            }
            JavaType.Method m = (JavaType.Method)this.memberToShorten;
            JavaType.FullyQualified targetType = m.getDeclaringType();
            if (this.isFullyQualifiedClassReference(mi.getSelect(), targetType.getFullyQualifiedName()) && mi.getSimpleName().equals(m.getName())) {
                return methodInvocation.withSelect(null);
            }
            return mi;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, P p) {
            J.FieldAccess target;
            if (!(this.memberToShorten instanceof JavaType.Variable)) {
                return super.visitFieldAccess(fieldAccess, p);
            }
            JavaType.Variable var = (JavaType.Variable)this.memberToShorten;
            JavaType.FullyQualified targetType = (JavaType.FullyQualified)var.getOwner();
            if (targetType != null && fieldAccess.getTarget() instanceof J.FieldAccess && (target = (J.FieldAccess)fieldAccess.getTarget()).isFullyQualifiedClassReference(targetType.getFullyQualifiedName())) {
                return fieldAccess.getName().withPrefix(fieldAccess.getPrefix());
            }
            return super.visitFieldAccess(fieldAccess, p);
        }

        @Generated
        public ShortenFullyQualifiedMemberReferences(JavaType memberToShorten) {
            this.memberToShorten = memberToShorten;
        }
    }

    private class ShortenFullyQualifiedTypeReferences
    extends ShortenFullyQualifiedReference {
        private final JavaType.FullyQualified typeToShorten;

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, P p) {
            if (fieldAccess.isFullyQualifiedClassReference(this.typeToShorten.getFullyQualifiedName())) {
                return fieldAccess.getName().withPrefix(fieldAccess.getPrefix());
            }
            return super.visitFieldAccess(fieldAccess, p);
        }

        @Override
        public J visitIdentifier(J.Identifier identifier, P p) {
            if (this.isFullyQualifiedClassReference(identifier, this.typeToShorten.getFullyQualifiedName())) {
                return identifier.withSimpleName(this.typeToShorten.getClassName());
            }
            return super.visitIdentifier(identifier, p);
        }

        @Generated
        public ShortenFullyQualifiedTypeReferences(JavaType.FullyQualified typeToShorten) {
            this.typeToShorten = typeToShorten;
        }
    }

    private class FindStaticFieldAccess
    extends JavaIsoVisitor<AtomicReference<JavaType>> {
        private FindStaticFieldAccess() {
        }

        private boolean checkIsOfClassType(@Nullable JavaType type, String fullyQualifiedName) {
            if (TypeUtils.isOfClassType(type, fullyQualifiedName)) {
                return true;
            }
            return type instanceof JavaType.Class && TypeUtils.isOfClassType(((JavaType.Class)type).getOwningClass(), fullyQualifiedName);
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, AtomicReference<JavaType> fieldAccess) {
            for (JavaType.Variable varType : cu.getTypesInUse().getVariables()) {
                if (!this.checkIsOfClassType(varType.getOwner(), AddImport.this.fullyQualifiedName)) continue;
                return super.visitCompilationUnit(cu, fieldAccess);
            }
            return cu;
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, AtomicReference<JavaType> fieldAccess) {
            assert (this.getCursor().getParent() != null);
            if (identifier.getSimpleName().equals(AddImport.this.member) && identifier.getFieldType() != null && this.checkIsOfClassType(identifier.getFieldType().getOwner(), AddImport.this.fullyQualifiedName) && !(this.getCursor().getParent().firstEnclosingOrThrow(J.class) instanceof J.FieldAccess)) {
                assert (identifier.getType() != null);
                fieldAccess.set(identifier.getFieldType());
            }
            return identifier;
        }
    }

    private abstract class ShortenFullyQualifiedReference
    extends JavaVisitor<P> {
        private ShortenFullyQualifiedReference() {
        }

        @Override
        public J visitImport(J.Import _import, P p) {
            return _import;
        }

        @Override
        protected JavadocVisitor<P> getJavadocVisitor() {
            return new JavadocVisitor<P>(new JavaVisitor()){

                @Override
                public Javadoc visitReference(Javadoc.Reference reference, P p) {
                    return reference;
                }
            };
        }

        protected boolean isFullyQualifiedClassReference(@Nullable Expression expr, String className) {
            if (expr instanceof J.FieldAccess) {
                return ((J.FieldAccess)expr).isFullyQualifiedClassReference(className);
            }
            if (expr instanceof J.Identifier) {
                J.Identifier id = (J.Identifier)expr;
                return id.getFieldType() == null && id.getSimpleName().equals(className);
            }
            return false;
        }
    }
}

