/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class MigrateAuthScope
extends Recipe {
    public String getDisplayName() {
        return "Replaces `AuthScope.ANY`";
    }

    public String getDescription() {
        return "Replace removed constant `org.apache.http.auth.AuthScope.AuthScope.ANY` with `new org.apache.hc.client5.http.auth.AuthScope(null, -1)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.apache.hc.client5.http.auth.AuthScope", Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                J.FieldAccess f = (J.FieldAccess)super.visitFieldAccess(fieldAccess, (Object)ctx);
                if ("ANY".equals(f.getSimpleName()) && TypeUtils.isOfClassType((JavaType)f.getTarget().getType(), (String)"org.apache.hc.client5.http.auth.AuthScope")) {
                    this.maybeAddImport("org.apache.hc.client5.http.auth.AuthScope");
                    return JavaTemplate.builder((String)"new AuthScope(null, -1)").imports(new String[]{"org.apache.hc.client5.http.auth.AuthScope"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpcore5"})).build().apply(this.updateCursor((Tree)f), f.getCoordinates().replace(), new Object[0]);
                }
                return f;
            }
        });
    }

    @Generated
    public MigrateAuthScope() {
    }

    @Generated
    public String toString() {
        return "MigrateAuthScope()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateAuthScope)) {
            return false;
        }
        MigrateAuthScope other = (MigrateAuthScope)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MigrateAuthScope;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

