/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.ExpressionHelperBase;
import java.util.Arrays;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableSetValue;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;

public abstract class SetExpressionHelper<E>
extends ExpressionHelperBase {
    protected final ObservableSetValue<E> observable;

    public static <E> SetExpressionHelper<E> addListener(SetExpressionHelper<E> helper, ObservableSetValue<E> observable, InvalidationListener listener) {
        if (observable == null || listener == null) {
            throw new NullPointerException();
        }
        observable.getValue();
        return helper == null ? new SingleInvalidation(observable, listener) : helper.addListener(listener);
    }

    public static <E> SetExpressionHelper<E> removeListener(SetExpressionHelper<E> helper, InvalidationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? null : helper.removeListener(listener);
    }

    public static <E> SetExpressionHelper<E> addListener(SetExpressionHelper<E> helper, ObservableSetValue<E> observable, ChangeListener<? super ObservableSet<E>> listener) {
        if (observable == null || listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? new SingleChange(observable, listener) : helper.addListener(listener);
    }

    public static <E> SetExpressionHelper<E> removeListener(SetExpressionHelper<E> helper, ChangeListener<? super ObservableSet<E>> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? null : helper.removeListener(listener);
    }

    public static <E> SetExpressionHelper<E> addListener(SetExpressionHelper<E> helper, ObservableSetValue<E> observable, SetChangeListener<? super E> listener) {
        if (observable == null || listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? new SingleSetChange(observable, listener) : helper.addListener(listener);
    }

    public static <E> SetExpressionHelper<E> removeListener(SetExpressionHelper<E> helper, SetChangeListener<? super E> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? null : helper.removeListener(listener);
    }

    public static <E> void fireValueChangedEvent(SetExpressionHelper<E> helper) {
        if (helper != null) {
            helper.fireValueChangedEvent();
        }
    }

    public static <E> void fireValueChangedEvent(SetExpressionHelper<E> helper, SetChangeListener.Change<? extends E> change) {
        if (helper != null) {
            helper.fireValueChangedEvent(change);
        }
    }

    protected SetExpressionHelper(ObservableSetValue<E> observable) {
        this.observable = observable;
    }

    protected abstract SetExpressionHelper<E> addListener(InvalidationListener var1);

    protected abstract SetExpressionHelper<E> removeListener(InvalidationListener var1);

    protected abstract SetExpressionHelper<E> addListener(ChangeListener<? super ObservableSet<E>> var1);

    protected abstract SetExpressionHelper<E> removeListener(ChangeListener<? super ObservableSet<E>> var1);

    protected abstract SetExpressionHelper<E> addListener(SetChangeListener<? super E> var1);

    protected abstract SetExpressionHelper<E> removeListener(SetChangeListener<? super E> var1);

    protected abstract void fireValueChangedEvent();

    protected abstract void fireValueChangedEvent(SetChangeListener.Change<? extends E> var1);

    public static class SimpleChange<E>
    extends SetChangeListener.Change<E> {
        private E old;
        private E added;
        private boolean addOp;

        public SimpleChange(ObservableSet<E> set) {
            super(set);
        }

        public SimpleChange(ObservableSet<E> set, SetChangeListener.Change<? extends E> source) {
            super(set);
            this.old = source.getElementRemoved();
            this.added = source.getElementAdded();
            this.addOp = source.wasAdded();
        }

        public SimpleChange<E> setRemoved(E old) {
            this.old = old;
            this.added = null;
            this.addOp = false;
            return this;
        }

        public SimpleChange<E> setAdded(E added) {
            this.old = null;
            this.added = added;
            this.addOp = true;
            return this;
        }

        @Override
        public boolean wasAdded() {
            return this.addOp;
        }

        @Override
        public boolean wasRemoved() {
            return !this.addOp;
        }

        @Override
        public E getElementAdded() {
            return this.added;
        }

        @Override
        public E getElementRemoved() {
            return this.old;
        }

        public String toString() {
            return this.addOp ? "added " + this.added : "removed " + this.old;
        }
    }

    private static class Generic<E>
    extends SetExpressionHelper<E> {
        private InvalidationListener[] invalidationListeners;
        private ChangeListener<? super ObservableSet<E>>[] changeListeners;
        private SetChangeListener<? super E>[] setChangeListeners;
        private int invalidationSize;
        private int changeSize;
        private int setChangeSize;
        private boolean locked;
        private ObservableSet<E> currentValue;

        private Generic(ObservableSetValue<E> observable, InvalidationListener listener0, InvalidationListener listener1) {
            super(observable);
            this.invalidationListeners = new InvalidationListener[]{listener0, listener1};
            this.invalidationSize = 2;
        }

        private Generic(ObservableSetValue<E> observable, ChangeListener<? super ObservableSet<E>> listener0, ChangeListener<? super ObservableSet<E>> listener1) {
            super(observable);
            this.changeListeners = new ChangeListener[]{listener0, listener1};
            this.changeSize = 2;
            this.currentValue = (ObservableSet)observable.getValue();
        }

        private Generic(ObservableSetValue<E> observable, SetChangeListener<? super E> listener0, SetChangeListener<? super E> listener1) {
            super(observable);
            this.setChangeListeners = new SetChangeListener[]{listener0, listener1};
            this.setChangeSize = 2;
            this.currentValue = (ObservableSet)observable.getValue();
        }

        private Generic(ObservableSetValue<E> observable, InvalidationListener invalidationListener, ChangeListener<? super ObservableSet<E>> changeListener) {
            super(observable);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener};
            this.invalidationSize = 1;
            this.changeListeners = new ChangeListener[]{changeListener};
            this.changeSize = 1;
            this.currentValue = (ObservableSet)observable.getValue();
        }

        private Generic(ObservableSetValue<E> observable, InvalidationListener invalidationListener, SetChangeListener<? super E> listChangeListener) {
            super(observable);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener};
            this.invalidationSize = 1;
            this.setChangeListeners = new SetChangeListener[]{listChangeListener};
            this.setChangeSize = 1;
            this.currentValue = (ObservableSet)observable.getValue();
        }

        private Generic(ObservableSetValue<E> observable, ChangeListener<? super ObservableSet<E>> changeListener, SetChangeListener<? super E> listChangeListener) {
            super(observable);
            this.changeListeners = new ChangeListener[]{changeListener};
            this.changeSize = 1;
            this.setChangeListeners = new SetChangeListener[]{listChangeListener};
            this.setChangeSize = 1;
            this.currentValue = (ObservableSet)observable.getValue();
        }

        @Override
        protected SetExpressionHelper<E> addListener(InvalidationListener listener) {
            if (this.invalidationListeners == null) {
                this.invalidationListeners = new InvalidationListener[]{listener};
                this.invalidationSize = 1;
            } else {
                int oldCapacity = this.invalidationListeners.length;
                if (this.locked) {
                    int newCapacity = this.invalidationSize < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                    this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, newCapacity);
                } else if (this.invalidationSize == oldCapacity) {
                    this.invalidationSize = Generic.trim(this.invalidationSize, this.invalidationListeners);
                    if (this.invalidationSize == oldCapacity) {
                        int newCapacity = oldCapacity * 3 / 2 + 1;
                        this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, newCapacity);
                    }
                }
                this.invalidationListeners[this.invalidationSize++] = listener;
            }
            return this;
        }

        @Override
        protected SetExpressionHelper<E> removeListener(InvalidationListener listener) {
            if (this.invalidationListeners != null) {
                for (int index = 0; index < this.invalidationSize; ++index) {
                    if (!listener.equals(this.invalidationListeners[index])) continue;
                    if (this.invalidationSize == 1) {
                        if (this.changeSize == 1 && this.setChangeSize == 0) {
                            return new SingleChange(this.observable, this.changeListeners[0]);
                        }
                        if (this.changeSize == 0 && this.setChangeSize == 1) {
                            return new SingleSetChange(this.observable, this.setChangeListeners[0]);
                        }
                        this.invalidationListeners = null;
                        this.invalidationSize = 0;
                        break;
                    }
                    if (this.invalidationSize == 2 && this.changeSize == 0 && this.setChangeSize == 0) {
                        return new SingleInvalidation(this.observable, this.invalidationListeners[1 - index]);
                    }
                    int numMoved = this.invalidationSize - index - 1;
                    InvalidationListener[] oldListeners = this.invalidationListeners;
                    if (this.locked) {
                        this.invalidationListeners = new InvalidationListener[this.invalidationListeners.length];
                        System.arraycopy(oldListeners, 0, this.invalidationListeners, 0, index + 1);
                    }
                    if (numMoved > 0) {
                        System.arraycopy(oldListeners, index + 1, this.invalidationListeners, index, numMoved);
                    }
                    --this.invalidationSize;
                    if (this.locked) break;
                    this.invalidationListeners[this.invalidationSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected SetExpressionHelper<E> addListener(ChangeListener<? super ObservableSet<E>> listener) {
            if (this.changeListeners == null) {
                this.changeListeners = new ChangeListener[]{listener};
                this.changeSize = 1;
            } else {
                int oldCapacity = this.changeListeners.length;
                if (this.locked) {
                    int newCapacity = this.changeSize < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                    this.changeListeners = Arrays.copyOf(this.changeListeners, newCapacity);
                } else if (this.changeSize == oldCapacity) {
                    this.changeSize = Generic.trim(this.changeSize, this.changeListeners);
                    if (this.changeSize == oldCapacity) {
                        int newCapacity = oldCapacity * 3 / 2 + 1;
                        this.changeListeners = Arrays.copyOf(this.changeListeners, newCapacity);
                    }
                }
                this.changeListeners[this.changeSize++] = listener;
            }
            if (this.changeSize == 1) {
                this.currentValue = (ObservableSet)this.observable.getValue();
            }
            return this;
        }

        @Override
        protected SetExpressionHelper<E> removeListener(ChangeListener<? super ObservableSet<E>> listener) {
            if (this.changeListeners != null) {
                for (int index = 0; index < this.changeSize; ++index) {
                    if (!listener.equals(this.changeListeners[index])) continue;
                    if (this.changeSize == 1) {
                        if (this.invalidationSize == 1 && this.setChangeSize == 0) {
                            return new SingleInvalidation(this.observable, this.invalidationListeners[0]);
                        }
                        if (this.invalidationSize == 0 && this.setChangeSize == 1) {
                            return new SingleSetChange(this.observable, this.setChangeListeners[0]);
                        }
                        this.changeListeners = null;
                        this.changeSize = 0;
                        break;
                    }
                    if (this.changeSize == 2 && this.invalidationSize == 0 && this.setChangeSize == 0) {
                        return new SingleChange(this.observable, this.changeListeners[1 - index]);
                    }
                    int numMoved = this.changeSize - index - 1;
                    ChangeListener<? super ObservableSet<E>>[] oldListeners = this.changeListeners;
                    if (this.locked) {
                        this.changeListeners = new ChangeListener[this.changeListeners.length];
                        System.arraycopy(oldListeners, 0, this.changeListeners, 0, index + 1);
                    }
                    if (numMoved > 0) {
                        System.arraycopy(oldListeners, index + 1, this.changeListeners, index, numMoved);
                    }
                    --this.changeSize;
                    if (this.locked) break;
                    this.changeListeners[this.changeSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected SetExpressionHelper<E> addListener(SetChangeListener<? super E> listener) {
            if (this.setChangeListeners == null) {
                this.setChangeListeners = new SetChangeListener[]{listener};
                this.setChangeSize = 1;
            } else {
                int oldCapacity = this.setChangeListeners.length;
                if (this.locked) {
                    int newCapacity = this.setChangeSize < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                    this.setChangeListeners = Arrays.copyOf(this.setChangeListeners, newCapacity);
                } else if (this.setChangeSize == oldCapacity) {
                    this.setChangeSize = Generic.trim(this.setChangeSize, this.setChangeListeners);
                    if (this.setChangeSize == oldCapacity) {
                        int newCapacity = oldCapacity * 3 / 2 + 1;
                        this.setChangeListeners = Arrays.copyOf(this.setChangeListeners, newCapacity);
                    }
                }
                this.setChangeListeners[this.setChangeSize++] = listener;
            }
            if (this.setChangeSize == 1) {
                this.currentValue = (ObservableSet)this.observable.getValue();
            }
            return this;
        }

        @Override
        protected SetExpressionHelper<E> removeListener(SetChangeListener<? super E> listener) {
            if (this.setChangeListeners != null) {
                for (int index = 0; index < this.setChangeSize; ++index) {
                    if (!listener.equals(this.setChangeListeners[index])) continue;
                    if (this.setChangeSize == 1) {
                        if (this.invalidationSize == 1 && this.changeSize == 0) {
                            return new SingleInvalidation(this.observable, this.invalidationListeners[0]);
                        }
                        if (this.invalidationSize == 0 && this.changeSize == 1) {
                            return new SingleChange(this.observable, this.changeListeners[0]);
                        }
                        this.setChangeListeners = null;
                        this.setChangeSize = 0;
                        break;
                    }
                    if (this.setChangeSize == 2 && this.invalidationSize == 0 && this.changeSize == 0) {
                        return new SingleSetChange(this.observable, this.setChangeListeners[1 - index]);
                    }
                    int numMoved = this.setChangeSize - index - 1;
                    SetChangeListener<? super E>[] oldListeners = this.setChangeListeners;
                    if (this.locked) {
                        this.setChangeListeners = new SetChangeListener[this.setChangeListeners.length];
                        System.arraycopy(oldListeners, 0, this.setChangeListeners, 0, index + 1);
                    }
                    if (numMoved > 0) {
                        System.arraycopy(oldListeners, index + 1, this.setChangeListeners, index, numMoved);
                    }
                    --this.setChangeSize;
                    if (this.locked) break;
                    this.setChangeListeners[this.setChangeSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected void fireValueChangedEvent() {
            if (this.changeSize == 0 && this.setChangeSize == 0) {
                this.notifyListeners(this.currentValue, null);
            } else {
                ObservableSet<E> oldValue = this.currentValue;
                this.currentValue = (ObservableSet)this.observable.getValue();
                this.notifyListeners(oldValue, null);
            }
        }

        @Override
        protected void fireValueChangedEvent(SetChangeListener.Change<? extends E> change) {
            SimpleChange<? extends E> mappedChange = this.setChangeSize == 0 ? null : new SimpleChange<E>(this.observable, change);
            this.notifyListeners(this.currentValue, mappedChange);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyListeners(ObservableSet<E> oldValue, SimpleChange<E> change) {
            InvalidationListener[] curInvalidationList = this.invalidationListeners;
            int curInvalidationSize = this.invalidationSize;
            ChangeListener<? super ObservableSet<E>>[] curChangeList = this.changeListeners;
            int curChangeSize = this.changeSize;
            SetChangeListener<? super E>[] curListChangeList = this.setChangeListeners;
            int curListChangeSize = this.setChangeSize;
            try {
                int i;
                this.locked = true;
                for (i = 0; i < curInvalidationSize; ++i) {
                    curInvalidationList[i].invalidated(this.observable);
                }
                if (this.currentValue != oldValue || change != null) {
                    for (i = 0; i < curChangeSize; ++i) {
                        curChangeList[i].changed(this.observable, oldValue, this.currentValue);
                    }
                    if (curListChangeSize > 0) {
                        if (change != null) {
                            for (i = 0; i < curListChangeSize; ++i) {
                                curListChangeList[i].onChanged(change);
                            }
                        } else {
                            change = new SimpleChange(this.observable);
                            if (this.currentValue == null) {
                                for (Object element : oldValue) {
                                    change.setRemoved(element);
                                    for (int i2 = 0; i2 < curListChangeSize; ++i2) {
                                        curListChangeList[i2].onChanged(change);
                                    }
                                }
                            } else if (oldValue == null) {
                                for (Object element : this.currentValue) {
                                    change.setAdded(element);
                                    for (int i3 = 0; i3 < curListChangeSize; ++i3) {
                                        curListChangeList[i3].onChanged(change);
                                    }
                                }
                            } else {
                                int i4;
                                for (Object element : oldValue) {
                                    if (this.currentValue.contains(element)) continue;
                                    change.setRemoved(element);
                                    for (i4 = 0; i4 < curListChangeSize; ++i4) {
                                        curListChangeList[i4].onChanged(change);
                                    }
                                }
                                for (Object element : this.currentValue) {
                                    if (oldValue.contains(element)) continue;
                                    change.setAdded(element);
                                    for (i4 = 0; i4 < curListChangeSize; ++i4) {
                                        curListChangeList[i4].onChanged(change);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            finally {
                this.locked = false;
            }
        }
    }

    private static class SingleSetChange<E>
    extends SetExpressionHelper<E> {
        private final SetChangeListener<? super E> listener;
        private ObservableSet<E> currentValue;

        private SingleSetChange(ObservableSetValue<E> observable, SetChangeListener<? super E> listener) {
            super(observable);
            this.listener = listener;
            this.currentValue = (ObservableSet)observable.getValue();
        }

        @Override
        protected SetExpressionHelper<E> addListener(InvalidationListener listener) {
            return new Generic(this.observable, listener, this.listener);
        }

        @Override
        protected SetExpressionHelper<E> removeListener(InvalidationListener listener) {
            return this;
        }

        @Override
        protected SetExpressionHelper<E> addListener(ChangeListener<? super ObservableSet<E>> listener) {
            return new Generic(this.observable, listener, this.listener);
        }

        @Override
        protected SetExpressionHelper<E> removeListener(ChangeListener<? super ObservableSet<E>> listener) {
            return this;
        }

        @Override
        protected SetExpressionHelper<E> addListener(SetChangeListener<? super E> listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected SetExpressionHelper<E> removeListener(SetChangeListener<? super E> listener) {
            return listener.equals(this.listener) ? null : this;
        }

        @Override
        protected void fireValueChangedEvent() {
            block8: {
                ObservableSet<E> oldValue = this.currentValue;
                this.currentValue = (ObservableSet)this.observable.getValue();
                if (this.currentValue == oldValue) break block8;
                SimpleChange change = new SimpleChange(this.observable);
                if (this.currentValue == null) {
                    for (Object element : oldValue) {
                        this.listener.onChanged(change.setRemoved(element));
                    }
                } else if (oldValue == null) {
                    for (Object element : this.currentValue) {
                        this.listener.onChanged(change.setAdded(element));
                    }
                } else {
                    for (Object element : oldValue) {
                        if (this.currentValue.contains(element)) continue;
                        this.listener.onChanged(change.setRemoved(element));
                    }
                    for (Object element : this.currentValue) {
                        if (oldValue.contains(element)) continue;
                        this.listener.onChanged(change.setAdded(element));
                    }
                }
            }
        }

        @Override
        protected void fireValueChangedEvent(SetChangeListener.Change<? extends E> change) {
            this.listener.onChanged(new SimpleChange<E>(this.observable, change));
        }
    }

    private static class SingleChange<E>
    extends SetExpressionHelper<E> {
        private final ChangeListener<? super ObservableSet<E>> listener;
        private ObservableSet<E> currentValue;

        private SingleChange(ObservableSetValue<E> observable, ChangeListener<? super ObservableSet<E>> listener) {
            super(observable);
            this.listener = listener;
            this.currentValue = (ObservableSet)observable.getValue();
        }

        @Override
        protected SetExpressionHelper<E> addListener(InvalidationListener listener) {
            return new Generic(this.observable, listener, this.listener);
        }

        @Override
        protected SetExpressionHelper<E> removeListener(InvalidationListener listener) {
            return this;
        }

        @Override
        protected SetExpressionHelper<E> addListener(ChangeListener<? super ObservableSet<E>> listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected SetExpressionHelper<E> removeListener(ChangeListener<? super ObservableSet<E>> listener) {
            return listener.equals(this.listener) ? null : this;
        }

        @Override
        protected SetExpressionHelper<E> addListener(SetChangeListener<? super E> listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected SetExpressionHelper<E> removeListener(SetChangeListener<? super E> listener) {
            return this;
        }

        @Override
        protected void fireValueChangedEvent() {
            ObservableSet<E> oldValue = this.currentValue;
            this.currentValue = (ObservableSet)this.observable.getValue();
            if (this.currentValue != oldValue) {
                this.listener.changed(this.observable, oldValue, this.currentValue);
            }
        }

        @Override
        protected void fireValueChangedEvent(SetChangeListener.Change<? extends E> change) {
            this.listener.changed(this.observable, this.currentValue, this.currentValue);
        }
    }

    private static class SingleInvalidation<E>
    extends SetExpressionHelper<E> {
        private final InvalidationListener listener;

        private SingleInvalidation(ObservableSetValue<E> observable, InvalidationListener listener) {
            super(observable);
            this.listener = listener;
        }

        @Override
        protected SetExpressionHelper<E> addListener(InvalidationListener listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected SetExpressionHelper<E> removeListener(InvalidationListener listener) {
            return listener.equals(this.listener) ? null : this;
        }

        @Override
        protected SetExpressionHelper<E> addListener(ChangeListener<? super ObservableSet<E>> listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected SetExpressionHelper<E> removeListener(ChangeListener<? super ObservableSet<E>> listener) {
            return this;
        }

        @Override
        protected SetExpressionHelper<E> addListener(SetChangeListener<? super E> listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected SetExpressionHelper<E> removeListener(SetChangeListener<? super E> listener) {
            return this;
        }

        @Override
        protected void fireValueChangedEvent() {
            this.listener.invalidated(this.observable);
        }

        @Override
        protected void fireValueChangedEvent(SetChangeListener.Change<? extends E> change) {
            this.listener.invalidated(this.observable);
        }
    }
}

