/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.opencms.v8.list;

import com.alkacon.opencms.v8.list.CmsListContentMapping;
import com.alkacon.opencms.v8.list.CmsListEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsListConfiguration
extends CmsJspActionElement {
    public static final String MACRO_LINK_PREFIX = "link";
    public static final String NODE_LINKS = "Links";
    public static final String NODE_MAPPING = "Mapping";
    public static final String NODE_PARAMETER = "Parameter";
    public static final String PARAM_FILE = "file";
    private static final Log LOG = CmsLog.getLog(CmsListConfiguration.class);
    private CmsXmlContent m_content;
    private Map<Object, CmsListEntry> m_mappedEntries;
    private CmsListContentMapping m_mapping;

    public CmsListConfiguration() {
    }

    public CmsListConfiguration(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res, null);
    }

    public CmsListConfiguration(PageContext context, HttpServletRequest req, HttpServletResponse res, String configPath) {
        this.init(context, req, res, configPath);
    }

    public Map<Object, CmsListEntry> getMappedEntry() {
        if (this.m_mappedEntries == null) {
            this.m_mappedEntries = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    CmsListEntry entry = null;
                    try {
                        CmsXmlContent content;
                        if (input instanceof CmsXmlContent) {
                            content = (CmsXmlContent)input;
                        } else {
                            CmsResource resource = (CmsResource)input;
                            content = CmsXmlContentFactory.unmarshal((CmsObject)CmsListConfiguration.this.getCmsObject(), (CmsFile)CmsListConfiguration.this.getCmsObject().readFile(resource));
                        }
                        if (CmsListConfiguration.this.getMapping() != null) {
                            entry = CmsListConfiguration.this.getMapping().getEntryFromXmlContent(CmsListConfiguration.this.getCmsObject(), content, CmsListConfiguration.this.getRequestContext().getLocale());
                        }
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                    return entry;
                }
            });
        }
        return this.m_mappedEntries;
    }

    public String getParameter() {
        Locale locale = this.getRequestContext().getLocale();
        String params = this.m_content.getStringValue(this.getCmsObject(), NODE_PARAMETER, locale);
        List links = this.m_content.getValues(NODE_LINKS, locale);
        CmsMacroResolver macroResolver = CmsMacroResolver.newInstance().setCmsObject(this.getCmsObject());
        macroResolver.setKeepEmptyMacros(true);
        for (int i = 0; i < links.size(); ++i) {
            I_CmsXmlContentValue xmlValue = (I_CmsXmlContentValue)links.get(i);
            String value = xmlValue.getStringValue(this.getCmsObject());
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)value)) continue;
            StringBuffer macro = new StringBuffer(10);
            macro.append(MACRO_LINK_PREFIX).append(i + 1);
            macroResolver.addMacro(macro.toString(), this.getRequestContext().removeSiteRoot(value));
        }
        return macroResolver.resolveMacros(params);
    }

    public void init(PageContext context, HttpServletRequest req, HttpServletResponse res, String configPath) {
        block7: {
            super.init(context, req, res);
            try {
                CmsObject cms = this.getCmsObject();
                CmsFile file = null;
                if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)configPath)) {
                    CmsContainerElementBean element = OpenCms.getADEManager().getCurrentElement((ServletRequest)req);
                    file = cms.readFile(cms.readResource(element.getId()));
                } else {
                    file = cms.readFile(configPath);
                }
                this.m_content = CmsXmlContentFactory.unmarshal((CmsObject)cms, (CmsFile)file);
                this.m_mapping = null;
                int mapsize = this.m_content.getValues(NODE_MAPPING, this.getRequestContext().getLocale()).size();
                if (mapsize > 0) {
                    this.m_mapping = new CmsListContentMapping();
                    for (int i = 1; i <= mapsize; ++i) {
                        String basePath = CmsXmlUtils.createXpath((String)NODE_MAPPING, (int)i);
                        String field = this.m_content.getStringValue(cms, CmsXmlUtils.concatXpath((String)basePath, (String)"Field"), this.getRequestContext().getLocale());
                        String defaultValue = this.m_content.getStringValue(cms, CmsXmlUtils.concatXpath((String)basePath, (String)"Default"), this.getRequestContext().getLocale());
                        String maxLenghtStr = this.m_content.getStringValue(cms, CmsXmlUtils.concatXpath((String)basePath, (String)"MaxLength"), this.getRequestContext().getLocale());
                        List xmlNodes = this.m_content.getValues(CmsXmlUtils.concatXpath((String)basePath, (String)"XmlNode"), this.getRequestContext().getLocale());
                        ArrayList<String> nodes = new ArrayList<String>(xmlNodes.size());
                        for (int j = 0; j < xmlNodes.size(); ++j) {
                            nodes.add(((I_CmsXmlContentValue)xmlNodes.get(j)).getStringValue(cms));
                        }
                        this.m_mapping.addListFieldMapping(nodes, field, maxLenghtStr, defaultValue);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected CmsListContentMapping getMapping() {
        return this.m_mapping;
    }
}

