/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextNoteClassAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextRefNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextReferenceFormatAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextNoteRefElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "note-ref");

    public TextNoteRefElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getTextNoteClassAttribute() {
        TextNoteClassAttribute attr = (TextNoteClassAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "note-class");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextNoteClassAttribute(String textNoteClassValue) {
        TextNoteClassAttribute attr = new TextNoteClassAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textNoteClassValue);
    }

    public String getTextRefNameAttribute() {
        TextRefNameAttribute attr = (TextRefNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "ref-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextRefNameAttribute(String textRefNameValue) {
        TextRefNameAttribute attr = new TextRefNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textRefNameValue);
    }

    public String getTextReferenceFormatAttribute() {
        TextReferenceFormatAttribute attr = (TextReferenceFormatAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "reference-format");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextReferenceFormatAttribute(String textReferenceFormatValue) {
        TextReferenceFormatAttribute attr = new TextReferenceFormatAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textReferenceFormatValue);
    }

    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

