/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.doc.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.doc.style.OdfStyle;
import org.odftoolkit.odfdom.doc.text.OdfTextHeading;
import org.odftoolkit.odfdom.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.search.Navigation;
import org.odftoolkit.odfdom.incubator.search.Selection;
import org.odftoolkit.odfdom.incubator.search.TextSelection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextStyleNavigation
extends Navigation {
    private OdfTextDocument mTextDocument;
    private TextSelection mCurrentSelectedItem;
    private int mCurrentIndex;
    private Map<OdfStyleProperty, String> mProps;
    private String mText;
    private Node mPhNode;
    private int mIndex;
    private Node mNode;

    public TextStyleNavigation(Map<OdfStyleProperty, String> props, OdfTextDocument doc) {
        this.mTextDocument = doc;
        this.mCurrentSelectedItem = null;
        this.mProps = props;
    }

    private TextSelection findnext(TextSelection selected) {
        OdfElement element = null;
        if (selected == null) {
            try {
                this.mNode = this.getNextMatchElement((Node)((Object)this.mTextDocument.getContentRoot()));
            }
            catch (Exception ex) {
                Logger.getLogger(TextStyleNavigation.class.getName()).log(Level.SEVERE, null, ex);
                ex.printStackTrace();
            }
        } else {
            try {
                this.mNode = this.getNextMatchElement(this.mNode);
            }
            catch (Exception ex) {
                Logger.getLogger(TextStyleNavigation.class.getName()).log(Level.SEVERE, null, ex);
                ex.printStackTrace();
            }
        }
        if (this.mNode != null) {
            element = (OdfElement)((Object)this.getPHElement(this.mNode));
            TextSelection item = new TextSelection(this.mText, element, this.mCurrentIndex);
            return item;
        }
        return null;
    }

    private Node getPHElement(Node node) {
        if (node instanceof OdfTextParagraph) {
            this.mPhNode = node;
        } else if (node instanceof OdfTextHeading) {
            this.mPhNode = node;
        } else {
            this.getPHElement(node.getParentNode());
        }
        return this.mPhNode;
    }

    @Override
    public Selection getCurrentItem() {
        Selection.SelectionManager.registerItem(this.mCurrentSelectedItem);
        return this.mCurrentSelectedItem;
    }

    @Override
    public boolean hasNext() {
        this.mCurrentSelectedItem = this.findnext(this.mCurrentSelectedItem);
        return this.mCurrentSelectedItem != null;
    }

    @Override
    public boolean match(Node element) {
        boolean match = false;
        if (element.getNodeType() == 3 && !element.getNodeValue().trim().equals("") && element.getParentNode() instanceof OdfStylableElement) {
            OdfStylableElement parStyleElement = (OdfStylableElement)((Object)element.getParentNode());
            String parStyleName = this.getStyleName(parStyleElement);
            if (this.getMatchStyleNames().contains(parStyleName)) {
                match = true;
                this.mText = element.getNodeValue();
                NodeList nodes = this.getPHElement(element.getParentNode()).getChildNodes();
                this.mIndex = 0;
                this.getIndex(nodes, element);
            }
        }
        return match;
    }

    private void getIndex(NodeList nodes, Node element) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == element) {
                this.mCurrentIndex = this.mIndex;
                break;
            }
            if (node.getNodeType() == 3) {
                this.mIndex += node.getNodeValue().length();
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                try {
                    this.mIndex += Integer.parseInt(((Element)node).getAttributeNS(OdfNamespaceNames.TEXT.getUri(), "c"));
                }
                catch (Exception e) {
                    ++this.mIndex;
                }
                continue;
            }
            if (node.getLocalName().equals("line-break")) {
                ++this.mIndex;
                continue;
            }
            if (node.getLocalName().equals("tab")) {
                ++this.mIndex;
                continue;
            }
            this.getIndex(node.getChildNodes(), element);
        }
    }

    private String getStyleName(OdfStylableElement element) {
        String stylename = element.getStyleName();
        if (stylename == null) {
            if (element.getParentNode() instanceof OdfStylableElement) {
                this.getStyleName((OdfStylableElement)((Object)element.getParentNode()));
            } else {
                stylename = "defaultstyle";
            }
        }
        return stylename;
    }

    private Set<String> getMatchStyleNames() {
        XPath mInputXPath = XPathFactory.newInstance().newXPath();
        mInputXPath.setNamespaceContext(OdfNamespace.newNamespace(OdfNamespaceNames.OFFICE));
        HashSet<String> styleNames = new HashSet<String>();
        HashMap<String, OdfDefaultStyle> defaultStyles = new HashMap<String, OdfDefaultStyle>();
        try {
            OdfStyleProperty p;
            boolean isStyle;
            Iterator<OdfStyleProperty> pIter;
            Map<OdfStyleProperty, String> map;
            NodeList defStyleList = this.mTextDocument.getDocumentStyles().getElementsByTagName("style:default-style");
            for (int i = 0; i < defStyleList.getLength(); ++i) {
                OdfDefaultStyle defStyle = (OdfDefaultStyle)((Object)defStyleList.item(i));
                defaultStyles.put(defStyle.getFamilyName(), defStyle);
            }
            NodeList styleList = this.mTextDocument.getDocumentStyles().getElementsByTagName("style:style");
            for (int i = 0; i < styleList.getLength(); ++i) {
                OdfStyle sStyle = (OdfStyle)((Object)styleList.item(i));
                map = sStyle.getStylePropertiesDeep();
                pIter = this.mProps.keySet().iterator();
                isStyle = false;
                while (pIter.hasNext()) {
                    isStyle = false;
                    p = pIter.next();
                    if (!map.containsKey(p) || !map.get(p).equals(this.mProps.get(p))) break;
                    isStyle = true;
                }
                if (!isStyle) continue;
                String sname = sStyle.getStyleNameAttribute();
                styleNames.add(sname);
            }
            for (OdfStyle cStyle : this.mTextDocument.getContentDom().getAutomaticStyles().getAllStyles()) {
                map = cStyle.getStylePropertiesDeep();
                if (cStyle.getParentStyle() == null && cStyle.getFamilyName().equals("text")) {
                    if (defaultStyles.containsKey("text")) {
                        this.getTextDefaultProperties("text", defaultStyles, map);
                    } else {
                        this.getTextDefaultProperties("paragraph", defaultStyles, map);
                    }
                }
                pIter = this.mProps.keySet().iterator();
                isStyle = false;
                while (pIter.hasNext()) {
                    isStyle = false;
                    p = pIter.next();
                    if (!map.containsKey(p) || !map.get(p).equals(this.mProps.get(p))) break;
                    isStyle = true;
                }
                if (!isStyle) continue;
                styleNames.add(cStyle.getStyleNameAttribute());
            }
        }
        catch (Exception e1) {
            Logger.getLogger(TextStyleNavigation.class.getName()).log(Level.SEVERE, null, e1);
            e1.printStackTrace();
        }
        return styleNames;
    }

    private void getTextDefaultProperties(String familyName, HashMap<String, OdfDefaultStyle> defaultStyles, Map<OdfStyleProperty, String> map) {
        OdfStyleFamily family;
        OdfDefaultStyle defStyle = defaultStyles.get(familyName);
        if (defStyle != null && (family = defStyle.getFamily()) != null) {
            for (OdfStyleProperty property : family.getProperties()) {
                if (map.containsKey(property) || !defStyle.hasProperty(property)) continue;
                map.put(property, defStyle.getProperty(property));
            }
        }
    }
}

