/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.OdfAlienAttribute;
import org.odftoolkit.odfdom.OdfAlienElement;
import org.odftoolkit.odfdom.OdfAttribute;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.OdfName;
import org.w3c.dom.DOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfXMLFactory {
    private static Map<OdfName, Class> mElementTypes = new HashMap<OdfName, Class>();
    private static Map<OdfName, Class> mAttributeTypes = new HashMap<OdfName, Class>();
    private static Map<String, String> mElementRenames = new HashMap<String, String>();
    private static final String LOCAL_NAME_DELIMITER = "-";
    private static final String ELEMENT_PACKAGE_NAME = "element";
    private static final String ATTRIBUTE_PACKAGE_NAME = "attribute";

    public static void setOdfElementClass(OdfName odfName, Class className) {
        mElementTypes.put(odfName, className);
    }

    public static void setOdfAttributeClass(OdfName odfName, Class className) {
        mAttributeTypes.put(odfName, className);
    }

    public static Class getOdfAttributeClass(OdfName odfName) {
        return OdfXMLFactory.getOdfNodeClass(odfName, ATTRIBUTE_PACKAGE_NAME, mAttributeTypes);
    }

    public static Class getOdfElementClass(OdfName odfName) {
        return OdfXMLFactory.getOdfNodeClass(odfName, ELEMENT_PACKAGE_NAME, mElementTypes);
    }

    private static Class getOdfNodeClass(OdfName odfName, String nodeName, Map<OdfName, Class> classCache) {
        String prefix;
        Class<?> c = null;
        String className = "";
        c = classCache.get(odfName);
        if (!(c != null || (prefix = odfName.getPrefix()) == null || nodeName.equals(ATTRIBUTE_PACKAGE_NAME) && prefix.equals("xmlns"))) {
            String qName = odfName.getQName();
            String localName = odfName.getLocalName();
            if (nodeName == ATTRIBUTE_PACKAGE_NAME || prefix.equals("meta") || prefix.equals("table") || qName.equals("office:meta") || qName.equals("draw:page") || qName.equals("office:presentation") || qName.equals("presentation:notes")) {
                className = OdfXMLFactory.getOdfDOMNodeClassName(odfName.getPrefix(), odfName.getLocalName(), nodeName);
            } else if (mElementRenames.containsKey(qName)) {
                String renameName = mElementRenames.get(qName);
                StringTokenizer stok = new StringTokenizer(renameName, ":");
                className = OdfXMLFactory.getOdfDOCNodeClassName(stok.nextToken(), stok.nextToken());
            } else {
                className = OdfXMLFactory.getOdfDOCNodeClassName(prefix, localName);
            }
            try {
                c = Class.forName(className);
                classCache.put(odfName, c);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.INFO, "ClassNotFoundException - not a problem for none ODF 1.2 XML node: " + className, ex.getMessage());
            }
            catch (NoClassDefFoundError dex) {
                Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.INFO, "NoClassDefFoundError: " + className, dex.getMessage());
            }
        }
        return c;
    }

    private static String getOdfDOCNodeClassName(String prefix, String localName) {
        boolean contains = false;
        StringBuilder className = new StringBuilder();
        if (localName.indexOf(LOCAL_NAME_DELIMITER) != -1) {
            StringTokenizer stok = new StringTokenizer(localName, LOCAL_NAME_DELIMITER);
            while (stok.hasMoreElements()) {
                String substr = stok.nextToken();
                if (substr.equals(prefix)) {
                    contains = true;
                }
                className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(substr));
            }
        } else {
            className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(localName));
        }
        if (!(contains && !localName.endsWith("table") || localName.equals(prefix) || localName.startsWith(prefix) && prefix.equals("anim"))) {
            className = className.insert(0, OdfXMLFactory.toUpperCaseFirstCharacter(prefix));
        }
        className = className.insert(0, "org.odftoolkit.odfdom.doc." + prefix + "." + "Odf");
        return className.toString();
    }

    private static String getOdfDOMNodeClassName(String prefix, String localName, String nodeName) {
        StringBuilder className = new StringBuilder("org.odftoolkit.odfdom.dom." + nodeName + "." + prefix + ".");
        className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(prefix));
        if (localName.indexOf(LOCAL_NAME_DELIMITER) != -1) {
            StringTokenizer stok = new StringTokenizer(localName, LOCAL_NAME_DELIMITER);
            while (stok.hasMoreElements()) {
                className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(stok.nextToken()));
            }
        } else {
            className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(localName));
        }
        className.append(OdfXMLFactory.toUpperCaseFirstCharacter(nodeName));
        return className.toString();
    }

    private static String toUpperCaseFirstCharacter(String token) {
        return token.substring(0, 1).toUpperCase() + token.substring(1);
    }

    public static OdfElement newOdfElement(OdfFileDom ownerDocument, OdfName name) throws DOMException {
        OdfElement element = null;
        Class elementClass = OdfXMLFactory.getOdfElementClass(name);
        element = elementClass != null ? (OdfElement)((Object)OdfXMLFactory.getNodeFromClass(ownerDocument, elementClass)) : new OdfAlienElement(ownerDocument, name);
        return element;
    }

    public static OdfAttribute newOdfAttribute(OdfFileDom ownerDocument, OdfName name) throws DOMException {
        OdfAttribute attr = null;
        Class attributeClass = OdfXMLFactory.getOdfAttributeClass(name);
        attr = attributeClass != null ? (OdfAttribute)((Object)OdfXMLFactory.getNodeFromClass(ownerDocument, attributeClass)) : new OdfAlienAttribute(ownerDocument, name);
        return attr;
    }

    static Object getNodeFromClass(OdfFileDom ownerDocument, Class nodeClass) {
        Object o = null;
        try {
            Constructor ctor = nodeClass.getConstructor(OdfFileDom.class);
            o = ctor.newInstance(new Object[]{ownerDocument});
        }
        catch (Exception cause) {
            throw new Error("OdfDOM error in attribute factory", cause);
        }
        return o;
    }

    static {
        mElementRenames.put("draw:a", "draw:hyperlink");
        mElementRenames.put("draw:g", "draw:group");
        mElementRenames.put("text:h", "text:heading");
        mElementRenames.put("text:p", "text:paragraph");
        mElementRenames.put("text:s", "text:space");
        mElementRenames.put("text:a", "text:hyperlink");
    }
}

