/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfMetaDom;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentSettingsElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeSettingsElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OdfSettingsDom
extends OdfFileDom {
    private static final long serialVersionUID = 766167617530147885L;

    public OdfSettingsDom(OdfSchemaDocument odfDocument, String packagePath) {
        super(odfDocument, packagePath);
    }

    @Override
    protected void initialize() {
        this.setPrefixAndUri(OdfDocumentNamespace.CONFIG);
        this.setPrefixAndUri(OdfDocumentNamespace.OFFICE);
        this.setPrefixAndUri(OdfDocumentNamespace.OOO);
        this.setPrefixAndUri(OdfDocumentNamespace.XLINK);
        try {
            super.initialize();
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(OdfMetaDom.class.getName()).log(Level.SEVERE, null, ex);
        }
        OfficeDocumentSettingsElement rootElement = this.getRootElement();
        if (rootElement == null) {
            rootElement = new OfficeDocumentSettingsElement(this);
            this.appendChild((Node)((Object)rootElement));
            rootElement.appendChild((Node)((Object)new OfficeSettingsElement(this)));
        }
    }

    private void setPrefixAndUri(OdfDocumentNamespace name) {
        this.mUriByPrefix.put(name.getPrefix(), name.getUri());
        this.mPrefixByUri.put(name.getUri(), name.getPrefix());
    }

    @Override
    public OdfSchemaDocument getDocument() {
        return (OdfSchemaDocument)this.mPackageDocument;
    }

    @Override
    public OfficeDocumentSettingsElement getRootElement() {
        return (OfficeDocumentSettingsElement)((Object)this.getDocumentElement());
    }

    @Override
    public XPath getXPath() {
        if (this.mXPath == null) {
            this.mXPath = XPathFactory.newInstance().newXPath();
            this.mXPath.setNamespaceContext(this);
            for (OdfDocumentNamespace name : OdfDocumentNamespace.values()) {
                this.mUriByPrefix.put(name.getPrefix(), name.getUri());
                this.mPrefixByUri.put(name.getUri(), name.getPrefix());
            }
        }
        return this.mXPath;
    }
}

