/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.tapestry5.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.SortConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMappedGridDataSource<K, E>
implements GridDataSource {
    private Logger log = LoggerFactory.getLogger(AbstractMappedGridDataSource.class);
    private Map<K, E> mapResults;
    private List<E> listResults;
    private int nbRows = -1;
    private int nbRowsPerPage;
    private boolean prepared;

    public abstract Class<?> getRowType();

    protected abstract int count();

    protected abstract Map<K, E> execute(int var1, int var2, SortConstraint var3);

    public int getAvailableRows() {
        if (this.nbRows < 0) {
            this.nbRows = this.count();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Count : " + this.nbRows);
            }
        }
        return this.nbRows;
    }

    public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Prepare results : " + startIndex + ", " + endIndex);
        }
        this.nbRowsPerPage = endIndex - startIndex + 1;
        this.mapResults = this.execute(startIndex, endIndex, this.getSortConstraint(sortConstraints));
        this.listResults = new ArrayList<E>(this.mapResults.values());
        this.prepared = true;
    }

    public Object getRowValue(int index) {
        if ((index %= this.nbRowsPerPage) >= this.listResults.size()) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Size error : " + index + " / " + this.listResults.size());
            }
            return null;
        }
        return CollectionUtils.get(this.listResults, (int)index);
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public E get(K key) {
        if (this.mapResults == null) {
            return null;
        }
        return this.mapResults.get(key);
    }

    public List<E> values() {
        if (this.listResults == null) {
            this.listResults = new ArrayList();
        }
        return this.listResults;
    }

    public boolean contains(K key) {
        if (this.mapResults == null) {
            return false;
        }
        return this.mapResults.containsKey(key);
    }

    protected SortConstraint getSortConstraint(List<SortConstraint> sortConstraints) {
        for (SortConstraint constraint : sortConstraints) {
            ColumnSort sort = constraint.getColumnSort();
            if (sort == ColumnSort.UNSORTED) continue;
            return constraint;
        }
        return null;
    }

    protected String resolveOrderBy(SortConstraint orderBy) {
        String filterOrder = null;
        if (orderBy != null) {
            PropertyModel property = orderBy.getPropertyModel();
            filterOrder = property.getPropertyName();
            ColumnSort sort = orderBy.getColumnSort();
            if (sort.equals((Object)ColumnSort.DESCENDING)) {
                filterOrder = filterOrder + " desc";
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Order : " + filterOrder);
            }
        }
        return filterOrder;
    }
}

