/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.tapestry5.services;

import java.lang.annotation.Annotation;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.services.ApplicationStateManager;
import org.nuiton.web.tapestry5.services.ServiceAuthentication;

public class ServiceAuthenticationImpl<U, A extends Annotation>
implements ServiceAuthentication<U> {
    private final ApplicationStateManager stateManager;
    protected Class<U> userClass;
    protected Class<A> annotationClass;

    public ServiceAuthenticationImpl(ApplicationStateManager stateManager, Class<U> userClass, Class<A> annotationClass) {
        this.stateManager = stateManager;
        this.userClass = userClass;
        this.annotationClass = annotationClass;
    }

    @Override
    public boolean isUserConnected() {
        return this.stateManager.exists(this.userClass);
    }

    @Override
    public U getUserConnected() {
        return (U)this.stateManager.getIfExists(this.userClass);
    }

    @Override
    public void setUserConnected(U user) {
        this.stateManager.set(this.userClass, user);
    }

    @Override
    public boolean isAllowed(Class<?> page) {
        if (page.isAnnotationPresent(this.annotationClass) && this.isUserConnected()) {
            A check = page.getAnnotation(this.annotationClass);
            U user = this.getUserConnected();
            return this.checkAuthorizations(user, check);
        }
        return true;
    }

    protected boolean checkAuthorizations(U user, A annotation) {
        return true;
    }

    @Override
    public U getNewUserInstance() {
        try {
            return this.userClass.newInstance();
        }
        catch (Exception eee) {
            new TapestryException("Error on user instanciation " + this.userClass.getName(), (Throwable)eee);
            return null;
        }
    }
}

