/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.tapestry5.components;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Heartbeat;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
@Deprecated
public final class SubmitContext
implements ClientElement {
    @Parameter
    private boolean defer = true;
    @Parameter(allowNull=false, defaultPrefix="literal")
    private String event = "selected";
    @Parameter(value="false")
    private boolean disabled;
    @Parameter
    private String context;
    @Parameter(defaultPrefix="asset")
    private Asset image;
    @Environmental
    private FormSupport formSupport;
    @Environmental
    private Heartbeat heartbeat;
    @Inject
    private ComponentResources resources;
    @Inject
    private Request request;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    private Element element;
    private String clientId;

    public SubmitContext() {
    }

    SubmitContext(Request request) {
        this.request = request;
    }

    void beginRender(MarkupWriter writer) {
        this.clientId = null;
        String name = this.formSupport.allocateControlName(this.resources.getId());
        String type = this.image == null ? "submit" : "image";
        this.element = writer.element("input", new Object[]{"type", type, "name", name});
        if (this.disabled) {
            writer.attributes(new Object[]{"disabled", "disabled"});
        }
        if (this.image != null) {
            writer.attributes(new Object[]{"src", this.image.toClientURL()});
        }
        this.formSupport.store((Object)this, (ComponentAction)new ProcessSubmission(name, this.context));
        this.resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    void processSubmission(String elementName, final String context) {
        if (this.disabled) {
            return;
        }
        String value = this.request.getParameter(elementName);
        if (value == null) {
            return;
        }
        Runnable sendNotification = new Runnable(){

            @Override
            public void run() {
                SubmitContext.this.resources.triggerEvent(SubmitContext.this.event, new Object[]{context}, null);
            }
        };
        if (this.defer) {
            this.formSupport.defer(sendNotification);
        } else {
            this.heartbeat.defer(sendNotification);
        }
    }

    void setDefer(boolean defer) {
        this.defer = defer;
    }

    void setup(ComponentResources resources, FormSupport formSupport, Heartbeat heartbeat, JavaScriptSupport javaScriptSupport) {
        this.resources = resources;
        this.formSupport = formSupport;
        this.heartbeat = heartbeat;
        this.javaScriptSupport = javaScriptSupport;
    }

    public String getClientId() {
        if (this.clientId == null) {
            this.clientId = this.javaScriptSupport.allocateClientId(this.resources);
            this.element.forceAttributes(new String[]{"id", this.clientId});
        }
        return this.clientId;
    }

    private static class ProcessSubmission
    implements ComponentAction<SubmitContext> {
        private final String elementName;
        private final String context;

        public ProcessSubmission(String elementName, String context) {
            this.elementName = elementName;
            this.context = context;
        }

        public void execute(SubmitContext component) {
            component.processSubmission(this.elementName, this.context);
        }
    }
}

