/*
 * #%L
 * Nuiton Web :: Nuiton Struts 2
 * 
 * $Id: FilterPagerUtil.java 179 2012-02-08 07:10:16Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-web/tags/nuiton-web-1.9.2/nuiton-struts2/src/main/java/org/nuiton/web/struts2/FilterPagerUtil.java $
 * %%
 * Copyright (C) 2010 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.web.struts2;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.util.PagerUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * TODO
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.9.2
 */
public class FilterPagerUtil extends PagerUtil {

    protected FilterPagerUtil() {
    }

    public static TopiaQuery addPagerToQuery(TopiaQuery query,
                                             FilterPagerBean pager) {
        PagerUtil.computeRecordIndexesAndPagesNumber(pager);
        query.setLimit(pager.getRecordStartIndex(),
                       pager.getRecordEndIndex() - 1);

        if (StringUtils.isNotEmpty(pager.getSortColumn())) {
            if (pager.isSortAscendant()) {
                query.addOrder(pager.getSortColumn());
            } else {
                query.addOrderDesc(pager.getSortColumn());
            }
        }
        return query;
    }

    public static <E> List<E> getPageFromList(List<E> elements,
                                              FilterPagerBean pager) {

        PagerUtil.computeRecordIndexesAndPagesNumber(pager);
        List<E> subList = getPage(elements, pager.getPageIndex(), pager.getPageSize());
        List<E> result = new ArrayList<E>(subList);

        return result;
    }

    public static FilterPagerBean newFilterPagerBean() {
        return new FilterPagerBean();
    }

    public static class FilterPagerBean extends PagerBean {

        private static final long serialVersionUID = 1L;

        // sorting order - asc or desc
        protected boolean sortAscendant;

        // get index row - i.e. user click to sort.
        protected String sortColumn;

        protected FilterOperationGroup groupOp;

        private List<FilterRule> rules;

        public boolean canFilter() {
            return groupOp != null && CollectionUtils.isNotEmpty(rules);
        }

        public FilterOperationGroup getGroupOp() {
            return groupOp;
        }

        public void setGroupOp(FilterOperationGroup groupOp) {
            this.groupOp = groupOp;
        }

        public List<FilterRule> getRules() {
            return rules;
        }

        public void setRules(List<FilterRule> rules) {
            this.rules = rules;
        }

        public boolean isSortAscendant() {
            return sortAscendant;
        }

        public void setSortAscendant(boolean sortAscendant) {
            this.sortAscendant = sortAscendant;
        }

        public String getSortColumn() {
            return sortColumn;
        }

        public void setSortColumn(String sortColumn) {
            this.sortColumn = sortColumn;
        }
    }

    public static class FilterRule implements Serializable {

        private static final long serialVersionUID = 1L;

        protected final FilterOperation op;

        protected final String field;

        protected final String data;

        public FilterRule(FilterOperation op,
                          String field,
                          String data) {
            this.op = op;
            this.field = field;
            this.data = data;
        }

        public FilterOperation getOp() {
            return op;
        }

        public String getField() {
            return field;
        }

        public String getData() {
            return data;
        }
    }

    public enum FilterOperationGroup {
        OR, AND
    }

    public enum FilterOperation {
        /** Equals operator. */
        eq {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " = :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        },
        /** Not equals operator. */
        ne {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " != :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        },
        /** Contains operator. */
        cn {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " like :" + paramName;
                filterParams.put(paramName, "%" + data + "%");
                return ruleFilter;
            }
        },
        /** Not contains operator. */
        nc {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " not like :" + paramName;
                filterParams.put(paramName, "%" + data + "%");
                return ruleFilter;
            }
        },
        /** Begins with operator. */
        bw {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " like :" + paramName;
                filterParams.put(paramName, data + "%");
                return ruleFilter;
            }
        },
        /** Not between with operator. */
        bn {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " not like :" + paramName;
                filterParams.put(paramName, data + "%");
                return ruleFilter;
            }
        },
        /** Ends with operator. */
        ew {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " like :" + paramName;
                filterParams.put(paramName, "%" + data);
                return ruleFilter;
            }
        },
        /** Not End with operator. */
        en {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " not like :" + paramName;
                filterParams.put(paramName, "%" + data);
                return ruleFilter;
            }
        },
        /** Lesser than operator. */
        lt {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " < :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        },
        /** Lesser or equals operator. */
        le {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " <= :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        },
        /** Greater than operator. */
        gt {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " > :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        },
        /** Greater or equals operator. */
        ge {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " >= :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        },
        /** Is null operator. */
        nu {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " is null";
                return ruleFilter;
            }
        },
        /** Is not null operator. */
        nn {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " is not null";
                return ruleFilter;
            }
        },
        /** Is among operator. */
        in {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                throw new UnsupportedOperationException();
            }
        },
        /** Not is among operator. */
        ni {
            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                throw new UnsupportedOperationException();
            }
        };

        public abstract String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams);
    }


    public static FilterPagerBeanBuilder newFilterPagerBeanBuilder(String operationGroup) {
        FilterOperationGroup operationGroup1 = FilterOperationGroup.valueOf(operationGroup);
        FilterPagerBeanBuilder builder = new FilterPagerBeanBuilder(operationGroup1);
        return builder;
    }

    public static class FilterPagerBeanBuilder {

        protected final FilterOperationGroup groupOp;

        protected final List<FilterRule> rules;

        public FilterPagerBeanBuilder(FilterOperationGroup groupOp) {
            this.groupOp = groupOp;
            rules = new LinkedList<FilterRule>();
        }

        public FilterPagerBeanBuilder addOperations(Collection<Map<String, String>> operations) {
            for (Map<String, String> operation : operations) {
                addRule(operation);
            }
            return this;
        }

        public FilterPagerBeanBuilder addRule(Map<String, String> ruleMap) {
            String op = ruleMap.get("op");
            String property = ruleMap.get("field");
            String value = ruleMap.get("data");
            FilterOperation operator = FilterOperation.valueOf(op);
            return addRule(new FilterRule(operator, property, value));
        }

        public FilterPagerBeanBuilder addRule(FilterRule rule) {
            rules.add(rule);
            return this;
        }

        public void flush(FilterPagerBean bean) {
            bean.setGroupOp(groupOp);
            bean.setRules(rules);
        }


    }
}
