/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.TextParseUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaTransactionAware;

public abstract class OpenTopiaTransactionInterceptor
extends AbstractInterceptor {
    private static final Log log = LogFactory.getLog(OpenTopiaTransactionInterceptor.class);
    private static final long serialVersionUID = 1L;
    public static final String TOPIA_TRANSACTION_REQUEST_ATTRIBUTE = "topiaTransaction";
    public static final String[] DEFAULT_EXCLUDE_METHODS = new String[]{"beginTransaction", "closeContext", "clear"};
    protected Set<String> excludeMethods;

    public Set<String> getExcludeMethods() {
        return this.excludeMethods;
    }

    public void setExcludeMethods(String excludeMethods) {
        this.excludeMethods = TextParseUtil.commaDelimitedStringToSet((String)excludeMethods);
    }

    protected abstract TopiaContext beginTransaction() throws TopiaException;

    public void init() {
        super.init();
        if (this.getExcludeMethods() == null) {
            this.excludeMethods = new HashSet<String>(Arrays.asList(DEFAULT_EXCLUDE_METHODS));
        }
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        TopiaTransactionAware transactionAware = null;
        Object action = invocation.getProxy().getAction();
        if (action instanceof TopiaTransactionAware) {
            transactionAware = (TopiaTransactionAware)action;
        }
        if (transactionAware == null) {
            return invocation.invoke();
        }
        TopiaTransactionProxyInvocationHandler proxyInvocationHandler = new TopiaTransactionProxyInvocationHandler();
        TopiaContext proxy = (TopiaContext)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{TopiaContext.class, TopiaContextImplementor.class}, (InvocationHandler)proxyInvocationHandler);
        transactionAware.setTransaction(proxy);
        return invocation.invoke();
    }

    public class TopiaTransactionProxyInvocationHandler
    implements InvocationHandler {
        protected TopiaContext transaction;

        public TopiaContext getTransaction() {
            return this.transaction;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (OpenTopiaTransactionInterceptor.this.getExcludeMethods().contains(methodName)) {
                throw new IllegalAccessException("Not allowed to access method " + methodName + " on " + proxy);
            }
            if (this.transaction == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("transaction started due to a call to " + methodName));
                }
                this.transaction = OpenTopiaTransactionInterceptor.this.beginTransaction();
                ServletActionContext.getRequest().setAttribute(OpenTopiaTransactionInterceptor.TOPIA_TRANSACTION_REQUEST_ATTRIBUTE, (Object)this.transaction);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Open transaction " + this.transaction));
                }
            }
            try {
                Object result = method.invoke((Object)this.transaction, args);
                return result;
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Could not execute method " + method.getName()), (Throwable)eee);
                }
                throw eee;
            }
        }
    }
}

