/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import java.util.Properties;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnumProvider;
import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContextConstructorParameter;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.templates.TopiaTagValues;
import org.nuiton.topia.templates.TopiaTemplateHelper;

public class ApplicationContextTransformer
extends ObjectModelTransformerToJava {
    protected TopiaTemplateHelper templateHelper;
    protected TopiaTagValues topiaTagValues;

    public void transformFromModel(ObjectModel input) {
        boolean generateConcrete;
        if (this.templateHelper == null) {
            this.templateHelper = new TopiaTemplateHelper((ObjectModel)this.model);
        }
        if (this.topiaTagValues == null) {
            this.topiaTagValues = this.templateHelper.getTopiaTagValues();
        }
        String packageName = this.templateHelper.getApplicationContextPackage(this, (ObjectModel)this.model);
        String applicationContextAbstractName = this.templateHelper.getApplicationContextAbstractName((ObjectModel)this.model);
        String applicationContextConcreteName = this.templateHelper.getApplicationContextConcreteName((ObjectModel)this.model);
        boolean generateAbstract = !this.isInClassPath(packageName, applicationContextAbstractName);
        boolean bl = generateConcrete = !this.isInClassPath(packageName, applicationContextConcreteName);
        if (generateAbstract) {
            this.generateAbstract(packageName, applicationContextAbstractName);
        }
        if (generateConcrete) {
            this.generateImpl(packageName, applicationContextAbstractName, applicationContextConcreteName);
        }
    }

    protected void generateAbstract(String packageName, String className) {
        String superClass = this.topiaTagValues.getApplicationContextSuperClassTagValue((ObjectModel)this.model);
        if (superClass == null) {
            superClass = AbstractTopiaApplicationContext.class.getName();
        }
        ObjectModelClass output = this.createAbstractClass(className, packageName);
        String persistenceContextConcreteName = this.templateHelper.getPersistenceContextConcreteName((ObjectModel)this.model);
        this.setSuperClass(output, superClass + "<" + persistenceContextConcreteName + ">");
        String contractName = this.templateHelper.getApplicationContextInterfaceName((ObjectModel)this.model);
        boolean addPersistenceContextContract = this.isInClassPath(packageName, contractName);
        if (addPersistenceContextContract) {
            this.addInterface((ObjectModelClassifier)output, packageName + "." + contractName);
        }
        String modelName = ((ObjectModel)this.model).getName();
        String entityEnumName = modelName + "EntityEnum";
        this.addImport((ObjectModelClassifier)output, TopiaEntityEnumProvider.class);
        this.addInterface((ObjectModelClassifier)output, TopiaEntityEnumProvider.class.getName() + "<" + entityEnumName + ">");
        boolean generateOperator = this.topiaTagValues.getGenerateOperatorForDAOHelperTagValue((ObjectModel)this.model);
        this.addImport((ObjectModelClassifier)output, TopiaEntity.class);
        if (generateOperator) {
            this.addImport((ObjectModelClassifier)output, EntityOperator.class);
        }
        this.addConstructors(output, false);
        this.addImport((ObjectModelClassifier)output, AbstractTopiaPersistenceContextConstructorParameter.class);
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "newPersistenceContext", persistenceContextConcreteName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n\n        " + persistenceContextConcreteName + " newContext = new " + persistenceContextConcreteName + "(\n" + "                new AbstractTopiaPersistenceContextConstructorParameter(\n" + "                        getHibernateProvider(),\n" + "                        getTopiaFiresSupport(),\n" + "                        getTopiaIdFactory(),\n" + "                        getSessionRegistry()\n" + "                )\n" + "        );\n" + "        registerPersistenceContext(newContext);\n" + "        return newContext;\n" + "    ");
        String modelVersion = ((ObjectModel)this.model).getVersion();
        op = this.addOperation((ObjectModelClassifier)output, "getModelVersion", "String", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return \"" + modelVersion + "\";\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)output, "getModelName", "String", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return \"" + modelName + "\";\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)output, "getContractClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class);
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n        return " + entityEnumName + ".getContractClass(klass);\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)output, "getContractClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return " + entityEnumName + ".getContractClasses();\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)output, "getImplementationClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class);
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n        return " + entityEnumName + ".getImplementationClass(klass);\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)output, "getImplementationClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return " + entityEnumName + ".getImplementationClasses();\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)output, "getContracts", entityEnumName + "[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(op, "\n        return " + entityEnumName + ".getContracts();\n" + "    ");
        if (generateOperator) {
            op = this.addOperation((ObjectModelClassifier)output, "getOperator", "<T extends TopiaEntity> EntityOperator<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(op, "Class<T>", "klass");
            this.setOperationBody(op, "\n        return " + entityEnumName + ".getOperator(klass);\n" + "    ");
        }
        op = this.addOperation((ObjectModelClassifier)output, "getEntityEnum", "<E extends TopiaEntity> " + entityEnumName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class);
        this.addParameter(op, "Class<E>", "type");
        this.setOperationBody(op, "\n        return " + entityEnumName + ".valueOf(type);\n" + "    ");
    }

    protected ObjectModelClass generateImpl(String packageName, String applicationContextAbstractName, String applicationContextConcreteName) {
        ObjectModelClass output = this.createClass(applicationContextConcreteName, packageName);
        this.setSuperClass(output, applicationContextAbstractName);
        this.addConstructors(output, true);
        return output;
    }

    protected void addConstructors(ObjectModelClass output, boolean isPublic) {
        ObjectModelJavaModifier visibility = isPublic ? ObjectModelJavaModifier.PUBLIC : ObjectModelJavaModifier.PROTECTED;
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)visibility);
        this.addParameter(constructor, Properties.class, "properties");
        this.setOperationBody(constructor, "\n        super(properties);\n    ");
        constructor = this.addConstructor(output, (ObjectModelModifier)visibility);
        this.addParameter(constructor, "java.util.Map<String, String>", "configuration");
        this.setOperationBody(constructor, "\n        super(configuration);\n    ");
    }
}

