package org.nuiton.topia.security.entities.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Sat Apr 11 05:26:43 UTC 2015")
public abstract class TopiaUserAbstract extends TopiaEntityAbstract implements TopiaUser {

    /**
     * Nom de l'attribut en BD : login
     */
    protected String login;

    /**
     * Nom de l'attribut en BD : email
     */
    protected String email;

    /**
     * Nom de l'attribut en BD : password
     */
    protected String password;

    /**
     * Nom de l'attribut en BD : note
     */
    protected String note;

    /**
     * Nom de l'attribut en BD : linkApplication
     */
    protected String linkApplication;

    /**
     * Nom de l'attribut en BD : topiaGroup
     */
    protected Collection<TopiaGroup> topiaGroup;

    private static final long serialVersionUID = 3775485650828419892L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_LOGIN, String.class, login);
        visitor.visit(this, PROPERTY_EMAIL, String.class, email);
        visitor.visit(this, PROPERTY_PASSWORD, String.class, password);
        visitor.visit(this, PROPERTY_NOTE, String.class, note);
        visitor.visit(this, PROPERTY_LINK_APPLICATION, String.class, linkApplication);
        visitor.visit(this, PROPERTY_TOPIA_GROUP, Collection.class, TopiaGroup.class, topiaGroup);
    }

    @Override
    public void setLogin(String login) {
        String oldValue = this.login;
        fireOnPreWrite(PROPERTY_LOGIN, oldValue, login);
        this.login = login;
        fireOnPostWrite(PROPERTY_LOGIN, oldValue, login);
    }

    @Override
    public String getLogin() {
        fireOnPreRead(PROPERTY_LOGIN, login);

        String result = this.login;

        fireOnPostRead(PROPERTY_LOGIN, login);

        return result;
    }

    @Override
    public void setEmail(String email) {
        String oldValue = this.email;
        fireOnPreWrite(PROPERTY_EMAIL, oldValue, email);
        this.email = email;
        fireOnPostWrite(PROPERTY_EMAIL, oldValue, email);
    }

    @Override
    public String getEmail() {
        fireOnPreRead(PROPERTY_EMAIL, email);

        String result = this.email;

        fireOnPostRead(PROPERTY_EMAIL, email);

        return result;
    }

    @Override
    public void setPassword(String password) {
        String oldValue = this.password;
        fireOnPreWrite(PROPERTY_PASSWORD, oldValue, password);
        this.password = password;
        fireOnPostWrite(PROPERTY_PASSWORD, oldValue, password);
    }

    @Override
    public String getPassword() {
        fireOnPreRead(PROPERTY_PASSWORD, password);

        String result = this.password;

        fireOnPostRead(PROPERTY_PASSWORD, password);

        return result;
    }

    @Override
    public void setNote(String note) {
        String oldValue = this.note;
        fireOnPreWrite(PROPERTY_NOTE, oldValue, note);
        this.note = note;
        fireOnPostWrite(PROPERTY_NOTE, oldValue, note);
    }

    @Override
    public String getNote() {
        fireOnPreRead(PROPERTY_NOTE, note);

        String result = this.note;

        fireOnPostRead(PROPERTY_NOTE, note);

        return result;
    }

    @Override
    public void setLinkApplication(String linkApplication) {
        String oldValue = this.linkApplication;
        fireOnPreWrite(PROPERTY_LINK_APPLICATION, oldValue, linkApplication);
        this.linkApplication = linkApplication;
        fireOnPostWrite(PROPERTY_LINK_APPLICATION, oldValue, linkApplication);
    }

    @Override
    public String getLinkApplication() {
        fireOnPreRead(PROPERTY_LINK_APPLICATION, linkApplication);

        String result = this.linkApplication;

        fireOnPostRead(PROPERTY_LINK_APPLICATION, linkApplication);

        return result;
    }

    @Override
    public void addTopiaGroup(TopiaGroup topiaGroup) {
        fireOnPreWrite(PROPERTY_TOPIA_GROUP, null, topiaGroup);
        if (this.topiaGroup == null) {
            this.topiaGroup = new ArrayList<TopiaGroup>();
        }

        if (topiaGroup.getTopiaUser() == null) {
            topiaGroup.setTopiaUser(new ArrayList<TopiaUser>());
        }
        topiaGroup.getTopiaUser().add(this);

        this.topiaGroup.add(topiaGroup);
        fireOnPostWrite(PROPERTY_TOPIA_GROUP, this.topiaGroup.size(), null, topiaGroup);
    }

    @Override
    public void addAllTopiaGroup(Collection<TopiaGroup> topiaGroup) {
        if (topiaGroup == null) {
            return;
        }
        for (TopiaGroup item : topiaGroup) {
            addTopiaGroup(item);
        }
    }

    @Override
    public void setTopiaGroup(Collection<TopiaGroup> topiaGroup) {
        // Copy elements to keep data for fire with new reference
        Collection<TopiaGroup> oldValue = this.topiaGroup != null ? new ArrayList<TopiaGroup>(this.topiaGroup) : null;
        fireOnPreWrite(PROPERTY_TOPIA_GROUP, oldValue, topiaGroup);
        this.topiaGroup = topiaGroup;
        fireOnPostWrite(PROPERTY_TOPIA_GROUP, oldValue, topiaGroup);
    }

    @Override
    public void removeTopiaGroup(TopiaGroup topiaGroup) {
        fireOnPreWrite(PROPERTY_TOPIA_GROUP, topiaGroup, null);
        if (this.topiaGroup == null || !this.topiaGroup.remove(topiaGroup)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        topiaGroup.getTopiaUser().remove(this);

        fireOnPostWrite(PROPERTY_TOPIA_GROUP, this.topiaGroup.size() + 1, topiaGroup, null);
    }

    @Override
    public void clearTopiaGroup() {
        if (this.topiaGroup == null) {
            return;
        }
        for (TopiaGroup item : this.topiaGroup) {
            item.getTopiaUser().remove(this);
        }
        Collection<TopiaGroup> oldValue = new ArrayList<TopiaGroup>(this.topiaGroup);
        fireOnPreWrite(PROPERTY_TOPIA_GROUP, oldValue, this.topiaGroup);
        this.topiaGroup.clear();
        fireOnPostWrite(PROPERTY_TOPIA_GROUP, oldValue, this.topiaGroup);
    }

    @Override
    public Collection<TopiaGroup> getTopiaGroup() {
        return topiaGroup;
    }

    @Override
    public TopiaGroup getTopiaGroupByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(topiaGroup, topiaId);
    }

    @Override
    public int sizeTopiaGroup() {
        if (topiaGroup == null) {
            return 0;
        }
        return topiaGroup.size();
    }

    @Override
    public boolean isTopiaGroupEmpty() {
        int size = sizeTopiaGroup();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_LOGIN, this.login).
            append(PROPERTY_EMAIL, this.email).
            append(PROPERTY_PASSWORD, this.password).
            append(PROPERTY_NOTE, this.note).
            append(PROPERTY_LINK_APPLICATION, this.linkApplication).
         toString();
        return result;
    }

} //TopiaUserAbstract
