/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.security.listener;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.security.TopiaSecurityServiceImpl;

public class PropertyReadListener
implements VetoableChangeListener {
    private static Log log = LogFactory.getLog(PropertyReadListener.class);
    private TopiaSecurityServiceImpl securityManager;

    public PropertyReadListener(TopiaSecurityServiceImpl securityManager) {
        this.securityManager = securityManager;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        Object source = event.getSource();
        TopiaEntityAbstract entity = (TopiaEntityAbstract)source;
        Boolean authorized = this.securityManager.getEntitiesLoadingCache(entity.getTopiaId());
        if (authorized != null) {
            if (!authorized.booleanValue()) {
                throw new SecurityException("Access denied to Read entity " + entity.getTopiaId() + " on " + event.getPropertyName());
            }
        } else {
            try {
                this.securityManager.checkPermission(entity.getTopiaId(), 1);
            }
            catch (SecurityException te) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("[Security] Read denied to : " + entity.getTopiaId()), (Throwable)te);
                }
                throw new SecurityException("Access denied to Read entity " + entity.getTopiaId() + " on " + event.getPropertyName(), te);
            }
        }
    }
}

