/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.security.jaas;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.security.TopiaSecurityServiceImpl;
import org.nuiton.topia.security.entities.user.TopiaGroup;
import org.nuiton.topia.security.entities.user.TopiaUserDAO;
import org.nuiton.topia.security.jaas.TopiaPrincipal;

public class TopiaLoginModule
implements LoginModule {
    private Log log = LogFactory.getLog(TopiaLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Set<Principal> principals;
    private TopiaSecurityServiceImpl securityManager;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.principals = null;
        this.securityManager = (TopiaSecurityServiceImpl)options.get("topia.app.security.manager");
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("CallbackHandler cannot be null");
        }
        if (this.securityManager == null) {
            throw new LoginException("\"topia.app.security.manager\" property must be set");
        }
        String password = null;
        NameCallback nc = new NameCallback("login");
        PasswordCallback pc = new PasswordCallback("password", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception eee) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"Utilisation du CallbackHandler impossible", (Throwable)eee);
            }
            LoginException le = new LoginException("Utilisation du CallbackHandler impossible");
            le.initCause(eee);
            throw le;
        }
        String login = nc.getName();
        password = new String(pc.getPassword());
        pc.clearPassword();
        try {
            TopiaUserDAO topiaUserDAO = this.securityManager.getTopiaUserDAO();
            Object user = topiaUserDAO.findByLogin(login);
            if (user != null && user.checkPassword(password)) {
                this.principals = new HashSet<Principal>();
                String topiaIdUser = user.getTopiaId();
                this.principals.add(new TopiaPrincipal(topiaIdUser));
                this.securityManager.putPermissionsCache(topiaIdUser);
                this.securityManager.removeEntitiesLoadingCache(topiaIdUser);
                HashSet groups = new HashSet(this.securityManager.getSecurityContext().find("select topiaGroup from " + TopiaGroup.class.getName() + " topiaGroup join topiaGroup.topiaUser as topiaUser where topiaUser = :user", new Object[]{"user", user}));
                if (groups != null) {
                    for (TopiaGroup group : groups) {
                        for (TopiaGroup superGroup : group.getAllSuperGroup()) {
                            String topiaIdGroup = superGroup.getTopiaId();
                            this.principals.add(new TopiaPrincipal(topiaIdGroup));
                            this.securityManager.putPermissionsCache(topiaIdGroup);
                        }
                        String topiaIdGroup = group.getTopiaId();
                        this.principals.add(new TopiaPrincipal(topiaIdGroup));
                        this.securityManager.putPermissionsCache(topiaIdGroup);
                    }
                }
            } else {
                this.principals = null;
                throw new LoginException("Erreur lors de l'authentification " + login);
            }
            this.securityManager.getSecurityContext().commitTransaction();
        }
        catch (TopiaException te) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"Erreur lors de l'authentification", (Throwable)te);
            }
            LoginException le = new LoginException("Erreur lors de l'authentification");
            le.initCause(te);
            throw le;
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrincipals().addAll(this.principals);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return this.logout();
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.subject = null;
        this.principals.clear();
        this.principals = null;
        this.callbackHandler = null;
        return true;
    }
}

