package org.nuiton.topia.security.entities.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class TopiaEntityAuthorizationDAOAbstract<E extends TopiaEntityAuthorization> extends TopiaAuthorizationDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TopiaEntityAuthorization.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByExpression :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut expression le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByExpression(String v) throws TopiaException {
        E result = findByProperty(TopiaEntityAuthorization.EXPRESSION, v);
        return result;
    }

    /**
     * findAllByExpression :
     * Retourne les éléments ayant comme valeur pour l'attribut expression le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByExpression(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaEntityAuthorization.EXPRESSION, v);
        return result;
    }

    /**
     * findByActions :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut actions le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByActions(int v) throws TopiaException {
        E result = findByProperty(TopiaEntityAuthorization.ACTIONS, v);
        return result;
    }

    /**
     * findAllByActions :
     * Retourne les éléments ayant comme valeur pour l'attribut actions le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByActions(int v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaEntityAuthorization.ACTIONS, v);
        return result;
    }

    /**
     * findByPrincipals :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut principals le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPrincipals(Set v) throws TopiaException {
        E result = findByProperty(TopiaEntityAuthorization.PRINCIPALS, v);
        return result;
    }

    /**
     * findAllByPrincipals :
     * Retourne les éléments ayant comme valeur pour l'attribut principals le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPrincipals(Set v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaEntityAuthorization.PRINCIPALS, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<?>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<?>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<?>, List<? extends TopiaEntity>>();
    }


} //TopiaEntityAuthorizationDAOAbstract<E extends TopiaEntityAuthorization>
