package org.nuiton.topia.security.entities.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class TopiaGroupAbstract extends TopiaEntityAbstract implements TopiaGroup {

    public String name;
    public String description;
    public Collection<TopiaUser> topiaUser;
    public TopiaGroup superGroup;
    public Collection<TopiaGroup> subGroup;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaGroup.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaGroup.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "description", String.class, description);
        visitor.visit(this, "topiaUser", Collection.class, TopiaUser.class, topiaUser);
        visitor.visit(this, "superGroup", TopiaGroup.class, superGroup);
        visitor.visit(this, "subGroup", Collection.class, TopiaGroup.class, subGroup);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setDescription :
     * @param value 
     */

    public void setDescription(String value) {
        String _oldValue = this.description;
        fireOnPreWrite("description", _oldValue, value);
        this.description = value;
        fireOnPostWrite("description", _oldValue, value);
}

    /**
     * getDescription :
     * @return String 
     */

    public String getDescription() {
        fireOnPreRead("description", description);
        String result = this.description;
        fireOnPostRead("description", description);
        return result;
}

    /**
     * addTopiaUser :
     * @param topiaUser 
     */

    public void addTopiaUser(TopiaUser topiaUser) {    
        fireOnPreWrite("topiaUser", null, topiaUser);
        if (this.topiaUser == null) {
            this.topiaUser = new ArrayList<TopiaUser>();
        }
        if (topiaUser.getTopiaGroup() == null) {
            topiaUser.setTopiaGroup(new ArrayList<TopiaGroup>());
        }
        topiaUser.getTopiaGroup().add(this);
        this.topiaUser.add(topiaUser);
        fireOnPostWrite("topiaUser", this.topiaUser.size(), null, topiaUser);
}

    /**
     * addAllTopiaUser :
     * @param values 
     */

    public void addAllTopiaUser(Collection<TopiaUser> values) {
        if (values == null) {
            return;
        }
        for (TopiaUser item : values) {
            addTopiaUser(item);
        }
}

    /**
     * getTopiaUserByTopiaId :
     * @param topiaId 
     * @return TopiaUser 
     */

    public TopiaUser getTopiaUserByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(topiaUser, topiaId);
 }

    /**
     * setTopiaUser :
     * @param values 
     */

    public void setTopiaUser(Collection<TopiaUser> values) {
        Collection<TopiaUser> _oldValue = topiaUser;
        fireOnPreWrite("topiaUser", _oldValue, values);
        topiaUser = values;
        fireOnPostWrite("topiaUser", _oldValue, values);
}

    /**
     * removeTopiaUser :
     * @param value 
     */

    public void removeTopiaUser(TopiaUser value) {
        fireOnPreWrite("topiaUser", value, null);
        if ((this.topiaUser == null) || (!this.topiaUser.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.getTopiaGroup().remove(this);
        fireOnPostWrite("topiaUser", this.topiaUser.size()+1, value, null);
}

    /**
     * clearTopiaUser :
     */

    public void clearTopiaUser() {
        if (this.topiaUser == null) {
            return;
        }
        for (TopiaUser item : this.topiaUser) {
            item.getTopiaGroup().remove(this);
        }
        Collection<TopiaUser> _oldValue = new ArrayList<TopiaUser>(this.topiaUser);
        fireOnPreWrite("topiaUser", _oldValue, this.topiaUser);
        this.topiaUser.clear();
        fireOnPostWrite("topiaUser", _oldValue, this.topiaUser);
}

    /**
     * getTopiaUser :
     * @return Collection<TopiaUser> 
     */

    public Collection<TopiaUser> getTopiaUser() {
        return topiaUser;
}

    /**
     * sizeTopiaUser :
     * @return int 
     */

    public int sizeTopiaUser() {
        if (topiaUser == null) {
            return 0;
        }
        return topiaUser.size();
}

    /**
     * isTopiaUserEmpty :
     * @return boolean 
     */

    public boolean isTopiaUserEmpty() {
        int size = sizeTopiaUser();
        return size == 0;
}

    /**
     * setSuperGroup :
     * @param value 
     */

    public void setSuperGroup(TopiaGroup value) {
        TopiaGroup _oldValue = this.superGroup;
        fireOnPreWrite("superGroup", _oldValue, value);
        this.superGroup = value;
        fireOnPostWrite("superGroup", _oldValue, value);
}

    /**
     * getSuperGroup :
     * @return TopiaGroup 
     */

    public TopiaGroup getSuperGroup() {
        fireOnPreRead("superGroup", superGroup);
        TopiaGroup result = this.superGroup;
        fireOnPostRead("superGroup", superGroup);
        return result;
}

    /**
     * addSubGroup :
     * @param subGroup 
     */

    public void addSubGroup(TopiaGroup subGroup) {    
        fireOnPreWrite("subGroup", null, subGroup);
        if (this.subGroup == null) {
            this.subGroup = new ArrayList<TopiaGroup>();
        }
        subGroup.setSuperGroup(this);
        this.subGroup.add(subGroup);
        fireOnPostWrite("subGroup", this.subGroup.size(), null, subGroup);
}

    /**
     * addAllSubGroup :
     * @param values 
     */

    public void addAllSubGroup(Collection<TopiaGroup> values) {
        if (values == null) {
            return;
        }
        for (TopiaGroup item : values) {
            addSubGroup(item);
        }
}

    /**
     * getSubGroupByTopiaId :
     * @param topiaId 
     * @return TopiaGroup 
     */

    public TopiaGroup getSubGroupByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(subGroup, topiaId);
 }

    /**
     * setSubGroup :
     * @param values 
     */

    public void setSubGroup(Collection<TopiaGroup> values) {
        Collection<TopiaGroup> _oldValue = subGroup;
        fireOnPreWrite("subGroup", _oldValue, values);
        subGroup = values;
        fireOnPostWrite("subGroup", _oldValue, values);
}

    /**
     * removeSubGroup :
     * @param value 
     */

    public void removeSubGroup(TopiaGroup value) {
        fireOnPreWrite("subGroup", value, null);
        if ((this.subGroup == null) || (!this.subGroup.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setSuperGroup(null);
        fireOnPostWrite("subGroup", this.subGroup.size()+1, value, null);
}

    /**
     * clearSubGroup :
     */

    public void clearSubGroup() {
        if (this.subGroup == null) {
            return;
        }
        for (TopiaGroup item : this.subGroup) {
            item.setSuperGroup(null);
        }
        Collection<TopiaGroup> _oldValue = new ArrayList<TopiaGroup>(this.subGroup);
        fireOnPreWrite("subGroup", _oldValue, this.subGroup);
        this.subGroup.clear();
        fireOnPostWrite("subGroup", _oldValue, this.subGroup);
}

    /**
     * getSubGroup :
     * @return Collection<TopiaGroup> 
     */

    public Collection<TopiaGroup> getSubGroup() {
        return subGroup;
}

    /**
     * sizeSubGroup :
     * @return int 
     */

    public int sizeSubGroup() {
        if (subGroup == null) {
            return 0;
        }
        return subGroup.size();
}

    /**
     * isSubGroupEmpty :
     * @return boolean 
     */

    public boolean isSubGroupEmpty() {
        int size = sizeSubGroup();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("description", this.description).
         toString();
        return result;
}


} //TopiaGroupAbstract
