/*
 * #%L
 * ToPIA :: Service Migration
 * 
 * $Id: SimpleProxyClassMapped.java 2010 2010-06-13 18:18:35Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.4/topia-service-migration/src/main/java/org/nuiton/topia/migration/common/SimpleProxyClassMapped.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.migration.common;

import java.io.Serializable;

import org.nuiton.topia.migration.TopiaMigrationEngine;
import org.nuiton.topia.migration.transformation.Migration;

/**
 * SimpleProxyClassMapped.java
 *
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @deprecated since 2.3.4, please use now the simplify service {@link TopiaMigrationEngine}
 */
@Deprecated
public class SimpleProxyClassMapped implements ProxyClassMapped {

    private ProxyClass pc;
    private Serializable nameIdAttribute;
    private Migration m;

    /**
     * @param pc
     * @param nameIdAttribute
     */
    public SimpleProxyClassMapped(ProxyClass pc, Serializable nameIdAttribute) {
        this.pc = pc;
        this.nameIdAttribute = nameIdAttribute;
    }

    public SimpleProxyClassMapped(ProxyClass pc, Serializable nameIdAttribute, Migration migration) {
        this.pc = pc;
        this.nameIdAttribute = nameIdAttribute;
        m = migration;
    }

    public SimpleProxyClassMapped(ProxyClass class1) {
        pc = class1;
    }

    /* (non-Javadoc)
     * @see org.nuiton.topia.migration.common.ProxyClassMapped#getIdAttribute()
     */
    @Override
    public Serializable getIdAttribute() {
        return nameIdAttribute;
    }

    /* (non-Javadoc)
     * @see org.nuiton.topia.migration.common.ProxyClassMapped#getProxyClass()
     */
    @Override
    public ProxyClass getProxyClass() {
        return pc;
    }

    /**
     * @param nameIdAttribute the nameIdAttribute to set
     */
    public void setNameIdAttribute(Serializable nameIdAttribute) {
        this.nameIdAttribute = nameIdAttribute;
    }

    @Override
    public int hashCode() {
        return pc.getCanonicalName().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ProxyClassMapped) {
            ProxyClassMapped o = (ProxyClassMapped) other;
            return o.getProxyClass().equals(pc);
        }
        return false;
    }

    @Override
    public String toString() {
        return toString() + "(" + nameIdAttribute + ")";
    }

    @Override
    public Migration getMigrationClass() {
        return m;
    }
}
