/* *##% 
 * ToPIA :: Service Index
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

/* *
 * IndexEnginImplementor.java
 *
 * Created: 13 oct. 06 11:38:28
 *
 * @author poussin
 * @version $Revision: 1459 $
 *
 * Last update: $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia.index;



/**
 * Class used internaly in framework, when you want implement new indexation
 * engin, you must used this interface
 * 
 * @author poussin
 */
public interface TopiaIndexImplementor extends TopiaIndexService {

    /**
     * During object modification in transaction, this method is called to
     * store all modification, but modification must no be done on index
     * 
     * @param id topiaId object
     * @param fields object field value
     */
    public void recordForIndexation(Object id, Object [] fields);
    /**
     * This method is called after commit, to indicate to index all record
     * entry add with addForIndexation method
     */
    public void doIndexation();
    /**
     * called after commit and rollback to clear the modification record
     */
    public void clearLastRecordedIndexation();

}
