package org.nuiton.topia.history.entities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link History}.
 */
public abstract class HistoryAbstract extends TopiaEntityAbstract implements History {

    public Date actionDate;

    public String userId;

    public int action;

    public String type;

    public String target;

    /**
     * Constructeur de HistoryAbstract par défaut.
     */
    public HistoryAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(History.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(History.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "actionDate", Date.class, actionDate);
        visitor.visit(this, "userId", String.class, userId);
        visitor.visit(this, "action", int.class, action);
        visitor.visit(this, "type", String.class, type);
        visitor.visit(this, "target", String.class, target);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see History#setActionDate(Date)
     */
    @Override
    public void setActionDate(Date value) {
        Date _oldValue = this.actionDate;
        fireOnPreWrite("actionDate", _oldValue, value);
        this.actionDate = value;
        fireOnPostWrite("actionDate", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see History#getActionDate()
     */
    @Override
    public Date getActionDate() {
        fireOnPreRead("actionDate", actionDate);
        Date result = this.actionDate;
        fireOnPostRead("actionDate", actionDate);
        return result;
    }

    /* (non-Javadoc)
     * @see History#setUserId(String)
     */
    @Override
    public void setUserId(String value) {
        String _oldValue = this.userId;
        fireOnPreWrite("userId", _oldValue, value);
        this.userId = value;
        fireOnPostWrite("userId", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see History#getUserId()
     */
    @Override
    public String getUserId() {
        fireOnPreRead("userId", userId);
        String result = this.userId;
        fireOnPostRead("userId", userId);
        return result;
    }

    /* (non-Javadoc)
     * @see History#setAction(int)
     */
    @Override
    public void setAction(int value) {
        int _oldValue = this.action;
        fireOnPreWrite("action", _oldValue, value);
        this.action = value;
        fireOnPostWrite("action", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see History#getAction()
     */
    @Override
    public int getAction() {
        fireOnPreRead("action", action);
        int result = this.action;
        fireOnPostRead("action", action);
        return result;
    }

    /* (non-Javadoc)
     * @see History#setType(String)
     */
    @Override
    public void setType(String value) {
        String _oldValue = this.type;
        fireOnPreWrite("type", _oldValue, value);
        this.type = value;
        fireOnPostWrite("type", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see History#getType()
     */
    @Override
    public String getType() {
        fireOnPreRead("type", type);
        String result = this.type;
        fireOnPostRead("type", type);
        return result;
    }

    /* (non-Javadoc)
     * @see History#setTarget(String)
     */
    @Override
    public void setTarget(String value) {
        String _oldValue = this.target;
        fireOnPreWrite("target", _oldValue, value);
        this.target = value;
        fireOnPostWrite("target", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see History#getTarget()
     */
    @Override
    public String getTarget() {
        fireOnPreRead("target", target);
        String result = this.target;
        fireOnPostRead("target", target);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("actionDate", this.actionDate).
            append("userId", this.userId).
            append("action", this.action).
            append("type", this.type).
            append("target", this.target).
         toString();
        return result;
    }
        
} //HistoryAbstract
