package org.nuiton.topia;

import java.lang.reflect.Array;
import java.util.Arrays;
import javax.annotation.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.test.ano1882.FrenchCompany;
import org.nuiton.topia.test.ano1882.FrenchCompanyDAO;
import org.nuiton.topia.test.ano1882.SIREN;
import org.nuiton.topia.test.ano1882.SIRENDAO;
import org.nuiton.topia.test.ano1882.SIRET;
import org.nuiton.topia.test.ano1882.SIRETDAO;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonDAO;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.PetDAO;
import org.nuiton.topia.test.entities.Race;
import org.nuiton.topia.test.entities.RaceDAO;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.AddressDAO;
import org.nuiton.topiatest.Bill;
import org.nuiton.topiatest.BillDAO;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.CompanyDAO;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.DepartmentDAO;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.EmployeDAO;
import org.nuiton.topiatest.ExtraDAOEntity;
import org.nuiton.topiatest.ExtraDAOEntityDAO;
import org.nuiton.topiatest.GeneralizedNaturalizedEntity;
import org.nuiton.topiatest.GeneralizedNaturalizedEntityDAO;
import org.nuiton.topiatest.NaturalizedEntity;
import org.nuiton.topiatest.NaturalizedEntityDAO;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.PersonneDAO;
import org.nuiton.topiatest.Product;
import org.nuiton.topiatest.ProductDAO;
import org.nuiton.topiatest.QueriedEntity;
import org.nuiton.topiatest.QueriedEntityDAO;
import org.nuiton.topiatest.Store;
import org.nuiton.topiatest.StoreDAO;
import org.nuiton.topiatest.Type;
import org.nuiton.topiatest.TypeDAO;
import org.nuiton.topiatest.deletetest.Contact2;
import org.nuiton.topiatest.deletetest.Contact2DAO;
import org.nuiton.topiatest.deletetest.Party2;
import org.nuiton.topiatest.deletetest.Party2DAO;
import org.nuiton.topiatest.deletetest.Telephone2;
import org.nuiton.topiatest.deletetest.Telephone2DAO;

@Generated(value = "org.nuiton.topia.generator.DAOHelperTransformer", date = "Thu Aug 08 17:28:34 CEST 2013")
public class TopiaTestDAOHelper {

    public enum TopiaTestEntityEnum implements TopiaEntityEnum {
        FrenchCompany(FrenchCompany.class, ArrayUtils.EMPTY_STRING_ARRAY),
        SIREN(SIREN.class, ArrayUtils.EMPTY_STRING_ARRAY),
        SIRET(SIRET.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Person(Person.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Pet(Pet.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Race(Race.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Address(Address.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Bill(Bill.class, new String[]{ "store", "company" }),
        Company(Company.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Department(Department.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Employe(Employe.class, ArrayUtils.EMPTY_STRING_ARRAY),
        ExtraDAOEntity(ExtraDAOEntity.class, ArrayUtils.EMPTY_STRING_ARRAY),
        GeneralizedNaturalizedEntity(GeneralizedNaturalizedEntity.class, new String[]{ "naturalIdNotNull" }, "naturalIdNotNull", "naturalIdNull"),
        NaturalizedEntity(NaturalizedEntity.class, new String[]{ "naturalIdNotNull" }, "naturalIdNotNull", "naturalIdNull"),
        Personne(Personne.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Product(Product.class, ArrayUtils.EMPTY_STRING_ARRAY),
        QueriedEntity(QueriedEntity.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Store(Store.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Type(Type.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Contact2(Contact2.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Party2(Party2.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Telephone2(Telephone2.class, ArrayUtils.EMPTY_STRING_ARRAY);

        /**
         * The contract of the entity.
         */
        protected Class<? extends TopiaEntity> contract;

        /**
         * The fully qualified name of the implementation of the entity.
         */
        protected String implementationFQN;

        /**
         * The implementation class of the entity (will be lazy computed at runtime).
         */
        protected Class<? extends TopiaEntity> implementation;

        /**
         * The array of property involved in the natural key of the entity.
         */
        protected String[] naturalIds;

        /**
         * The array of not null properties of the entity.
         */
        protected String[] notNulls;

        TopiaTestEntityEnum(Class<? extends TopiaEntity > contract, String[] notNulls, String... naturalIds)     {
            this.contract = contract;
            this.notNulls = Arrays.copyOf(notNulls, notNulls.length);
            this.naturalIds = naturalIds;
            implementationFQN = contract.getName() + "Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract()     {
            return contract;
        }

        @Override
        public String[] getNaturalIds()     {
            return naturalIds;
        }

        @Override
        public boolean isUseNaturalIds()     {
            return naturalIds.length > 0;
        }

        @Override
        public String[] getNotNulls()     {
            return notNulls;
        }

        @Override
        public boolean isUseNotNulls()     {
            return notNulls.length > 0;
        }

        @Override
        public String getImplementationFQN()     {
            return implementationFQN;
        }

        @Override
        public void setImplementationFQN(String implementationFQN)     {
            this.implementationFQN = implementationFQN;
            implementation = null;
            // reinit the operators store
            EntityOperatorStore.clear();
        }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass)     {
            return TopiaTestDAOHelper.getContractClass(klass) == contract;
        }

        @Override
        public Class<? extends TopiaEntity> getImplementation()     {
            if (implementation == null) {
            try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new TopiaException("could not find class " + implementationFQN, e);
                }
            }
            return implementation;
        }

        public static TopiaTestEntityEnum valueOf(TopiaEntity entity)     {
            return valueOf(entity.getClass());
        }

        public static TopiaTestEntityEnum valueOf(Class<?> klass)     {
            if (klass.isInterface()) {
               return valueOf(klass.getSimpleName());
            }
            for (TopiaTestEntityEnum entityEnum : TopiaTestEntityEnum.values()) {
                if (entityEnum.getContract().isAssignableFrom(klass)) {
                    //todo check it works for inheritance
                    return entityEnum;
                }
            }
            throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(TopiaTestEntityEnum.values()));
        }

    } //TopiaTestEntityEnum

    protected TopiaTestDAOHelper() { }

    public static String getModelVersion() {
        return "1.2";
    }

    public static String getModelName() {
        return "TopiaTest";
    }

    public static FrenchCompanyDAO getFrenchCompanyDAO(TopiaContext context) throws TopiaException {
        FrenchCompanyDAO result = context.getDAO(FrenchCompany.class, FrenchCompanyDAO.class);
        return result;
    }

    public static SIRENDAO getSIRENDAO(TopiaContext context) throws TopiaException {
        SIRENDAO result = context.getDAO(SIREN.class, SIRENDAO.class);
        return result;
    }

    public static SIRETDAO getSIRETDAO(TopiaContext context) throws TopiaException {
        SIRETDAO result = context.getDAO(SIRET.class, SIRETDAO.class);
        return result;
    }

    public static PersonDAO getPersonDAO(TopiaContext context) throws TopiaException {
        PersonDAO result = context.getDAO(Person.class, PersonDAO.class);
        return result;
    }

    public static PetDAO getPetDAO(TopiaContext context) throws TopiaException {
        PetDAO result = context.getDAO(Pet.class, PetDAO.class);
        return result;
    }

    public static RaceDAO getRaceDAO(TopiaContext context) throws TopiaException {
        RaceDAO result = context.getDAO(Race.class, RaceDAO.class);
        return result;
    }

    public static AddressDAO getAddressDAO(TopiaContext context) throws TopiaException {
        AddressDAO result = context.getDAO(Address.class, AddressDAO.class);
        return result;
    }

    public static BillDAO getBillDAO(TopiaContext context) throws TopiaException {
        BillDAO result = context.getDAO(Bill.class, BillDAO.class);
        return result;
    }

    public static CompanyDAO getCompanyDAO(TopiaContext context) throws TopiaException {
        CompanyDAO result = context.getDAO(Company.class, CompanyDAO.class);
        return result;
    }

    public static DepartmentDAO getDepartmentDAO(TopiaContext context) throws TopiaException {
        DepartmentDAO result = context.getDAO(Department.class, DepartmentDAO.class);
        return result;
    }

    public static EmployeDAO getEmployeDAO(TopiaContext context) throws TopiaException {
        EmployeDAO result = context.getDAO(Employe.class, EmployeDAO.class);
        return result;
    }

    public static ExtraDAOEntityDAO getExtraDAOEntityDAO(TopiaContext context) throws TopiaException {
        ExtraDAOEntityDAO result = context.getDAO(ExtraDAOEntity.class, ExtraDAOEntityDAO.class);
        return result;
    }

    public static GeneralizedNaturalizedEntityDAO getGeneralizedNaturalizedEntityDAO(TopiaContext context) throws TopiaException {
        GeneralizedNaturalizedEntityDAO result = context.getDAO(GeneralizedNaturalizedEntity.class, GeneralizedNaturalizedEntityDAO.class);
        return result;
    }

    public static NaturalizedEntityDAO getNaturalizedEntityDAO(TopiaContext context) throws TopiaException {
        NaturalizedEntityDAO result = context.getDAO(NaturalizedEntity.class, NaturalizedEntityDAO.class);
        return result;
    }

    public static PersonneDAO getPersonneDAO(TopiaContext context) throws TopiaException {
        PersonneDAO result = context.getDAO(Personne.class, PersonneDAO.class);
        return result;
    }

    public static ProductDAO getProductDAO(TopiaContext context) throws TopiaException {
        ProductDAO result = context.getDAO(Product.class, ProductDAO.class);
        return result;
    }

    public static QueriedEntityDAO getQueriedEntityDAO(TopiaContext context) throws TopiaException {
        QueriedEntityDAO result = context.getDAO(QueriedEntity.class, QueriedEntityDAO.class);
        return result;
    }

    public static StoreDAO getStoreDAO(TopiaContext context) throws TopiaException {
        StoreDAO result = context.getDAO(Store.class, StoreDAO.class);
        return result;
    }

    public static TypeDAO getTypeDAO(TopiaContext context) throws TopiaException {
        TypeDAO result = context.getDAO(Type.class, TypeDAO.class);
        return result;
    }

    public static Contact2DAO getContact2DAO(TopiaContext context) throws TopiaException {
        Contact2DAO result = context.getDAO(Contact2.class, Contact2DAO.class);
        return result;
    }

    public static Party2DAO getParty2DAO(TopiaContext context) throws TopiaException {
        Party2DAO result = context.getDAO(Party2.class, Party2DAO.class);
        return result;
    }

    public static Telephone2DAO getTelephone2DAO(TopiaContext context) throws TopiaException {
        Telephone2DAO result = context.getDAO(Telephone2.class, Telephone2DAO.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        D dao = (D) context.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(entity);
        D dao = (D) context.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        TopiaTestEntityEnum[] values = TopiaTestEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        TopiaTestEntityEnum[] values = TopiaTestEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static TopiaTestEntityEnum[] getContracts() {
        return TopiaTestEntityEnum.values();
    }

    public static <T extends TopiaEntity> EntityOperator<T> getOperator(Class<T> klass) {
        TopiaTestEntityEnum constant = TopiaTestEntityEnum.valueOf(klass);
        return EntityOperatorStore.getOperator(constant);
    }

} //TopiaTestDAOHelper
