/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.metadata.ClassMetadata;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;
import org.nuiton.util.PagerBean;
import org.nuiton.util.PagerBeanUtil;

public class TopiaDAOImpl<E extends TopiaEntity>
implements TopiaDAO<E> {
    private static Log log = LogFactory.getLog(TopiaDAOImpl.class);
    protected Class<E> entityClass;
    protected TopiaContextImplementor context;
    private int batchSize = 1000;

    @Override
    public TopiaEntityEnum getTopiaEntityEnum() {
        throw new UnsupportedOperationException("This method must be overided in generated DAO");
    }

    @Override
    public Class<E> getEntityClass() {
        throw new UnsupportedOperationException("This method must be overided in generated DAO");
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public Iterator<E> iterator() {
        FindAllIterator iterator = new FindAllIterator(this, this.getEntityClass(), this.batchSize, "FROM " + this.getTopiaEntityEnum().getImplementationFQN() + " ORDER BY id", new Object[0]);
        return iterator;
    }

    protected Serializable getId(E e) throws TopiaException {
        ClassMetadata meta = this.getClassMetadata();
        String idPropName = meta.getIdentifierPropertyName();
        try {
            Serializable result = (Serializable)PropertyUtils.getSimpleProperty(e, (String)idPropName);
            return result;
        }
        catch (Exception eee) {
            throw new TopiaException("Impossible de r\u00e9cuperer l'identifiant " + idPropName + " de l'entite: " + e);
        }
    }

    protected Serializable getId(Map map) throws TopiaException {
        try {
            ClassMetadata meta = this.getClassMetadata();
            String idPropName = meta.getIdentifierPropertyName();
            Serializable id = (Serializable)map.get(idPropName);
            return id;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public void init(TopiaContextImplementor context, Class<E> entityClass) throws TopiaException {
        log.debug((Object)("init dao for " + entityClass.getName()));
        this.context = context;
        this.entityClass = entityClass;
    }

    @Override
    public TopiaContextImplementor getContext() {
        return this.context;
    }

    @Override
    public String createSimpleQuery(String alias) {
        String hql = "FROM " + this.getTopiaEntityEnum().getImplementationFQN();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            hql = hql + " " + alias;
        }
        return hql;
    }

    @Override
    public E newInstance() throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("entityClass = " + this.entityClass));
        }
        Class<? extends TopiaEntity> implementation = this.getTopiaEntityEnum().getImplementation();
        try {
            TopiaEntity result = implementation.newInstance();
            return (E)result;
        }
        catch (Exception e) {
            throw new TopiaException("Impossible de trouver ou d'instancier la classe " + implementation);
        }
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E e) throws TopiaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E e) throws TopiaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Permission> getRequestPermission(String topiaId, int actions) throws TopiaException {
        return null;
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.getContext().addTopiaEntityListener(this.entityClass, listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getContext().addTopiaEntityVetoable(this.entityClass, vetoable);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.getContext().removeTopiaEntityListener(this.entityClass, listener);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getContext().removeTopiaEntityVetoable(this.entityClass, vetoable);
    }

    @Override
    public E create(E entity) throws TopiaException {
        try {
            String topiaId = TopiaId.create(this.entityClass);
            TopiaEntityAbstract entityAbstract = (TopiaEntityAbstract)entity;
            entityAbstract.setTopiaId(topiaId);
            entityAbstract.setTopiaContext(this.getContext());
            this.getSession().save(entity);
            this.getContext().getFiresSupport().warnOnUpdateEntity((TopiaEntity)entity);
            return entity;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public E create(Object ... properties) throws TopiaException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object propertyName = null;
        try {
            int i = 0;
            while (i < properties.length) {
                propertyName = properties[i++];
                Object value = properties[i++];
                map.put((String)propertyName, value);
            }
        }
        catch (ArrayIndexOutOfBoundsException eee) {
            throw new IllegalArgumentException("Wrong number of argument " + properties.length + ", you must have even number. Last property name read: " + propertyName);
        }
        catch (ClassCastException eee) {
            throw new IllegalArgumentException("Wrong argument type, wait property name as String and have " + propertyName.getClass().getName());
        }
        E result = this.create((Map<String, Object>)map);
        return result;
    }

    @Override
    public E create(Map<String, Object> properties) throws TopiaException {
        E result = this.newInstance();
        if (result instanceof TopiaEntity) {
            String topiaId = TopiaId.create(this.entityClass);
            TopiaEntityAbstract entity = (TopiaEntityAbstract)result;
            entity.setTopiaId(topiaId);
            entity.setTopiaContext(this.getContext());
        }
        try {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                String propertyName = e.getKey();
                Object value = e.getValue();
                PropertyUtils.setProperty(result, (String)propertyName, (Object)value);
            }
        }
        catch (IllegalAccessException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (InvocationTargetException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (NoSuchMethodException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        this.getSession().save(result);
        this.getContext().getFiresSupport().warnOnCreateEntity((TopiaEntity)result);
        return result;
    }

    @Override
    public E update(E e) throws TopiaException {
        try {
            this.getSession().saveOrUpdate(e);
            this.getContext().getFiresSupport().warnOnUpdateEntity((TopiaEntity)e);
            return e;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public void delete(E e) throws TopiaException {
        try {
            this.getSession().delete(e);
            this.getContext().getFiresSupport().warnOnDeleteEntity((TopiaEntity)e);
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public void deleteAll(Iterable<E> entities) throws TopiaException {
        for (TopiaEntity entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    public TopiaQuery createQuery() {
        return new TopiaQuery(this.getEntityClass());
    }

    @Override
    public TopiaQuery createQuery(String entityAlias) {
        return new TopiaQuery(this.getEntityClass(), entityAlias);
    }

    @Override
    public E findByTopiaId(String id) throws TopiaException {
        E result = null;
        if (id != null) {
            TopiaQuery query = this.createQuery().addEquals("topiaId", id);
            result = this.findByQuery(query);
        }
        return result;
    }

    @Override
    public E findByProperty(String propertyName, Object value) throws TopiaException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        E result = this.findByProperties(properties);
        return result;
    }

    @Override
    public E findByProperties(String propertyName, Object value, Object ... others) throws TopiaException {
        Map<String, Object> properties = this.convertPropertiesArrayToMap(propertyName, value, others);
        E result = this.findByProperties(properties);
        return result;
    }

    @Override
    public E findByProperties(Map<String, Object> properties) throws TopiaException {
        TopiaQuery query = this.createQuery().addEquals(properties);
        E result = this.findByQuery(query);
        return result;
    }

    @Override
    public E findByQuery(TopiaQuery query) throws TopiaException {
        E result = query.executeToEntity(this.getContext(), this.getEntityClass());
        return result;
    }

    @Override
    public List<E> findAll() throws TopiaException {
        List<E> results = this.findAllByQuery(this.createQuery());
        return results;
    }

    @Override
    public List<String> findAllIds() throws TopiaException {
        TopiaQuery query = this.createQuery().setSelect("topiaId");
        List results = this.getContext().findByQuery(query);
        return results;
    }

    @Override
    public List<E> findAllByProperty(String propertyName, Object value) throws TopiaException {
        Map<String, Object> properties = this.convertPropertiesArrayToMap(propertyName, value, new Object[0]);
        List<E> result = this.findAllByProperties(properties);
        return result;
    }

    @Override
    public List<E> findAllByProperties(String propertyName, Object value, Object ... others) throws TopiaException {
        Map<String, Object> properties = this.convertPropertiesArrayToMap(propertyName, value, others);
        List<E> result = this.findAllByProperties(properties);
        return result;
    }

    @Override
    public List<E> findAllByProperties(Map<String, Object> properties) throws TopiaException {
        TopiaQuery query = this.createQuery().addEquals(properties);
        List<E> results = this.findAllByQuery(query);
        return results;
    }

    @Override
    public List<E> findAllByQuery(TopiaQuery query) throws TopiaException {
        List<E> results = query.executeToEntityList(this.getContext(), this.getEntityClass());
        return results;
    }

    @Override
    public Map<String, E> findAllMappedByQuery(TopiaQuery query) throws TopiaException {
        Map<String, E> results = query.executeToEntityMap(this.getContext(), this.getEntityClass());
        return results;
    }

    @Override
    public <K> Map<K, E> findAllMappedByQuery(TopiaQuery query, String keyName, Class<K> keyClass) throws TopiaException {
        Map<K, E> results = query.executeToEntityMap(this.getContext(), this.getEntityClass(), keyName, keyClass);
        return results;
    }

    @Override
    public List<E> findAllWithOrder(String ... propertyNames) throws TopiaException {
        TopiaQuery query = this.createQuery().addOrder(propertyNames);
        List<E> results = this.findAllByQuery(query);
        return results;
    }

    @Override
    public E findContains(String propertyName, Object property) throws TopiaException {
        TopiaQuery k = this.createQuery().addInElements(":K", propertyName).addParam("K", property);
        return this.findByQuery(k);
    }

    @Override
    public List<E> findAllContains(String propertyName, Object property) throws TopiaException {
        TopiaQuery k = this.createQuery().addInElements(":K", propertyName).addParam("K", property);
        return this.findAllByQuery(k);
    }

    @Override
    public boolean existByTopiaId(String id) throws TopiaException {
        boolean result = this.existByProperties("topiaId", id, new Object[0]);
        return result;
    }

    @Override
    public boolean existByProperties(String propertyName, Object propertyValue, Object ... others) throws TopiaException {
        Map<String, Object> properties = this.convertPropertiesArrayToMap(propertyName, propertyValue, others);
        TopiaQuery query = this.createQuery().addEquals(properties);
        boolean result = this.existByQuery(query);
        return result;
    }

    @Override
    public boolean existByQuery(TopiaQuery query) throws TopiaException {
        int count = this.countByQuery(query);
        boolean result = count > 0;
        return result;
    }

    @Override
    public long count() throws TopiaException {
        int result = this.countByQuery(this.createQuery());
        return result;
    }

    @Override
    public int countByQuery(TopiaQuery query) throws TopiaException {
        int result = query.executeCount(this.getContext());
        return result;
    }

    private Map<String, Object> convertPropertiesArrayToMap(String propertyName, Object propertyValue, Object ... others) throws IllegalArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, propertyValue);
        Object name = null;
        int i = 0;
        while (i < others.length) {
            try {
                name = others[i++];
                propertyValue = others[i++];
                properties.put((String)name, propertyValue);
            }
            catch (ClassCastException eee) {
                throw new IllegalArgumentException("Les noms des propri\u00e9t\u00e9s doivent \u00eatre des chaines et non pas " + propertyName.getClass().getName(), eee);
            }
            catch (ArrayIndexOutOfBoundsException eee) {
                throw new IllegalArgumentException("Le nombre d'argument n'est pas un nombre pair: " + (others.length + 2) + " La derni\u00e8re propri\u00e9t\u00e9 \u00e9tait: " + name, eee);
            }
        }
        return properties;
    }

    @Override
    public E findByPrimaryKey(Map<String, Object> keys) throws TopiaException {
        try {
            ClassMetadata meta = this.getClassMetadata();
            if (meta.hasNaturalIdentifier()) {
                E result = this.findByProperties(keys);
                return result;
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
        throw new TopiaException("La classe " + this.entityClass.getName() + " n'a pas de cle primaire naturelle");
    }

    @Override
    public E findByPrimaryKey(Object ... k) throws TopiaException {
        try {
            ClassMetadata meta = this.getClassMetadata();
            if (meta.hasNaturalIdentifier()) {
                int[] ikeys = meta.getNaturalIdentifierProperties();
                String[] pnames = meta.getPropertyNames();
                HashMap<String, Object> keys = new HashMap<String, Object>();
                for (int ikey : ikeys) {
                    keys.put(pnames[ikey], k[ikey]);
                }
                E result = this.findByProperties(keys);
                return result;
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
        throw new TopiaException("La classe " + this.entityClass.getName() + " n'a pas de cle primaire naturelle");
    }

    @Override
    public boolean existsByQuery(String hql, Object ... params) throws TopiaException {
        long count = this.countByQuery(hql, params);
        return count > 0L;
    }

    @Override
    public long countByQuery(String hql, Object ... params) throws TopiaException {
        Preconditions.checkNotNull((Object)StringUtils.isNotBlank((CharSequence)hql));
        Preconditions.checkArgument((boolean)hql.toUpperCase().trim().startsWith("SELECT COUNT("));
        return this.findByQuery(Long.class, hql, params);
    }

    @Override
    public E findByQuery(String hql, Object ... params) throws TopiaException {
        return (E)((TopiaEntity)this.findByQuery(this.getEntityClass(), hql, params));
    }

    @Override
    public <R> R findByQuery(Class<R> type, String hql, Object ... params) throws TopiaException {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)hql);
        Object unique = this.getContext().findUnique(hql, params);
        Preconditions.checkState((unique == null || type.isAssignableFrom(unique.getClass()) ? 1 : 0) != 0);
        return (R)unique;
    }

    @Override
    public List<E> findAllByQuery(String hql, Object ... params) throws TopiaException {
        return this.findAllByQuery(this.getEntityClass(), hql, params);
    }

    @Override
    public <R> List<R> findAllByQuery(Class<R> type, String hql, Object ... params) throws TopiaException {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)hql);
        List result = this.getContext().findAll(hql, params);
        return result;
    }

    @Override
    public Iterable<E> findAllLazyByQuery(String hql, Object ... params) throws TopiaException {
        return this.findAllLazyByQuery(this.batchSize, hql, params);
    }

    @Override
    public <R> Iterable<R> findAllLazyByQuery(Class<R> type, String hql, Object ... params) throws TopiaException {
        return this.findAllLazyByQuery(type, this.batchSize, hql, params);
    }

    @Override
    public Iterable<E> findAllLazyByQuery(int batchSize, String hql, Object ... params) throws TopiaException {
        return this.findAllLazyByQuery(this.getEntityClass(), batchSize, hql, params);
    }

    @Override
    public <R> Iterable<R> findAllLazyByQuery(Class<R> type, int batchSize, String hql, Object ... params) throws TopiaException {
        final FindAllIterator iterator = new FindAllIterator(this, type, batchSize, hql, params);
        return new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return iterator;
            }
        };
    }

    @Override
    public <R> List<R> findAllByQueryWithBound(Class<R> type, String hql, int startIndex, int endIndex, Object ... params) throws TopiaException {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)hql);
        List result = this.getContext().find(hql, startIndex, endIndex, params);
        return result;
    }

    @Override
    public List<E> findAllByQueryWithBound(String hql, int startIndex, int endIndex, Object ... params) throws TopiaException {
        return this.findAllByQueryWithBound(this.getEntityClass(), hql, startIndex, endIndex, params);
    }

    @Override
    public <R> List<R> findAllByQueryAndPager(Class<R> type, String hql, TopiaPagerBean pager, Object ... params) throws TopiaException {
        Preconditions.checkNotNull((Object)((Object)pager));
        Preconditions.checkNotNull((Object)hql);
        if (StringUtils.isNotBlank((CharSequence)pager.getSortColumn())) {
            hql = hql + " ORDER BY " + pager.getSortColumn();
            if (!pager.isSortAscendant()) {
                hql = hql + " DESC";
            }
        }
        List<R> result = this.findAllByQueryWithBound(type, hql, (int)pager.getRecordStartIndex(), (int)pager.getRecordEndIndex() - 1, params);
        return result;
    }

    @Override
    public List<E> findAllByQueryAndPager(String hql, TopiaPagerBean pager, Object ... params) throws TopiaException {
        return this.findAllByQueryAndPager(this.getEntityClass(), hql, pager, params);
    }

    @Override
    public void computeAndAddRecordsToPager(String hql, TopiaPagerBean pager, Object ... params) throws TopiaException {
        long records = this.countByQuery(hql, params);
        pager.setRecords(records);
        PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)pager);
    }

    Session getSession() throws TopiaException {
        return this.getContext().getHibernate();
    }

    ClassMetadata getClassMetadata() throws TopiaException {
        ClassMetadata meta = this.getContext().getHibernateFactory().getClassMetadata(this.entityClass);
        if (meta == null) {
            meta = this.getContext().getHibernateFactory().getClassMetadata(this.getTopiaEntityEnum().getImplementationFQN());
        }
        return meta;
    }

    public static class FindAllIterator<E extends TopiaEntity, R>
    implements Iterator<R> {
        protected Iterator<R> data;
        protected final TopiaDAO<E> dao;
        protected final Class<R> type;
        protected final String hql;
        protected final Object[] params;
        protected TopiaPagerBean pager;

        public FindAllIterator(TopiaDAO<E> dao, Class<R> type, int batchSize, String hql, Object ... params) {
            this.dao = dao;
            this.type = type;
            this.hql = hql;
            this.params = params;
            try {
                String hql2 = hql.toLowerCase();
                int i = hql2.indexOf("order by");
                if (i == -1) {
                    throw new IllegalStateException("must have a *order by* in hql, but did not find it in " + hql);
                }
                long count2 = dao.countByQuery("SELECT COUNT(*) " + hql.substring(0, i), params);
                this.pager = new TopiaPagerBean();
                this.pager.setRecords(count2);
                this.pager.setPageSize(batchSize);
                PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)this.pager);
            }
            catch (TopiaException e) {
                throw new TopiaRuntimeException(e);
            }
            this.data = Iterators.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            return this.data.hasNext() || (long)this.pager.getPageIndex() < this.pager.getPagesNumber();
        }

        @Override
        public R next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.data.hasNext()) {
                this.pager.setPageIndex(this.pager.getPageIndex() + 1);
                PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)this.pager);
                try {
                    this.data = this.dao.findAllByQueryAndPager(this.type, this.hql, this.pager, this.params).iterator();
                }
                catch (TopiaException e) {
                    throw new TopiaRuntimeException(e);
                }
            }
            R next = this.data.next();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support remove operation.");
        }
    }
}

