/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.framework.EntityFilter;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;

public class TopiaFilter
implements EntityFilter {
    private static final Log log = LogFactory.getLog(TopiaFilter.class);
    protected Integer startIndex;
    protected Integer endIndex;
    protected String orderBy;
    protected String referenceId;
    protected String referenceProperty;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Override
    public void setStartIndex(Integer startIndex) {
        Integer oldStartIndex = this.startIndex;
        this.startIndex = startIndex;
        this.propertyChangeSupport.firePropertyChange("startIndex", oldStartIndex, startIndex);
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public void setOrderBy(String orderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = orderBy;
        this.propertyChangeSupport.firePropertyChange("orderBy", oldOrderBy, orderBy);
    }

    @Override
    public Integer getEndIndex() {
        return this.endIndex;
    }

    @Override
    public void setEndIndex(Integer endIndex) {
        Integer oldEndIndex = this.endIndex;
        this.endIndex = endIndex;
        this.propertyChangeSupport.firePropertyChange("endIndex", oldEndIndex, endIndex);
    }

    @Override
    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    public void setReferenceId(String referenceId) {
        String oldReferenceId = this.referenceId;
        this.referenceId = referenceId;
        this.propertyChangeSupport.firePropertyChange("referenceId", oldReferenceId, referenceId);
    }

    @Override
    public void setReference(Object entity) throws IllegalArgumentException {
        if (!(entity instanceof TopiaEntity)) {
            throw new IllegalArgumentException("Can't set reference of type '" + entity.getClass().getName() + "' need a TopiaEntity");
        }
        this.setReferenceId(((TopiaEntity)entity).getTopiaId());
    }

    @Override
    public boolean hasReference() {
        return StringUtils.isNotEmpty((CharSequence)this.referenceId);
    }

    @Override
    public String getReferenceProperty() {
        return this.referenceProperty;
    }

    @Override
    public void setReferenceProperty(String referenceProperty) {
        String oldReferenceProperty = this.referenceProperty;
        this.referenceProperty = referenceProperty;
        this.propertyChangeSupport.firePropertyChange("referenceProperty", oldReferenceProperty, referenceProperty);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public boolean isClassReference(Class<?> entityClass) {
        boolean result;
        block4: {
            result = false;
            if (this.hasReference()) {
                try {
                    Class referenceClass = TopiaId.getClassName(this.referenceId);
                    if (referenceClass.isAssignableFrom(entityClass)) {
                        result = true;
                    }
                }
                catch (TopiaNotFoundException eee) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("ReferenceId '" + this.referenceId + "' is not a" + " compatible topiaId : " + eee.getMessage()));
                }
            }
        }
        return result;
    }

    @Override
    public void checkReference(Class<?> reference, boolean mandatory) throws IllegalArgumentException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("referenceClass to check : " + reference.getName()));
            log.trace((Object)("mandatory : " + mandatory));
            log.trace((Object)("filter hasReference : " + this.hasReference()));
            log.trace((Object)("filter isClassReference : " + this.isClassReference(reference)));
        }
        if (mandatory && !this.hasReference()) {
            throw new IllegalArgumentException("The filter reference of type '" + reference.getSimpleName() + "' is mandatory !");
        }
        if (this.hasReference() && !this.isClassReference(reference)) {
            throw new IllegalArgumentException("Reference filtered need to be a '" + reference.getSimpleName() + "' (referenceId = " + this.referenceId + ")");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TopiaFilter{").append("referenceProperty = '").append(this.referenceProperty).append("', startIndex = ").append(this.startIndex).append(", endIndex = ").append(this.endIndex).append(", orderBy = '").append(this.orderBy).append("' , referenceId = '").append(this.referenceId).append("'}");
        return builder.toString();
    }
}

