package org.nuiton.topiatest.beangen;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import org.nuiton.i18n.I18n;
import org.nuiton.topiatest.Personne;

public abstract class Voiture implements Vehicule, Serializable {

    private static final long serialVersionUID = 7219325390410626608L;

    public static final String PROPERTY_IMMATRICULATION = "immatriculation";

    public static final String PROPERTY_MODELE = "modele";

    public static final String PROPERTY_PROPRIETAIRE = "proprietaire";

    public static final String PROPERTY_ROUE = "roue";

    public static final String PROPERTY_SIEGE = "siege";

    protected int immatriculation;

    protected String modele;

    protected Personne proprietaire;

    protected Collection<Roue> roue;

    protected Collection<Siege> siege;

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    static {
    
        I18n.n_("topia.test.common.voiture");
        I18n.n_("topia.test.common.immatriculation");
        I18n.n_("topia.test.common.modele");
        I18n.n_("topia.test.common.proprietaire");
        I18n.n_("topia.test.common.roue");
        I18n.n_("topia.test.common.siege");
    }

    public int getImmatriculation() {
        return immatriculation;
    }

    public void setImmatriculation(int immatriculation) {
        int oldValue = getImmatriculation();
        this.immatriculation = immatriculation;
        firePropertyChange(PROPERTY_IMMATRICULATION, oldValue, immatriculation);
    }

    public String getModele() {
        return modele;
    }

    public void setModele(String modele) {
        String oldValue = getModele();
        this.modele = modele;
        firePropertyChange(PROPERTY_MODELE, oldValue, modele);
    }

    public Personne getProprietaire() {
        return proprietaire;
    }

    public void setProprietaire(Personne proprietaire) {
        Personne oldValue = getProprietaire();
        this.proprietaire = proprietaire;
        firePropertyChange(PROPERTY_PROPRIETAIRE, oldValue, proprietaire);
    }

    public Roue getRoue(int index) {
        Roue o = getChild(roue, index);
        return o;
    }

    public void addRoue(Roue roue) {
        getRoue().add(roue);
    
        firePropertyChange(PROPERTY_ROUE, null, roue);
    }

    public void addAllRoue(Collection<Roue> roue) {
        getRoue().addAll(roue);
    
        firePropertyChange(PROPERTY_ROUE, null, roue);
    }

    public boolean removeRoue(Roue roue) {
        boolean  removed = getRoue().remove(roue);
    
        if (removed) {
            firePropertyChange(PROPERTY_ROUE, roue, null);
      }
    
        return removed;
    }

    public boolean removeAllRoue(Collection<Roue> roue) {
        boolean  removed = getRoue().removeAll(roue);
    
        if (removed) {
            firePropertyChange(PROPERTY_ROUE, roue, null);
      }
    
        return removed;
    }

    public boolean containsRoue(Roue roue) {
        boolean contains = getRoue().contains(roue);
    
        return contains;
    }

    public boolean containsAllRoue(Collection<Roue> roue) {
        boolean  contains = getRoue().containsAll(roue);
    
        return contains;
    }

    public Collection<Roue> getRoue() {
        return roue;
    }

    public void setRoue(Collection<Roue> roue) {
        Collection<Roue> oldValue = getRoue();
        this.roue = roue;
        firePropertyChange(PROPERTY_ROUE, oldValue, roue);
    }

    public Siege getSiege(int index) {
        Siege o = getChild(siege, index);
        return o;
    }

    public void addSiege(Siege siege) {
        getSiege().add(siege);
    
        firePropertyChange(PROPERTY_SIEGE, null, siege);
    }

    public void addAllSiege(Collection<Siege> siege) {
        getSiege().addAll(siege);
    
        firePropertyChange(PROPERTY_SIEGE, null, siege);
    }

    public boolean removeSiege(Siege siege) {
        boolean  removed = getSiege().remove(siege);
    
        if (removed) {
            firePropertyChange(PROPERTY_SIEGE, siege, null);
      }
    
        return removed;
    }

    public boolean removeAllSiege(Collection<Siege> siege) {
        boolean  removed = getSiege().removeAll(siege);
    
        if (removed) {
            firePropertyChange(PROPERTY_SIEGE, siege, null);
      }
    
        return removed;
    }

    public boolean containsSiege(Siege siege) {
        boolean contains = getSiege().contains(siege);
    
        return contains;
    }

    public boolean containsAllSiege(Collection<Siege> siege) {
        boolean  contains = getSiege().containsAll(siege);
    
        return contains;
    }

    public Collection<Siege> getSiege() {
        return siege;
    }

    public void setSiege(Collection<Siege> siege) {
        Collection<Siege> oldValue = getSiege();
        this.siege = siege;
        firePropertyChange(PROPERTY_SIEGE, oldValue, siege);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }

    protected <T> T getChild(Collection<T> childs, int index) {
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                i++;
            }
        }
        return null;
    }

} //Voiture
