/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.jdbc.Work;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.framework.TopiaContextImplementor;

public abstract class TopiaSQLQuery<O> {
    protected abstract PreparedStatement prepareQuery(Connection var1) throws SQLException;

    protected abstract O prepareResult(ResultSet var1) throws SQLException;

    public O findSingleResult(TopiaContextImplementor tx) throws TopiaException {
        final ArrayList result = new ArrayList();
        tx.getHibernate().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                PreparedStatement ps = TopiaSQLQuery.this.prepareQuery(connection);
                try {
                    Object singleResult;
                    ResultSet set = ps.executeQuery();
                    if (set.next() && (singleResult = TopiaSQLQuery.this.prepareResult(set)) != null) {
                        result.add(singleResult);
                    }
                }
                catch (Exception e) {
                    throw new TopiaRuntimeException("Could not execute query", e);
                }
                finally {
                    ps.close();
                }
            }
        });
        return result.isEmpty() ? null : (O)result.get(0);
    }

    public List<O> findMultipleResult(TopiaContextImplementor tx) throws TopiaException {
        final ArrayList result = new ArrayList();
        tx.getHibernate().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                PreparedStatement ps = TopiaSQLQuery.this.prepareQuery(connection);
                try {
                    ResultSet set = ps.executeQuery();
                    while (set.next()) {
                        Object singleResult = TopiaSQLQuery.this.prepareResult(set);
                        if (singleResult == null) continue;
                        result.add(singleResult);
                    }
                }
                catch (Exception e) {
                    throw new TopiaRuntimeException("Could not execute query", e);
                }
                finally {
                    ps.close();
                }
            }
        });
        return result;
    }
}

