/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topiatest.deletetest.Party2DTO;

public class PersonneDTO extends Party2DTO implements Serializable {

    protected String topiaId;

    public String name;

    public String[] otherNames;

    public Gender gender;

    public Gender otherGender;

    public AddressDTO address;

    public Title[] title;

    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    public void setName(String value) {
        java.lang.String oldValue = this.name;
        this.name = value;
        p.firePropertyChange("name", oldValue, value);
    }

    public String getName() {
        return name;
    }

    public void setOtherNames(String[] values) {
        java.lang.String[] oldValues = this.otherNames;
        this.otherNames = values;
        p.firePropertyChange("otherNames", oldValues, values);
    }

    public String[] getOtherNames() {
        return otherNames;
    }

    public void setGender(Gender value) {
        org.nuiton.topiatest.Gender oldValue = this.gender;
        this.gender = value;
        p.firePropertyChange("gender", oldValue, value);
    }

    public Gender getGender() {
        return gender;
    }

    public void setOtherGender(Gender value) {
        org.nuiton.topiatest.Gender oldValue = this.otherGender;
        this.otherGender = value;
        p.firePropertyChange("otherGender", oldValue, value);
    }

    public Gender getOtherGender() {
        return otherGender;
    }

    public void setAddress(AddressDTO value) {
        org.nuiton.topiatest.AddressDTO oldValue = this.address;
        this.address = value;
        p.firePropertyChange("address", oldValue, value);
    }

    public AddressDTO getAddress() {
        return address;
    }

    public void setTitle(Title[] values) {
        org.nuiton.topiatest.Title[] oldValues = this.title;
        this.title = values;
        p.firePropertyChange("title", oldValues, values);
    }

    public Title[] getTitle() {
        return title;
    }

    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("otherNames", this.otherNames).
            append("gender", this.gender).
            append("otherGender", this.otherGender).
            append("address", this.address).
            append("title", this.title).
         toString();
        return result;
}

} //PersonneDTO
