/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class NaturalizedEntityDAOAbstract<E extends NaturalizedEntity> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)NaturalizedEntity.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.NaturalizedEntity;
    }

    public E findByNaturalId(Integer naturalIdNotNull, String naturalIdNull) throws TopiaException {
        return findByProperties(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

    public boolean existByNaturalId(Integer naturalIdNotNull, String naturalIdNull) throws TopiaException {
        return existByProperties(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param naturalIdNotNull 
     * @param naturalIdNull 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(Integer naturalIdNotNull, String naturalIdNull) throws TopiaException {
        return create(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

    public E createByNaturalId(Integer naturalIdNotNull, String naturalIdNull) throws TopiaException {
        return create(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

    public E createByNotNull(Integer naturalIdNotNull) throws TopiaException {
        return create(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull);
    }

    public E findByNaturalIdNotNull(Integer v) throws TopiaException {
        E result = findByProperty(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, v);
        return result;
    }

    public List<E> findAllByNaturalIdNotNull(Integer v) throws TopiaException {
        List<E> result = findAllByProperty(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, v);
        return result;
    }

    public E findByNaturalIdNull(String v) throws TopiaException {
        E result = findByProperty(NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, v);
        return result;
    }

    public List<E> findAllByNaturalIdNull(String v) throws TopiaException {
        List<E> result = findAllByProperty(NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //NaturalizedEntityDAOAbstract<E extends NaturalizedEntity>
