/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class BillDAOAbstract<E extends Bill> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Bill.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Bill;
    }

    public E findByCost(int v) throws TopiaException {
        E result = findByProperty(Bill.PROPERTY_COST, v);
        return result;
    }

    public List<E> findAllByCost(int v) throws TopiaException {
        List<E> result = findAllByProperty(Bill.PROPERTY_COST, v);
        return result;
    }

    public E findByDate(Date v) throws TopiaException {
        E result = findByProperty(Bill.PROPERTY_DATE, v);
        return result;
    }

    public List<E> findAllByDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Bill.PROPERTY_DATE, v);
        return result;
    }

    public E findByPaid(Boolean v) throws TopiaException {
        E result = findByProperty(Bill.PROPERTY_PAID, v);
        return result;
    }

    public List<E> findAllByPaid(Boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Bill.PROPERTY_PAID, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //BillDAOAbstract<E extends Bill>
