/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia.test.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PersonDAOAbstract<E extends Person> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Person.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Person;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Pet> list = getContext()
                                                    .getDAO(Pet.class)
                                                    .findAllByProperties(Pet.PROPERTY_PERSON, entity);
                                            for (Pet item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPerson())) {
                                                    item.setPerson(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Person.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Person.PROPERTY_NAME, v);
        return result;
    }

    public E findByFirstname(String v) throws TopiaException {
        E result = findByProperty(Person.PROPERTY_FIRSTNAME, v);
        return result;
    }

    public List<E> findAllByFirstname(String v) throws TopiaException {
        List<E> result = findAllByProperty(Person.PROPERTY_FIRSTNAME, v);
        return result;
    }

    public E findContainsPet(Pet v) throws TopiaException {
        E result = findContains(Person.PROPERTY_PET, v);
        return result;
    }

    public List<E> findAllContainsPet(Pet v) throws TopiaException {
        List<E> result = findAllContains(Person.PROPERTY_PET, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Pet.class) {
            PetDAO dao = (PetDAO)
                getContext().getDAO(Pet.class);
            tmp = dao.findAllByPerson(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Pet.class, entity);
        if (!list.isEmpty()) {
            result.put(Pet.class, list);
        }

        return result;
    }

} //PersonDAOAbstract<E extends Person>
