/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia.test.ano1882;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class FrenchCompanyDAOAbstract<E extends FrenchCompany> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)FrenchCompany.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.FrenchCompany;
    }

    public E findBysIREN(SIREN v) throws TopiaException {
        E result = findByProperty(FrenchCompany.PROPERTY_S_IREN, v);
        return result;
    }

    public List<E> findAllBysIREN(SIREN v) throws TopiaException {
        List<E> result = findAllByProperty(FrenchCompany.PROPERTY_S_IREN, v);
        return result;
    }

    public E findContainssIRET(SIRET v) throws TopiaException {
        E result = findContains(FrenchCompany.PROPERTY_S_IRET, v);
        return result;
    }

    public List<E> findAllContainssIRET(SIRET v) throws TopiaException {
        List<E> result = findAllContains(FrenchCompany.PROPERTY_S_IRET, v);
        return result;
    }

    public E findBySIREN2(SIREN v) throws TopiaException {
        E result = findByProperty(FrenchCompany.PROPERTY_SIREN2, v);
        return result;
    }

    public List<E> findAllBySIREN2(SIREN v) throws TopiaException {
        List<E> result = findAllByProperty(FrenchCompany.PROPERTY_SIREN2, v);
        return result;
    }

    public E findContainsSIRET2(SIRET v) throws TopiaException {
        E result = findContains(FrenchCompany.PROPERTY_SIRET2, v);
        return result;
    }

    public List<E> findAllContainsSIRET2(SIRET v) throws TopiaException {
        List<E> result = findAllContains(FrenchCompany.PROPERTY_SIRET2, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //FrenchCompanyDAOAbstract<E extends FrenchCompany>
