package org.nuiton.topiatest.beangen;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.nuiton.i18n.I18n;
import org.nuiton.topiatest.Product;


public  abstract class Roue implements Serializable {

    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_VOITURE = "voiture";
    protected Voiture voiture;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);;
static {
    
        I18n.n_("topia.test.common.roue");
        I18n.n_("topia.test.common.voiture");
    }
    /**
     * getVoiture :
     * @return Voiture 
     */

    public Voiture getVoiture() {
        return voiture;
    }

    /**
     * setVoiture :
     * @param voiture 
     */

    public void setVoiture(Voiture voiture) {
        Voiture oldValue = getVoiture();
        this.voiture = voiture;
        firePropertyChange(PROPERTY_VOITURE, oldValue, voiture);
    }

    /**
     * mount :
     */

    public abstract void mount();

    /**
     * getModel :
     * @param id 
     * @return Product 
     */

    public abstract Product getModel(String id);

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * firePropertyChange :
     * @param propertyName 
     * @param oldValue 
     * @param newValue 
     */

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    /**
     * firePropertyChange :
     * @param propertyName 
     * @param newValue 
     */

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }


} //Roue
