/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;

public class TopiaConnectionProvider
implements ConnectionProvider {
    private static final Log log = LogFactory.getLog(TopiaConnectionProvider.class);
    private String url;
    private Properties connectionProps;
    private Integer isolation;
    private boolean autocommit;
    private int poolSize;
    private final List<Connection> pool = new ArrayList<Connection>();

    public void configure(Properties props) throws HibernateException {
        String driverClass = props.getProperty("hibernate.connection.driver_class");
        this.poolSize = PropertiesHelper.getInt((String)"hibernate.connection.pool_size", (Properties)props, (int)20);
        if (log.isInfoEnabled()) {
            log.info((Object)"Using Hibernate built-in connection pool (not for production use!)");
            log.info((Object)("Hibernate connection pool size: " + this.poolSize));
        }
        this.autocommit = PropertiesHelper.getBoolean((String)"hibernate.connection.autocommit", (Properties)props);
        if (log.isInfoEnabled()) {
            log.info((Object)("autocommit mode: " + this.autocommit));
        }
        this.isolation = PropertiesHelper.getInteger((String)"hibernate.connection.isolation", (Properties)props);
        if (this.isolation != null && log.isInfoEnabled()) {
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString((int)this.isolation)));
        }
        if (driverClass == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"no JDBC Driver class was specified by property hibernate.connection.driver_class");
            }
        } else {
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    ReflectHelper.classForName((String)driverClass);
                }
                catch (ClassNotFoundException e) {
                    String msg = "JDBC Driver class not found: " + driverClass;
                    log.error((Object)msg, (Throwable)e);
                    throw new HibernateException(msg, (Throwable)e);
                }
            }
        }
        this.url = props.getProperty("hibernate.connection.url");
        if (this.url == null) {
            String msg = "JDBC URL was not specified by property hibernate.connection.url";
            if (log.isErrorEnabled()) {
                log.error((Object)msg);
            }
            throw new HibernateException(msg);
        }
        this.connectionProps = ConnectionProviderFactory.getConnectionProperties((Properties)props);
        if (log.isInfoEnabled()) {
            log.info((Object)("using driver: " + driverClass + " at URL: " + this.url));
        }
        if (log.isDebugEnabled()) {
            log.info((Object)("connection properties: " + this.connectionProps));
        } else if (log.isInfoEnabled()) {
            log.info((Object)("connection properties: " + PropertiesHelper.maskOut((Properties)this.connectionProps, (String)"password")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Connection connection = null;
        List<Connection> list = this.pool;
        synchronized (list) {
            while (!this.pool.isEmpty() && connection == null) {
                int last = this.pool.size() - 1;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("using pooled JDBC connection, pool size: " + last));
                }
                if (!(connection = this.pool.remove(last)).isClosed()) continue;
                connection = null;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Remove already closed connection from pool " + connection));
            }
        }
        if (connection == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("opening new JDBC connection to " + this.url));
            }
            connection = DriverManager.getConnection(this.url, this.connectionProps);
        }
        if (this.isolation != null) {
            connection.setTransactionIsolation(this.isolation);
        }
        if (connection.getAutoCommit() != this.autocommit) {
            connection.setAutoCommit(this.autocommit);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection conn) throws SQLException {
        if (conn.isClosed()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connection [" + conn + "] alreay closed!, will not use it any longer "));
            }
            return;
        }
        List<Connection> list = this.pool;
        synchronized (list) {
            int currentSize = this.pool.size();
            if (currentSize < this.getPoolSize()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("returning connection to pool, pool size: " + (currentSize + 1)));
                }
                this.pool.add(conn);
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"closing JDBC connection");
        }
        conn.close();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)("cleaning up connection pool: " + this.url));
        }
        for (Connection connection : this.pool) {
            try {
                connection.close();
            }
            catch (SQLException sqle) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"problem closing pooled connection", (Throwable)sqle);
            }
        }
        this.pool.clear();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public String getUrl() {
        return this.url;
    }

    public Properties getConnectionProps() {
        return this.connectionProps;
    }

    public Integer getIsolation() {
        return this.isolation;
    }

    public List<Connection> getPool() {
        return this.pool;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }
}

