/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.AbstractGenerator;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

public class TopiaGeneratorUtil
extends JavaGeneratorUtil {
    private static final Log log = LogFactory.getLog(TopiaGeneratorUtil.class);
    public static final String STEREOTYPE_FACADE = "facade";
    public static final String STEREOTYPE_ENTITY = "entity";
    public static final String STEREOTYPE_DTO = "dto";
    @Deprecated
    public static final String STEREOTYPE_BEAN = "bean";
    public static final String STEREOTYPE_SERVICE = "service";
    public static final String STEREOTYPE_DAO = "dao";
    public static final String STEREOTYPE_INDEXED = "indexed";
    public static final String STEREOTYPE_UNIQUE = "unique";
    public static final String STEREOTYPE_PRIMARYKAY = "primaryKey";
    public static final String STEREOTYPE_ARRAY = "array";
    public static final String DEPENDENCIES_DAO = "dao";
    public static final String TAG_PERSISTENCE_TYPE = "persistenceType";
    public static final String TAG_DB_NAME = "dbName";
    public static final String TAG_SCHEMA_NAME = "dbSchema";
    public static final String TAG_LENGTH = "length";
    public static final String TAG_ANNOTATION = "annotation";
    public static final String TAG_COPYRIGHT = "copyright";
    public static final String TAG_ACCESS = "access";
    public static final String TAG_I18N_PREFIX = "i18n";
    public static final String TAG_NATURAL_ID = "naturalId";
    public static final String TAG_NATURAL_ID_MUTABLE = "naturalIdMutable";
    public static final String TAG_TRANSACTION = "transaction";
    public static final String TAG_ERROR_ARGS = "errorArgs";
    public static final String TAG_EXCEPTION_CLASS = "exceptionClass";
    public static final String TAG_INVERSE = "inverse";
    public static final String TAG_LAZY = "lazy";
    public static final String TAG_FETCH = "fetch";
    public static final String TAG_ORDER_BY = "orderBy";
    public static final String TAG_NOT_NULL = "notNull";
    public static final String TAG_EMBED_XML = "embedXml";
    public static final String TAG_PROXY_INTERFACE = "hibernateProxyInterface";
    public static final String TAG_SECURITY_CREATE = "securityCreate";
    public static final String TAG_SECURITY_LOAD = "securityLoad";
    public static final String TAG_SECURITY_UPDATE = "securityUpdate";
    public static final String TAG_SECURITY_DELETE = "securityDelete";
    public static final String TAG_NOT_GENERATE_TO_STRING = "notGenerateToString";
    public static final String TAG_SORT_ATTRIBUTE = "sortAttribute";
    public static final String TAG_GENERATE_OPERATOR_FOR_DAO_HELPER = "generateOperatorForDAOHelper";
    public static final String TAG_TYPE = "type";
    public static final String PERSISTENCE_TYPE_HIBERNATE = "hibernate";
    public static final String PERSISTENCE_TYPE_LDAP = "ldap";
    public static final String PERSISTENCE_TYPE_DEFAULT = "hibernate";
    public static final String PROPERTY_DEFAULT_PACKAGE = "defaultPackage";
    public static final String DEFAULT_PACKAGE = "org.codelutin.malo";
    private static final Set<String> numberTypes = new HashSet<String>();
    private static final Set<String> textTypes = new HashSet<String>();
    private static final Set<String> booleanTypes = new HashSet<String>();
    private static final Set<String> primitiveTypes = new HashSet<String>();
    private static final String VOID_TYPE = "void";
    public static final Comparator<ObjectModelClass> OBJECT_MODEL_CLASS_COMPARATOR;

    public static String getDefaultPackage(AbstractGenerator<?> generator) {
        String packageName = generator.getProperty(PROPERTY_DEFAULT_PACKAGE);
        if (packageName == null || "".equals(packageName)) {
            packageName = DEFAULT_PACKAGE;
        }
        return packageName;
    }

    public static ObjectModelInterface getDAOInterface(ObjectModelClass clazz, ObjectModel model) {
        for (ObjectModelInterface o : model.getInterfaces()) {
            ObjectModelInterface daoInterface = o;
            if (!daoInterface.getName().equals(clazz.getName() + "DAO") || !daoInterface.hasStereotype("dao")) continue;
            return daoInterface;
        }
        return null;
    }

    public static String getPersistenceType(ObjectModelElement element) {
        String tag = element.getTagValue(TAG_PERSISTENCE_TYPE);
        if (tag == null) {
            tag = "hibernate";
        }
        return tag;
    }

    public static String getReverseDBName(ObjectModelAttribute attr) {
        if (attr.getReverseAttribute() != null) {
            return TopiaGeneratorUtil.getDBName((ObjectModelElement)attr.getReverseAttribute());
        }
        return TopiaGeneratorUtil.getDBName((ObjectModelElement)attr) + "_id";
    }

    public static String getDBName(ObjectModelElement element) {
        if (element == null) {
            return null;
        }
        if (TopiaGeneratorUtil.notEmpty((String)element.getTagValue(TAG_DB_NAME))) {
            return element.getTagValue(TAG_DB_NAME);
        }
        return TopiaGeneratorUtil.toLowerCaseFirstLetter((String)element.getName());
    }

    public static String getSchemaName(ObjectModelElement element, ObjectModel model) {
        return TopiaGeneratorUtil.findTagValue((String)TAG_SCHEMA_NAME, (ObjectModelElement)element, (Model)model);
    }

    public static String getI18nPrefix(ObjectModelElement element, ObjectModel model) {
        return GeneratorUtil.findTagValue((String)TAG_I18N_PREFIX, (ObjectModelElement)element, (Model)model);
    }

    public static boolean shouldgenerateOperatorForDAOHelper(ObjectModelElement element, ObjectModel model) {
        String tagValue = GeneratorUtil.findTagValue((String)TAG_GENERATE_OPERATOR_FOR_DAO_HELPER, (ObjectModelElement)element, (Model)model);
        boolean generate = GeneratorUtil.notEmpty((String)tagValue) && Boolean.valueOf(tagValue) != false;
        return generate;
    }

    public static List<ObjectModelAttribute> getNaturalIdAttributes(ObjectModelClass clazz) {
        ArrayList<ObjectModelAttribute> results = new ArrayList<ObjectModelAttribute>();
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!TopiaGeneratorUtil.isNaturalId(attr)) continue;
            results.add(attr);
        }
        return results;
    }

    public static boolean generateToString(ObjectModelClass clazz, ObjectModel model) {
        String value = model.getTagValue(TAG_NOT_GENERATE_TO_STRING);
        if (value != null && !value.trim().isEmpty()) {
            return false;
        }
        value = clazz.getTagValue(TAG_NOT_GENERATE_TO_STRING);
        return value == null || value.trim().isEmpty();
    }

    public static boolean sortAttribute(ObjectModelClass clazz, ObjectModel model) {
        String value = clazz.getTagValue(TAG_SORT_ATTRIBUTE);
        if (value == null || value.trim().isEmpty() || "false".equals(value.trim())) {
            return false;
        }
        if ("true".equals(value.trim())) {
            return true;
        }
        value = model.getTagValue(TAG_SORT_ATTRIBUTE);
        if (value == null || value.trim().isEmpty() || "false".equals(value.trim())) {
            return false;
        }
        if ("true".equals(value.trim())) {
            return true;
        }
        return true;
    }

    public static boolean isNaturalId(ObjectModelAttribute attribute) {
        String value = attribute.getTagValue(TAG_NATURAL_ID);
        if (!GeneratorUtil.notEmpty((String)value)) {
            return false;
        }
        try {
            return Boolean.valueOf(value.trim());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getCopyright(Model model) {
        return TopiaGeneratorUtil.findTagValue((String)TAG_COPYRIGHT, null, (Model)model);
    }

    public static <Type extends ObjectModelElement> Collection<Type> getElementsWithStereotype(Collection<Type> elements, String ... stereotypes) {
        ArrayList<ObjectModelElement> result = new ArrayList<ObjectModelElement>();
        for (ObjectModelElement element : elements) {
            if (!TopiaGeneratorUtil.hasStereotypes(element, stereotypes)) continue;
            result.add(element);
        }
        return result;
    }

    public static boolean hasStereotypes(ObjectModelElement element, String ... stereotypes) {
        for (String stereotype : stereotypes) {
            if (element.hasStereotype(stereotype)) continue;
            return false;
        }
        return true;
    }

    public static String getPrimaryKeyAttributesListDeclaration(ObjectModelClass clazz, boolean includeName) {
        String attributes = "";
        Collection<ObjectModelAttribute> attributeCollection = TopiaGeneratorUtil.getElementsWithStereotype(clazz.getAttributes(), STEREOTYPE_PRIMARYKAY);
        for (ObjectModelAttribute attr : attributeCollection) {
            attributes = attributes + attr.getType();
            if (includeName) {
                attributes = attributes + ' ' + attr.getName();
            }
            attributes = attributes + ", ";
        }
        if (attributes.length() > 0) {
            attributes = attributes.substring(0, attributes.length() - 2);
        }
        return attributes;
    }

    public static boolean isAssociationClassDoublon(ObjectModelAttribute attr) {
        return attr.getReverseAttribute() != null && attr.getDeclaringElement().equals(attr.getReverseAttribute().getDeclaringElement()) && !GeneratorUtil.isFirstAttribute((ObjectModelAttribute)attr);
    }

    public static String getDOType(ObjectModelElement elem, ObjectModel model) {
        String type = elem.getName();
        if (elem instanceof ObjectModelAttribute) {
            type = ((ObjectModelAttribute)elem).getType();
        }
        if (elem instanceof ObjectModelClass) {
            type = ((ObjectModelClass)elem).getQualifiedName();
        }
        return TopiaGeneratorUtil.getDOType(type, model);
    }

    public static String getDOType(String type, ObjectModel model) {
        if (!model.hasClass(type)) {
            return type;
        }
        ObjectModelClass clazz = model.getClass(type);
        if (clazz.hasStereotype(STEREOTYPE_ENTITY)) {
            type = TopiaGeneratorUtil.shouldBeAbstract(clazz) ? type + "Abstract" : type + "Impl";
        }
        return type;
    }

    public static boolean isNumericType(ObjectModelAttribute attr) {
        return numberTypes.contains(attr.getType());
    }

    public static boolean isTextType(ObjectModelAttribute attr) {
        return textTypes.contains(attr.getType());
    }

    public static boolean isDateType(ObjectModelAttribute attr) {
        return "java.util.Date".equals(attr.getType());
    }

    public static boolean isBooleanType(ObjectModelAttribute attr) {
        return booleanTypes.contains(attr.getType());
    }

    public static boolean isPrimitiveType(ObjectModelAttribute attr) {
        return primitiveTypes.contains(attr.getType());
    }

    public static boolean hasNothingOrAbstractMethods(ObjectModelClass clazz) {
        boolean result = true;
        Iterator operations = clazz.getOperations().iterator();
        while (result && operations.hasNext()) {
            ObjectModelOperation op = (ObjectModelOperation)operations.next();
            result = op.isAbstract();
        }
        return result;
    }

    public static boolean shouldBeAbstract(ObjectModelClass clazz) {
        return clazz != null && clazz.isAbstract() && TopiaGeneratorUtil.hasNothingOrAbstractMethods(clazz);
    }

    public static boolean hasUnidirectionalRelationOnAbstractType(ObjectModelAttribute attr, ObjectModel model) {
        ObjectModelClass clazz;
        ObjectModelAttribute reverse = attr.getReverseAttribute();
        if (reverse != null && TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) && !TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse) && !reverse.isNavigable() && (clazz = model.getClass(attr.getType())) != null && clazz.hasStereotype(STEREOTYPE_ENTITY)) {
            for (ObjectModelClass subClass : model.getClasses()) {
                if (!subClass.getSuperclasses().contains(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getManyToManyTableName(ObjectModelAttribute attr) {
        String revers;
        String name;
        String result = attr.hasAssociationClass() ? TopiaGeneratorUtil.getDBName((ObjectModelElement)attr.getAssociationClass()) : ((name = attr.getName()).compareToIgnoreCase(revers = attr.getReverseAttributeName()) < 0 ? name + '_' + revers : revers + '_' + name);
        return result.toLowerCase();
    }

    public static String getNMultiplicityInterfaceType(ObjectModelAttribute attr) {
        if (attr.hasStereotype(STEREOTYPE_UNIQUE)) {
            return Set.class.getName();
        }
        if (attr.isIndexed() || attr.isOrdered()) {
            return List.class.getName();
        }
        return Collection.class.getName();
    }

    public static String getNMultiplicityObjectType(ObjectModelAttribute attr) {
        if (attr.hasStereotype(STEREOTYPE_UNIQUE)) {
            return HashSet.class.getName();
        }
        if (attr.isIndexed() || attr.isOrdered()) {
            return ArrayList.class.getName();
        }
        LinkedList.class.getName();
        return ArrayList.class.getName();
    }

    public static String getNMultiplicityHibernateType(ObjectModelAttribute attr) {
        if (attr.hasStereotype(STEREOTYPE_UNIQUE)) {
            return "set";
        }
        if (attr.isIndexed()) {
            return "list";
        }
        return "bag";
    }

    public static List<ObjectModelClass> getEntityClasses(ObjectModel model, boolean sort) {
        return TopiaGeneratorUtil.getClassesByStereotype(STEREOTYPE_ENTITY, model, sort);
    }

    public static List<ObjectModelClass> getClassesByStereotype(String stereotype, ObjectModel model, boolean sort) {
        ArrayList<ObjectModelClass> classes = new ArrayList<ObjectModelClass>();
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!clazz.hasStereotype(stereotype)) continue;
            classes.add(clazz);
        }
        if (sort && !classes.isEmpty()) {
            Collections.sort(classes, OBJECT_MODEL_CLASS_COMPARATOR);
        }
        return classes;
    }

    public static boolean isNaturalIdMutable(ObjectModelClass clazz) {
        String value = clazz.getTagValue(TAG_NATURAL_ID_MUTABLE);
        if (!TopiaGeneratorUtil.notEmpty((String)value)) {
            return false;
        }
        try {
            return Boolean.valueOf(value.trim());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<String> getImports(ObjectModelClass aClass, String ... incomingFqns) {
        HashSet<String> tmp = new HashSet<String>();
        tmp.addAll(Arrays.asList(incomingFqns));
        TopiaGeneratorUtil.getImports(aClass, tmp);
        List<String> result = TopiaGeneratorUtil.cleanImports(aClass.getPackageName(), tmp);
        return result;
    }

    public static List<String> getImports(ObjectModelInterface anInterface, String ... incomingFqns) {
        HashSet<String> tmp = new HashSet<String>();
        tmp.addAll(Arrays.asList(incomingFqns));
        TopiaGeneratorUtil.getImports(anInterface, tmp);
        List<String> result = TopiaGeneratorUtil.cleanImports(anInterface.getPackageName(), tmp);
        return result;
    }

    protected static void getImports(ObjectModelClass aClass, Set<String> fqns) {
        for (ObjectModelAttribute attr : aClass.getAttributes()) {
            fqns.add(attr.getType());
            if (!TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
            String collectionType = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
            fqns.add(collectionType);
            String collectionObject = TopiaGeneratorUtil.getNMultiplicityObjectType(attr);
            fqns.add(collectionObject);
        }
        for (ObjectModelAttribute attribute : aClass.getAllOtherAttributes()) {
            fqns.add(attribute.getType());
        }
        if (aClass instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)aClass;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                fqns.add(attr.getType());
                if (!TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
                String collectionType = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
                fqns.add(collectionType);
                String collectionObject = TopiaGeneratorUtil.getNMultiplicityObjectType(attr);
                fqns.add(collectionObject);
            }
        }
        for (ObjectModelOperation operation : aClass.getOperations()) {
            TopiaGeneratorUtil.getImports(operation, fqns);
        }
        for (ObjectModelInterface modelInterface : aClass.getInterfaces()) {
            fqns.add(modelInterface.getQualifiedName());
            TopiaGeneratorUtil.getImports(modelInterface, fqns);
        }
        for (ObjectModelClass modelClass : aClass.getSuperclasses()) {
            fqns.add(modelClass.getQualifiedName());
            TopiaGeneratorUtil.getImports(modelClass, new String[0]);
        }
    }

    protected static void getImports(ObjectModelInterface anInterface, Set<String> fqns) {
        for (ObjectModelOperation operation : anInterface.getOperations()) {
            TopiaGeneratorUtil.getImports(operation, fqns);
        }
        for (ObjectModelInterface modelInterface : anInterface.getInterfaces()) {
            fqns.add(modelInterface.getQualifiedName());
            TopiaGeneratorUtil.getImports(modelInterface, fqns);
        }
    }

    protected static void getImports(ObjectModelOperation operation, Set<String> fqns) {
        String fqn = operation.getReturnType();
        fqns.add(fqn);
        for (ObjectModelParameter parameter : operation.getParameters()) {
            fqns.add(parameter.getType());
        }
    }

    protected static List<String> cleanImports(String packageName, Set<String> fqns) {
        fqns.removeAll(primitiveTypes);
        fqns.remove(VOID_TYPE);
        int packageLength = packageName.length();
        ArrayList<String> genericType = new ArrayList<String>();
        Iterator<String> it = fqns.iterator();
        while (it.hasNext()) {
            String fqn = it.next();
            int lastIndex = fqn.lastIndexOf(".");
            if (lastIndex == packageLength && fqn.startsWith(packageName)) {
                it.remove();
                continue;
            }
            int genericIndex = fqn.indexOf(60);
            if (genericIndex == -1) continue;
            genericType.add(fqn.substring(0, genericIndex));
            it.remove();
        }
        fqns.addAll(genericType);
        ArrayList<String> result = new ArrayList<String>(fqns);
        Collections.sort(result);
        return result;
    }

    public static Map<ObjectModelClass, Set<ObjectModelClass>> searchDirectUsages(ObjectModel model) {
        List<ObjectModelClass> allEntities = TopiaGeneratorUtil.getEntityClasses(model, true);
        TreeMap<String, ObjectModelClass> allEntitiesByFQN = new TreeMap<String, ObjectModelClass>();
        LinkedHashMap<ObjectModelClass, Set<ObjectModelClass>> usages = new LinkedHashMap<ObjectModelClass, Set<ObjectModelClass>>();
        for (ObjectModelClass klass : allEntities) {
            usages.put(klass, new HashSet());
            allEntitiesByFQN.put(klass.getQualifiedName(), klass);
        }
        for (ObjectModelClass klass : allEntities) {
            TopiaGeneratorUtil.searchDirectUsages(klass, allEntitiesByFQN, usages);
        }
        allEntities.clear();
        allEntitiesByFQN.clear();
        return usages;
    }

    public static void searchDirectUsages(ObjectModelClass klass, Map<String, ObjectModelClass> allEntitiesByFQN, Map<ObjectModelClass, Set<ObjectModelClass>> usages) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("for entity " + klass.getQualifiedName()));
        }
        for (ObjectModelAttribute attr : klass.getAttributes()) {
            String type;
            if (!attr.isNavigable() || !allEntitiesByFQN.containsKey(type = attr.hasAssociationClass() ? attr.getAssociationClass().getQualifiedName() : attr.getType())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(" uses " + type));
            }
            ObjectModelClass targetEntity = allEntitiesByFQN.get(type);
            Set<ObjectModelClass> classes = usages.get(targetEntity);
            classes.add(klass);
        }
    }

    static {
        numberTypes.add("byte");
        numberTypes.add("java.lang.Byte");
        numberTypes.add("Byte");
        numberTypes.add("short");
        numberTypes.add("java.lang.Short");
        numberTypes.add("Short");
        numberTypes.add("int");
        numberTypes.add("java.lang.Integer");
        numberTypes.add("Integer");
        numberTypes.add("long");
        numberTypes.add("java.lang.Long");
        numberTypes.add("Long");
        numberTypes.add("float");
        numberTypes.add("java.lang.Float");
        numberTypes.add("Float");
        numberTypes.add("double");
        numberTypes.add("java.lang.Double");
        numberTypes.add("Double");
        textTypes.add("char");
        textTypes.add("java.lang.Char");
        textTypes.add("Char");
        textTypes.add("java.lang.String");
        textTypes.add("String");
        booleanTypes.add("boolean");
        booleanTypes.add("java.lang.Boolean");
        booleanTypes.add("Boolean");
        primitiveTypes.addAll(numberTypes);
        primitiveTypes.addAll(textTypes);
        primitiveTypes.addAll(booleanTypes);
        OBJECT_MODEL_CLASS_COMPARATOR = new Comparator<ObjectModelClass>(){

            @Override
            public int compare(ObjectModelClass o1, ObjectModelClass o2) {
                return o1.getQualifiedName().compareTo(o2.getQualifiedName());
            }
        };
    }
}

