/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelOperation;

public class EntityImplTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(EntityImplTransformer.class);

    public void transformFromClass(ObjectModelClass clazz) {
        if (!clazz.hasStereotype("entity")) {
            return;
        }
        if (clazz.getOperations().size() > 0 && !EntityImplTransformer.hasOnlyDAOOperations(clazz)) {
            return;
        }
        for (ObjectModelOperation otherOp : clazz.getAllOtherOperations(false)) {
            if (!otherOp.isAbstract()) continue;
            return;
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        ObjectModelClass result = this.isAbstract(clazz) ? this.createAbstractClass(clazzName + "Impl", clazz.getPackageName()) : this.createClass(clazzName + "Impl", clazz.getPackageName());
        this.setDocumentation((ObjectModelElement)result, "Implantation des operations pour l'entit\u00e9 " + clazzName + ".");
        this.setSuperClass(result, clazzFQN + "Abstract");
    }

    protected boolean isAbstract(ObjectModelClass clazz) {
        if (clazz.isAbstract()) {
            return true;
        }
        Collection allInterfaceOperations = clazz.getAllInterfaceOperations(true);
        allInterfaceOperations.removeAll(clazz.getAllOtherOperations(true));
        for (ObjectModelOperation op : allInterfaceOperations) {
            boolean implementationFound = false;
            for (ObjectModelClass superClazz : clazz.getSuperclasses()) {
                ObjectModelOperation matchingOp;
                Iterator i$ = superClazz.getOperations(op.getName()).iterator();
                while (i$.hasNext() && !(implementationFound = op.equals(matchingOp = (ObjectModelOperation)i$.next()) && !matchingOp.isAbstract())) {
                }
                if (!implementationFound) continue;
                break;
            }
            if (implementationFound) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(clazz.getName() + " : abstract operation " + op));
            }
            return true;
        }
        return false;
    }

    public static boolean hasOnlyDAOOperations(ObjectModelClass clazz) {
        boolean res = true;
        Collection operations = clazz.getOperations();
        if (operations.size() == 0) {
            res = false;
        }
        for (ObjectModelOperation op : operations) {
            res &= op.hasStereotype("dao");
        }
        return res;
    }
}

