/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.StringUtil;

public class TopiaQuery {
    private static final Log log = LogFactory.getLog(TopiaQuery.class);
    protected List<Object> params;
    protected StringBuilder select;
    protected boolean distinct;
    protected StringBuilder from;
    protected StringBuilder where;
    protected StringBuilder orderBy;
    protected StringBuilder groupBy;
    protected Integer startIndex;
    protected Integer endIndex;
    protected boolean parentheses = true;
    protected List<String> propertiesToLoad;
    protected String mainAlias;
    protected TopiaDAO<? extends TopiaEntity> dao;

    public TopiaQuery() {
    }

    public TopiaQuery(Class<? extends TopiaEntity> mainEntityClass) {
        this();
        this.setFrom(mainEntityClass);
    }

    public TopiaQuery(Class<? extends TopiaEntity> mainEntityClass, String alias) {
        this();
        this.setFrom(mainEntityClass, alias);
    }

    public TopiaQuery(TopiaDAO<? extends TopiaEntity> dao) {
        this();
        this.setFrom(dao.getEntityClass());
        this.dao = dao;
    }

    public TopiaQuery(TopiaDAO<? extends TopiaEntity> dao, String alias) {
        this();
        this.setFrom(dao.getEntityClass(), alias);
        this.dao = dao;
    }

    public TopiaQuery setFrom(Class<? extends TopiaEntity> mainEntityClass) {
        this.from = new StringBuilder(" FROM ").append(mainEntityClass.getName());
        return this;
    }

    public TopiaQuery setFrom(Class<? extends TopiaEntity> mainEntityClass, String alias) {
        this.setFrom(mainEntityClass);
        this.mainAlias = alias;
        this.from.append(' ').append(alias);
        return this;
    }

    public TopiaQuery addFrom(String str) {
        this.from.append(", ").append(str);
        return this;
    }

    public TopiaQuery addFrom(Class<? extends TopiaEntity> entityClass) {
        return this.addFrom(entityClass.getName());
    }

    public TopiaQuery addFrom(Class<? extends TopiaEntity> entityClass, String alias) {
        return this.addFrom(entityClass.getName() + " " + alias);
    }

    @Deprecated
    public static <T extends TopiaEntity> TopiaQuery createQuery(Class<T> entityClass) {
        return new TopiaQuery(entityClass);
    }

    @Deprecated
    public static <T extends TopiaEntity> TopiaQuery createQuery(TopiaDAO<T> dao) {
        return new TopiaQuery(dao);
    }

    @Deprecated
    public static <T extends TopiaEntity> TopiaQuery createQuery(Class<T> entityClass, String alias) {
        return new TopiaQuery(entityClass, alias);
    }

    @Deprecated
    public static <T extends TopiaEntity> TopiaQuery createQuery(TopiaDAO<T> dao, String alias) {
        return new TopiaQuery(dao, alias);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.fullQuery()).append("; (PARAMS : ").append(this.getParams()).append("); (LIMIT : ").append(this.startIndex).append(", ").append(this.endIndex).append(')');
        return result.toString();
    }

    public String fullQuery() {
        StringBuilder result = new StringBuilder();
        StringBuilder selectStatement = new StringBuilder("SELECT ");
        if (this.distinct) {
            selectStatement.append("DISTINCT ");
        }
        if (this.select != null) {
            result.append((CharSequence)selectStatement).append((CharSequence)this.select);
        } else if (StringUtils.contains((String)this.from.toString(), (char)',') && StringUtils.isNotEmpty((String)this.mainAlias)) {
            result.append((CharSequence)selectStatement).append(this.mainAlias);
        }
        result.append((CharSequence)this.from);
        if (this.where != null) {
            result.append((CharSequence)this.where);
        }
        if (this.groupBy != null) {
            result.append((CharSequence)this.groupBy);
        }
        if (this.orderBy != null) {
            result.append((CharSequence)this.orderBy);
        }
        return StringUtils.trim((String)result.toString());
    }

    public TopiaQuery addParam(String id, Object paramValue) {
        this.getParams().add(id);
        this.getParams().add(paramValue);
        return this;
    }

    public TopiaQuery addParams(List<Object> params) {
        for (int i = 0; i < params.size(); i += 2) {
            String paramName = (String)params.get(i);
            this.addParam(this.getValueName(paramName), params.get(i + 1));
        }
        return this;
    }

    public List<Object> getParams() {
        if (this.params == null) {
            this.params = new ArrayList<Object>();
        }
        return this.params;
    }

    public String getMainAlias() {
        return this.mainAlias;
    }

    public TopiaQuery addLoad(String ... properties) {
        this.getPropertiesToLoad().addAll(Arrays.asList(properties));
        return this;
    }

    protected List<String> getPropertiesToLoad() {
        if (this.propertiesToLoad == null) {
            this.propertiesToLoad = new ArrayList<String>();
        }
        return this.propertiesToLoad;
    }

    public TopiaQuery add(String where) {
        if (StringUtils.isEmpty((String)where)) {
            return this;
        }
        if (this.where == null) {
            this.where = new StringBuilder(" WHERE ");
        } else {
            this.where.append(" AND ");
        }
        if (this.parentheses) {
            this.where.append('(');
        }
        this.where.append(where);
        if (this.parentheses) {
            this.where.append(')');
        }
        this.parentheses = true;
        return this;
    }

    public TopiaQuery add(String paramName, Op constraint, Object paramValue) {
        StringBuilder result = new StringBuilder(paramName).append(' ');
        if (log.isDebugEnabled()) {
            log.debug((Object)("paramValue = " + paramValue));
        }
        if (paramValue == null) {
            result.append((Object)Op.NULL);
        } else {
            String valueName = this.getValueName(paramName);
            result.append((Object)constraint).append(" :").append(valueName);
            this.addParam(valueName, paramValue);
        }
        this.parentheses = false;
        return this.add(result.toString());
    }

    public TopiaQuery addNullOr(String paramName, Op constraint, Object paramValue) {
        String valueName = this.getValueName(paramName);
        StringBuilder result = new StringBuilder(paramName).append(' ').append((Object)Op.NULL).append(" OR ").append(paramName).append((Object)constraint).append(" :").append(valueName);
        this.addParam(valueName, paramValue);
        return this.add(result.toString());
    }

    protected String getValueName(String paramName) {
        int dot = paramName.lastIndexOf(46);
        String valueName = paramName;
        if (dot != -1) {
            valueName = paramName.substring(dot + 1);
        }
        if (this.getParams().contains(valueName)) {
            valueName = valueName + "_" + RandomStringUtils.randomAlphanumeric((int)4);
        }
        return valueName;
    }

    public TopiaQuery addNotNull(String paramName) {
        StringBuilder result = new StringBuilder(paramName).append(' ').append((Object)Op.NOT_NULL);
        return this.add(result.toString());
    }

    public TopiaQuery add(String paramName, Object ... paramValue) {
        int length = paramValue.length;
        if (length == 0) {
            return this;
        }
        if (length == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only one value " + Arrays.toString(paramValue)));
            }
            return this.add(paramName, Op.EQ, paramValue[0]);
        }
        StringBuilder values = new StringBuilder();
        int count = 1;
        boolean addNull = false;
        for (Object value : paramValue) {
            if (value != null) {
                String valueName = this.getValueName(paramName + count);
                if (count != 1) {
                    values.append(", ");
                }
                values.append(':').append(valueName);
                this.addParam(valueName, value);
                ++count;
                continue;
            }
            addNull = true;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(paramName).append(" IN(").append((CharSequence)values).append(")");
        if (addNull) {
            buffer.append(" OR ").append(paramName).append(' ').append(Op.NULL.toString());
        } else {
            this.parentheses = false;
        }
        return this.add(buffer.toString());
    }

    @Deprecated
    public TopiaQuery add(String paramName, Collection<Object> values, boolean isNull) {
        if (isNull) {
            values.add(null);
        }
        return this.add(paramName, values.toArray());
    }

    public TopiaQuery add(Map<String, Object> properties) {
        for (String key : properties.keySet()) {
            this.add(key, properties.get(key));
        }
        return this;
    }

    public TopiaQuery addSelect(String ... select) {
        String str = this.convertStringArray(select);
        if (this.mainAlias != null && str.equals(this.mainAlias)) {
            return this;
        }
        if (this.select != null) {
            this.select.append(", ");
        } else {
            this.select = this.mainAlias != null ? new StringBuilder(this.mainAlias).append(", ") : new StringBuilder();
        }
        this.select.append(this.convertStringArray(select));
        return this;
    }

    public TopiaQuery setSelect(String ... select) {
        this.select = new StringBuilder(this.convertStringArray(select));
        return this;
    }

    public TopiaQuery addDistinct() {
        this.distinct = true;
        return this;
    }

    public TopiaQuery addOrder(String ... order) {
        if (this.orderBy == null) {
            this.orderBy = new StringBuilder(" ORDER BY ");
        } else {
            this.orderBy.append(", ");
        }
        this.orderBy.append(this.convertStringArray(order));
        return this;
    }

    public TopiaQuery addOrderDesc(String order) {
        return this.addOrder(order + " DESC");
    }

    public TopiaQuery addGroup(String ... group) {
        if (this.groupBy == null) {
            this.groupBy = new StringBuilder(" GROUP BY ");
        } else {
            this.groupBy.append(", ");
        }
        this.groupBy.append(this.convertStringArray(group));
        return this;
    }

    protected String convertStringArray(String ... array) {
        StringBuilder result = new StringBuilder();
        for (String value : array) {
            result.append(", ").append(value);
        }
        String str = "";
        if (result.length() > 0) {
            str = result.substring(2);
        }
        return str;
    }

    public TopiaQuery setLimit(int start, int end) {
        this.startIndex = start;
        this.endIndex = end;
        return this;
    }

    public TopiaQuery resetLimit() {
        this.startIndex = null;
        this.endIndex = null;
        return this;
    }

    public TopiaQuery setMaxResults(int max) {
        return this.setLimit(0, max - 1);
    }

    public List execute(TopiaContext transaction) throws TopiaException {
        String query = this.fullQuery();
        if (log.isDebugEnabled()) {
            log.debug((Object)("# QUERY : " + query));
            if (this.params != null) {
                log.debug((Object)("# PARAMS : " + Arrays.toString(this.params.toArray())));
            }
        }
        if (this.startIndex != null && this.endIndex != null) {
            return transaction.find(query, this.startIndex, this.endIndex, this.getParams().toArray());
        }
        return transaction.find(query, this.getParams().toArray());
    }

    public List execute() throws TopiaException {
        this.validateDAO();
        return this.execute(this.dao.getContext());
    }

    public <E extends TopiaEntity> List<E> executeToEntityList(TopiaContext transaction, Class<E> entityClass) throws TopiaException, ClassCastException {
        List res = this.execute(transaction);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Properties to load : " + this.getPropertiesToLoad()));
        }
        ArrayList<TopiaEntity> results = new ArrayList<TopiaEntity>();
        for (Object o : res) {
            if (o == null) continue;
            if (o instanceof Object[]) {
                o = ((Object[])o)[0];
            }
            if (!entityClass.isAssignableFrom(o.getClass())) {
                throw new ClassCastException(o.getClass().getName() + " can't be cast to " + entityClass.getName() + " o : " + o);
            }
            TopiaEntity entity = (TopiaEntity)o;
            if (this.distinct && results.contains(entity)) continue;
            if (!this.getPropertiesToLoad().isEmpty()) {
                this.loadProperties(entity);
            }
            results.add(entity);
        }
        return results;
    }

    @Deprecated
    public <E extends TopiaEntity> List<E> executeToEntityList() throws TopiaException, ClassCastException {
        this.validateDAO();
        return this.dao.findAllByQuery(this);
    }

    public <E extends TopiaEntity, K> Map<K, E> executeToEntityMap(TopiaContext transaction, Class<E> entityClass, String keyName, Class<K> keyClass) throws TopiaException, ClassCastException {
        LinkedHashMap<Object, TopiaEntity> results = new LinkedHashMap<Object, TopiaEntity>();
        List<E> list = this.executeToEntityList(transaction, entityClass);
        for (TopiaEntity elmt : list) {
            Object value = this.loadProperty(elmt, keyName);
            if (value != null && !keyClass.isAssignableFrom(value.getClass())) {
                throw new ClassCastException(value.getClass().getName() + " can't be cast to " + keyClass.getName());
            }
            results.put(value, elmt);
        }
        return results;
    }

    @Deprecated
    public <E extends TopiaEntity, K> Map<K, E> executeToEntityMap(String keyName, Class<K> keyClass) throws TopiaException, ClassCastException {
        this.validateDAO();
        return this.dao.findAllMappedByQuery(this, keyName, keyClass);
    }

    public <E extends TopiaEntity> Map<String, E> executeToEntityMap(TopiaContext transaction, Class<E> entityClass) throws TopiaException, ClassCastException {
        return this.executeToEntityMap(transaction, entityClass, "topiaId", String.class);
    }

    @Deprecated
    public <E extends TopiaEntity> Map<String, E> executeToEntityMap() throws TopiaException, ClassCastException {
        this.validateDAO();
        return this.dao.findAllMappedByQuery(this);
    }

    public <E extends TopiaEntity> E executeToEntity(TopiaContext transaction, Class<E> entityClass) throws TopiaException, ClassCastException {
        this.setMaxResults(1);
        List<E> results = this.executeToEntityList(transaction, entityClass);
        this.resetLimit();
        return (E)(!results.isEmpty() ? (TopiaEntity)results.get(0) : null);
    }

    @Deprecated
    public <E extends TopiaEntity> E executeToEntity() throws TopiaException, ClassCastException {
        this.validateDAO();
        return (E)this.dao.findByQuery(this);
    }

    public Object executeToObject(TopiaContext transaction, String select) throws TopiaException {
        StringBuilder oldValue = this.select;
        if (!StringUtils.isEmpty((String)select)) {
            this.setSelect(select);
        }
        Object result = null;
        this.setMaxResults(1);
        List results = this.execute(transaction);
        if (!results.isEmpty()) {
            result = results.get(0);
        }
        this.select = oldValue;
        this.resetLimit();
        return result;
    }

    public int executeToInteger(TopiaContext transaction, String select) throws TopiaException {
        Long res = (Long)this.executeToObject(transaction, select);
        return res != null ? res.intValue() : 0;
    }

    public int executeToInteger(String select) throws TopiaException {
        this.validateDAO();
        return this.executeToInteger(this.dao.getContext(), select);
    }

    public String executeToString(TopiaContext transaction, String select) throws TopiaException {
        Object res = this.executeToObject(transaction, select);
        return res != null ? (String)res : "";
    }

    public String executeToString(String select) throws TopiaException {
        this.validateDAO();
        return this.executeToString(this.dao.getContext(), select);
    }

    public Object executeToObject(String select) throws TopiaException {
        this.validateDAO();
        return this.executeToObject(this.dao.getContext(), select);
    }

    public int executeCount(TopiaContext transaction) throws TopiaException {
        return this.executeToInteger(transaction, "COUNT(*)");
    }

    public int executeCount() throws TopiaException {
        this.validateDAO();
        return this.executeCount(this.dao.getContext());
    }

    protected boolean validateDAO() throws TopiaException {
        if (this.dao == null) {
            throw new TopiaException("DAO not defined in TopiaQuery, can't execute it without TopiaContext");
        }
        return true;
    }

    protected <T extends TopiaEntity> void loadProperties(T entity) throws TopiaException {
        for (String prop : this.getPropertiesToLoad()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("load property " + prop + " ..."));
            }
            List<String> str = Arrays.asList(prop.split("\\."));
            Iterator<String> it = str.iterator();
            Object currEntity = entity;
            while (it.hasNext()) {
                String s = it.next();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Current entity : " + currEntity.getClass().getSimpleName()));
                    log.trace((Object)("Current loading : " + s));
                }
                if (it.hasNext()) {
                    currEntity = this.loadEntityProperty(currEntity, s);
                    continue;
                }
                this.loadProperty(currEntity, s);
            }
        }
    }

    protected <T extends TopiaEntity> TopiaEntity loadEntityProperty(T entity, String property) throws TopiaException {
        return (TopiaEntity)this.loadProperty(entity, property);
    }

    protected <T extends TopiaEntity> Object loadProperty(T entity, String property) throws TopiaException {
        try {
            Object res = PropertyUtils.getProperty(entity, (String)property);
            if (log.isTraceEnabled()) {
                log.trace((Object)("load property '" + property + "' for '" + entity.getClass().getSimpleName() + "'"));
            }
            if (res != null && Collection.class.isAssignableFrom(res.getClass())) {
                Collection list = (Collection)res;
                list.size();
            }
            return res;
        }
        catch (IllegalAccessException eee) {
            throw new TopiaException("Illegal access on property " + property + " from entity " + entity.getClass().getName(), eee);
        }
        catch (InvocationTargetException eee) {
            throw new TopiaException("Invocation error on entity " + entity.getClass().getName() + " for property " + property, eee);
        }
        catch (NoSuchMethodException eee) {
            throw new TopiaException("Getter method does not exist for property " + property + " from entity " + entity.getClass().getName(), eee);
        }
    }

    protected void finalize() {
        this.select = null;
        this.from = null;
        this.where = null;
        this.orderBy = null;
        this.groupBy = null;
    }

    public static String getProperty(String ... entityProperty) {
        List<String> list = Arrays.asList(entityProperty);
        String result = StringUtil.join(list, (String)".", (boolean)false);
        return result;
    }

    public static enum Op {
        EQ("="),
        GT(">"),
        GE(">="),
        LIKE("LIKE"),
        LT("<"),
        LE("<="),
        NOT_NULL("IS NOT NULL"),
        NULL("IS NULL"),
        NEQ("!=");

        protected String value;

        private Op(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

